/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.filter;

import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.filter.Filter;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegExpFilter
implements Filter {
    public static final String TYPE = "RegExp";
    public static final String TYPE2 = "Matches";
    protected final String m_Name;
    protected final String m_RegExp;
    protected Pattern m_Pattern;
    protected DataSchema m_Schema;
    protected DataType m_DataType;
    protected int m_Index;

    public RegExpFilter(String string, String string2) {
        assert (string != null);
        assert (string2 != null);
        this.m_Name = string;
        this.m_RegExp = string2;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getValue() {
        return this.m_RegExp;
    }

    @Override
    public void buildParameters(ArgumentMap argumentMap) {
        argumentMap.extractParameters(this.m_RegExp);
    }

    @Override
    public void setSchema(PushContext pushContext, DataSchema dataSchema) {
        this.m_Schema = dataSchema;
        this.m_Index = this.m_Schema.getColumnIndex(this.m_Name);
        if (this.m_Index >= 0) {
            this.m_DataType = this.m_Schema.getColumnType(this.m_Index);
        }
        String string = pushContext.substitute(this.m_RegExp);
        try {
            this.m_Pattern = Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new RuntimeException("Error parsing pattern: " + string, patternSyntaxException);
        }
    }

    @Override
    public boolean accept(DataRecord dataRecord) {
        if (this.m_Index < 0) {
            return true;
        }
        Object object = dataRecord.getData(this.m_Index);
        if (object == null) {
            return false;
        }
        String string = this.m_Schema.format(this.m_DataType, object);
        return this.m_Pattern.matcher(string).find();
    }
}

