/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.jdbc;

import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.datasource.jdbc.JDBCDataSource;
import com.elixirtech.data2.datasource.jdbc.JDBCProcessor;
import com.elixirtech.data2.datasource.jdbc.StringCache;
import com.elixirtech.data2.iterator.IDataRecordIterator;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class JDBCDataIterator
implements IDataRecordIterator,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(JDBCDataIterator.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final JDBCDataSource ds;
    private final DataSchema schema;
    private final int columnCount;
    private final int[] m_ResultSetIndices;
    private final IndexedSeq columnTypes;
    private boolean m_HasNext;
    private final StringCache m_StringCache;
    private final DefaultPushContext cxt;
    private final JDBCProcessor m_Processor;
    private final ResultSet resultSet;

    public JDBCDataIterator(JDBCDataSource ds, Map<String, String> parameters) {
        this.ds = ds;
        this.schema = ds.getSchema();
        this.columnCount = this.schema().getColumnCount();
        this.m_ResultSetIndices = new int[this.columnCount()];
        this.columnTypes = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.columnCount()).map((Function1)(JFunction1.mcII.sp & Serializable)i -> this.schema().getColumnType(i).getTypeId());
        this.m_HasNext = false;
        this.m_StringCache = new StringCache();
        this.cxt = new DefaultPushContext();
        this.cxt().setParameters(CollectionConverters$.MODULE$.MapHasAsJava(parameters).asJava());
        this.m_Processor = new JDBCProcessor(ds);
        this.m_Processor().connect(this.cxt());
        this.resultSet = ds.isCallableStatement() ? (ResultSet)this.m_Processor().executeCallableStatement(this.cxt()) : this.m_Processor().executeStatement(this.cxt());
        this.advance();
        this.setupIndexes();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public DataSchema schema() {
        return this.schema;
    }

    public int columnCount() {
        return this.columnCount;
    }

    public IndexedSeq<Object> columnTypes() {
        return this.columnTypes;
    }

    public StringCache m_StringCache() {
        return this.m_StringCache;
    }

    public DefaultPushContext cxt() {
        return this.cxt;
    }

    public JDBCProcessor m_Processor() {
        return this.m_Processor;
    }

    public ResultSet resultSet() {
        return this.resultSet;
    }

    @Override
    public DataSchema getSchema() {
        return this.schema();
    }

    @Override
    public boolean hasNext() {
        return this.m_HasNext;
    }

    @Override
    public DataRecord next() {
        if (!this.m_HasNext) {
            throw new RuntimeException("No more records");
        }
        Object[] obj = new Object[this.columnCount()];
        boolean nullToString = this.ds.isNullsToStrings();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.columnCount()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            try {
                if (this.m_ResultSetIndices[i] >= 0) {
                    obj$1[i] = JDBCDataSource.getDataFromIndex(this.resultSet(), this.m_ResultSetIndices[i], BoxesRunTime.unboxToInt((Object)this.columnTypes().apply(i)), this.m_StringCache());
                }
                if (nullToString && Option$.MODULE$.apply(obj[i]).isEmpty() && BoxesRunTime.unboxToInt((Object)this.columnTypes().apply(i)) == 2) {
                    obj$1[i] = "";
                }
            }
            catch (Exception ex) {
                this.log().warn(() -> this.next$$anonfun$1$$anonfun$1(i), Line$.MODULE$.apply(51), FullName$.MODULE$.apply("com.elixirtech.data2.datasource.jdbc.JDBCDataIterator.next"));
            }
        });
        try {
            this.advance();
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error advancing in next: " + ex, ex);
        }
        return new DataRecord(this.schema(), obj);
    }

    @Override
    public void close() {
        this.m_Processor().close();
    }

    private void advance() {
        this.m_HasNext = this.resultSet().next();
    }

    private void setupIndexes() {
        Object object = Predef$.MODULE$.intArrayOps(this.m_ResultSetIndices);
        ArrayOps$.MODULE$.indices$extension(object).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            int n;
            Try try_ = Try$.MODULE$.apply(() -> this.setupIndexes$$anonfun$1$$anonfun$1(i));
            if (try_ instanceof Success) {
                int idx;
                n = idx = BoxesRunTime.unboxToInt((Object)((Success)try_).value());
            } else if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                this.log().warn(() -> this.setupIndexes$$anonfun$1$$anonfun$2(i), Line$.MODULE$.apply(77), FullName$.MODULE$.apply("com.elixirtech.data2.datasource.jdbc.JDBCDataIterator.setupIndexes"));
                n = -1;
            } else {
                throw new MatchError((Object)try_);
            }
            this.m_ResultSetIndices[i] = n;
        });
    }

    private final Object next$$anonfun$1$$anonfun$1(int i$1) {
        return "Can't get data from result set index " + this.m_ResultSetIndices[i$1] + " (" + this.schema().getColumnName(i$1) + ")";
    }

    private final int setupIndexes$$anonfun$1$$anonfun$1(int i$2) {
        return this.resultSet().findColumn(this.schema().getColumnName(i$2));
    }

    private final Object setupIndexes$$anonfun$1$$anonfun$2(int i$3) {
        return "Can't locate column '" + this.schema().getColumnName(i$3) + "'";
    }
}

