/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.jdbc;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.jdbc.JDBCConnector;
import com.elixirtech.data2.datasource.jdbc.JDBCConstants;
import com.elixirtech.data2.datasource.jdbc.JDBCDataSource;
import com.elixirtech.jdom.Element;

public class JDBCDefinition
extends DataSourceDefinition
implements JDBCConstants,
Data2Constants {
    public static final String CONNECTION_TYPE = "connection-type";
    public static final String RESOURCE_NAME = "resource-name";
    public static final String MAX_ROWS = "max-rows";
    public static final String TIMEOUT = "timeout";
    public static final String FETCH_SIZE = "fetch-size";
    public static final String READ_ONLY = "read-only";
    public static final String AUTO_COMMIT = "auto-commit";
    public static final String CALLABLE_STATEMENT = "callable-statement";
    public static final String OUT_TYPE = "out-type";
    public static final String SQL = "sql";
    public static final String IN_PARAM = "in-param";
    public static final String VALUE = "value";
    public static final String CONNECTION_REUSE = "connection-reuse";
    public static final String CONNECTION_POOL = "connection-pool";
    public static final String CONNECTION_POOL_TIMEOUT = "connection-pool-timeout";
    public static final String QB = "qb";
    public static final String PROPERTY = "property";
    public static final String TEST_MODE = "test-mode";
    public static final String NULLS_TO_STRINGS = "nulls-to-strings";
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(JDBCDefinition.class);

    @Override
    public IDataSource getDataSource(DataSourceManager dataSourceManager, Element element) throws DataException {
        String string;
        Object object;
        if (!"datasource".equals(element.getName()) || element.getNamespace() != NS_DATASOURCE) {
            throw new IllegalArgumentException("Element " + element.getName() + " is not a ds:datasource");
        }
        String string2 = element.getAttributeValue("name");
        Element element2 = element.getChild("schema", NS_DATASOURCE);
        if (element2 == null) {
            throw new DataException("Can't load schema");
        }
        DataSchema dataSchema = JDBCDefinition.loadSchema(element2);
        Element element3 = element.getChild("jdbc", NS_DATASOURCE);
        if (element3 == null) {
            throw new DataException("Can't load jdbc element");
        }
        Element element4 = element3.getChild(SQL, NS_DATASOURCE);
        if (element4 == null) {
            throw new DataException("Can't load jdbc/sql element");
        }
        Element element5 = element3.getChild(QB);
        JDBCDataSource jDBCDataSource = new JDBCDataSource(string2, dataSchema);
        jDBCDataSource.setQBXML(element5);
        jDBCDataSource.setDescription(element.getAttributeValue("description"));
        jDBCDataSource.setSecurity(this.loadSecurity(element));
        String string3 = element3.getAttributeValue(CONNECTION_TYPE);
        if ("POOL".equals(string3)) {
            object = new JDBCConnector.Pool();
            ((JDBCConnector.Pool)object).pool = element3.getAttributeValue(CONNECTION_POOL);
            try {
                string = element3.getAttributeValue(CONNECTION_POOL_TIMEOUT);
                ((JDBCConnector.Pool)object).timeout = Long.parseLong(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            jDBCDataSource.setConnector((JDBCConnector.Pool)object);
        } else {
            m_Log.warn((Object)(string2 + " unsupported connection type: " + string3));
            object = new JDBCConnector.Pool();
            ((JDBCConnector.Pool)object).pool = "";
            ((JDBCConnector.Pool)object).timeout = 0L;
            jDBCDataSource.setConnector((JDBCConnector.Pool)object);
        }
        jDBCDataSource.setSQL(element4.getText().trim());
        jDBCDataSource.setMaxRows(element3.getAttributeValue(MAX_ROWS));
        jDBCDataSource.setFetchSize(element3.getAttributeValue(FETCH_SIZE));
        jDBCDataSource.setTimeout(element3.getAttributeValue(TIMEOUT));
        jDBCDataSource.setCallableStatement("Yes".equals(element3.getAttributeValue(CALLABLE_STATEMENT)));
        jDBCDataSource.setOutTypeValue(element3.getAttributeValue(OUT_TYPE));
        jDBCDataSource.setNullsToStrings("Yes".equals(element3.getAttributeValue(NULLS_TO_STRINGS)));
        object = element3.getAttributeValue(READ_ONLY);
        if (StringUtil.notEmpty((String)object)) {
            jDBCDataSource.setReadOnly("Yes".equals(object));
        }
        if (StringUtil.notEmpty(string = element3.getAttributeValue(AUTO_COMMIT))) {
            jDBCDataSource.setAutoCommit("Yes".equals(string));
        }
        for (Element element6 : element3.getChildren(IN_PARAM, NS_DATASOURCE)) {
            String string4 = element6.getAttributeValue("type");
            String string5 = element6.getAttributeValue(VALUE);
            if (string4 == null || string5 == null) continue;
            jDBCDataSource.addInParameter(new JDBCDataSource.InParameter(string4, string5));
        }
        return jDBCDataSource;
    }

    @Override
    public Element setDataSource(IDataSource iDataSource) {
        Element element;
        if (!(iDataSource instanceof JDBCDataSource)) {
            throw new IllegalArgumentException("Not a JDBCDataSource");
        }
        JDBCDataSource jDBCDataSource = (JDBCDataSource)iDataSource;
        Element element2 = this.defineDataSource(jDBCDataSource);
        JDBCDefinition.saveSchema(jDBCDataSource.getSchema(), element2);
        this.saveSecurity(jDBCDataSource.getSecurity(), element2);
        Element element3 = new Element("jdbc", NS_DATASOURCE);
        JDBCConnector.Pool pool = jDBCDataSource.getConnector();
        JDBCDefinition.setAttribute(element3, CONNECTION_TYPE, "POOL");
        JDBCDefinition.setAttribute(element3, CONNECTION_POOL, pool.pool);
        JDBCDefinition.setAttribute(element3, CONNECTION_POOL_TIMEOUT, Long.toString(pool.timeout));
        JDBCDefinition.setAttribute(element3, MAX_ROWS, jDBCDataSource.getMaxRows());
        JDBCDefinition.setAttribute(element3, TIMEOUT, jDBCDataSource.getTimeout());
        JDBCDefinition.setAttribute(element3, FETCH_SIZE, jDBCDataSource.getFetchSize());
        JDBCDefinition.setAttribute(element3, CALLABLE_STATEMENT, jDBCDataSource.isCallableStatement());
        JDBCDefinition.setAttribute(element3, OUT_TYPE, jDBCDataSource.getOutTypeValue());
        JDBCDefinition.setAttribute(element3, CONNECTION_REUSE, Long.toString(jDBCDataSource.getReuseKeepAlive()));
        JDBCDefinition.setAttribute(element3, NULLS_TO_STRINGS, jDBCDataSource.isNullsToStrings());
        JDBCDefinition.setAttribute(element3, READ_ONLY, jDBCDataSource.isReadOnly());
        JDBCDefinition.setAttribute(element3, AUTO_COMMIT, jDBCDataSource.isAutoCommit());
        for (JDBCDataSource.InParameter object2 : jDBCDataSource.getInParameters()) {
            element = new Element(IN_PARAM, NS_DATASOURCE);
            element.setAttribute("type", object2.type.getTypeName());
            element.setAttribute(VALUE, object2.value);
            element3.addContent(element);
        }
        Element element4 = new Element(SQL, NS_DATASOURCE);
        element4.setText(jDBCDataSource.getSQL());
        element3.addContent(element4);
        element = jDBCDataSource.getQBXML();
        if (element != null) {
            element3.addContent((Element)element.clone());
        }
        element2.addContent(element3);
        return element2;
    }
}

