/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.mongodb;

import ambience.api.MongoDBConnectionPools;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data.DataConfig$;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.datasource.mongodb.MongoDBDataSource;
import com.elixirtech.data2.iterator.IDataRecordIterator;
import com.elixirtech.mongodb.RichMongoDatabase;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.mongodb.scala.MongoCollection;
import org.mongodb.scala.Observable;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.mongodb.scala.package$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;

public class MongoDBDataRecordIterator
implements IDataRecordIterator {
    private final MongoDBDataSource ds;
    private final DefaultPushContext cxt;
    private final String query;
    private final MongoDBConnectionPools api;
    private final Seq docs;
    private final Iterator iterator;

    public MongoDBDataRecordIterator(MongoDBDataSource ds, Map<String, String> parameters) {
        Nil$ nil$;
        this.ds = ds;
        this.cxt = new DefaultPushContext();
        this.cxt().setParameters(CollectionConverters$.MODULE$.MapHasAsJava(parameters).asJava());
        this.query = this.cxt().substitute(ds.getQuery());
        this.api = (MongoDBConnectionPools)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(MongoDBConnectionPools.class));
        Option<RichMongoDatabase> option = this.api().getDatabase(ds.getPool());
        if (option instanceof Some) {
            RichMongoDatabase pool = (RichMongoDatabase)((Some)option).value();
            MongoCollection cltn = pool.db().getCollection(ds.getCollection(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
            Future f = StringUtil.isEmpty(this.query()) ? package$.MODULE$.ObservableFuture(() -> MongoDBDataRecordIterator.$anonfun$1(cltn)).toFuture() : package$.MODULE$.ObservableFuture(() -> this.$anonfun$2(cltn)).toFuture();
            nil$ = (Seq)Await$.MODULE$.result((Awaitable)f, (Duration)DataConfig$.MODULE$.MongoTimeout());
        } else if (None$.MODULE$.equals(option)) {
            nil$ = scala.package$.MODULE$.Nil();
        } else {
            throw new MatchError(option);
        }
        this.docs = nil$;
        this.iterator = this.docs().iterator();
    }

    public DefaultPushContext cxt() {
        return this.cxt;
    }

    public String query() {
        return this.query;
    }

    public MongoDBConnectionPools api() {
        return this.api;
    }

    public Seq<Document> docs() {
        return this.docs;
    }

    public Iterator<Document> iterator() {
        return this.iterator;
    }

    @Override
    public DataSchema getSchema() {
        return this.ds.getSchema();
    }

    @Override
    public boolean hasNext() {
        return this.iterator().hasNext();
    }

    @Override
    public DataRecord next() {
        return this.ds.buildRecord((Document)this.iterator().next());
    }

    @Override
    public void close() {
    }

    private static final Observable $anonfun$1(MongoCollection cltn$1) {
        return cltn$1.find(DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
    }

    private final Observable $anonfun$2(MongoCollection cltn$2) {
        return cltn$2.find((Bson)Document$.MODULE$.apply(BsonDocument.parse((String)this.query())), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
    }
}

