/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.mongodb;

import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.mongodb.MongoDBDataSource;
import com.elixirtech.jdom.Element;

public class MongoDBDefinition
extends DataSourceDefinition {
    @Override
    public IDataSource getDataSource(DataSourceManager dataSourceManager, Element element) throws DataException {
        if (!"datasource".equals(element.getName()) || element.getNamespace() != NS_DATASOURCE) {
            throw new IllegalArgumentException("Element " + element.getName() + " is not a ds:datasource");
        }
        Element element2 = element.getChild("schema", NS_DATASOURCE);
        if (element2 == null) {
            throw new DataException("Can't load schema");
        }
        DataSchema dataSchema = MongoDBDefinition.loadSchema(element2);
        Element element3 = element.getChild("mongodb", NS_DATASOURCE);
        if (element3 == null) {
            throw new DataException("Can't load mongodb element");
        }
        MongoDBDataSource mongoDBDataSource = new MongoDBDataSource();
        mongoDBDataSource.setName(element.getAttributeValue("name"));
        mongoDBDataSource.setSchema(dataSchema);
        mongoDBDataSource.setDescription(element.getAttributeValue("description"));
        mongoDBDataSource.setPool(element3.getAttributeValue("pool"));
        mongoDBDataSource.setCollection(element3.getAttributeValue("collection"));
        mongoDBDataSource.setQuery(element3.getAttributeValue("query"));
        mongoDBDataSource.setSort(element3.getAttributeValue("sort"));
        mongoDBDataSource.setProjection(element3.getAttributeValue("projection"));
        mongoDBDataSource.setSecurity(this.loadSecurity(element));
        return mongoDBDataSource;
    }

    @Override
    public Element setDataSource(IDataSource iDataSource) throws DataException {
        if (!(iDataSource instanceof MongoDBDataSource)) {
            throw new IllegalArgumentException("Not a MongoDBDataSource");
        }
        MongoDBDataSource mongoDBDataSource = (MongoDBDataSource)iDataSource;
        Element element = this.defineDataSource(mongoDBDataSource);
        MongoDBDefinition.saveSchema(mongoDBDataSource.getSchema(), element);
        Element element2 = new Element("mongodb", NS_DATASOURCE);
        MongoDBDefinition.setAttribute(element2, "pool", mongoDBDataSource.getPool());
        MongoDBDefinition.setAttribute(element2, "collection", mongoDBDataSource.getCollection());
        MongoDBDefinition.setAttribute(element2, "query", mongoDBDataSource.getQuery());
        MongoDBDefinition.setAttribute(element2, "sort", mongoDBDataSource.getSort());
        MongoDBDefinition.setAttribute(element2, "projection", mongoDBDataSource.getProjection());
        element.addContent(element2);
        this.saveSecurity(mongoDBDataSource.getSecurity(), element);
        return element;
    }
}

