/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.object;

import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.object.ObjectDataSource;
import com.elixirtech.jdom.Element;

public class ObjectDefinition
extends DataSourceDefinition {
    @Override
    public IDataSource getDataSource(DataSourceManager dataSourceManager, Element element) throws DataException {
        if (!"datasource".equals(element.getName()) || element.getNamespace() != NS_DATASOURCE) {
            throw new IllegalArgumentException("Element " + element.getName() + " is not a ds:datasource");
        }
        String string = element.getAttributeValue("name");
        Element element2 = element.getChild("schema", NS_DATASOURCE);
        if (element2 == null) {
            throw new DataException("Can't load schema");
        }
        DataSchema dataSchema = ObjectDefinition.loadSchema(element2);
        Element element3 = element.getChild("object", NS_DATASOURCE);
        if (element3 == null) {
            throw new DataException("Can't load object element");
        }
        ObjectDataSource objectDataSource = new ObjectDataSource(string, dataSchema);
        objectDataSource.setDescription(element.getAttributeValue("description"));
        objectDataSource.setJavaScript(element3.getChildText("script", NS_DATASOURCE));
        objectDataSource.setSecurity(this.loadSecurity(element));
        return objectDataSource;
    }

    @Override
    public Element setDataSource(IDataSource iDataSource) throws DataException {
        if (!(iDataSource instanceof ObjectDataSource)) {
            throw new IllegalArgumentException("Not an ObjectDataSource");
        }
        ObjectDataSource objectDataSource = (ObjectDataSource)iDataSource;
        Element element = this.defineDataSource(objectDataSource);
        DataSchema dataSchema = objectDataSource.getSchema();
        if (dataSchema == null) {
            dataSchema = new DataSchema();
        }
        ObjectDefinition.saveSchema(dataSchema, element);
        Element element2 = new Element("object", NS_DATASOURCE);
        this.saveSecurity(objectDataSource.getSecurity(), element);
        Element element3 = new Element("script", NS_DATASOURCE);
        element3.setText(objectDataSource.getJavaScript());
        element2.addContent(element3);
        Element element4 = new Element("wizard", NS_DATASOURCE);
        element2.addContent(element4);
        element.addContent(element2);
        return element;
    }
}

