/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.debug;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IAdaptable;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataListener2;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.processor.BasicProcessor;
import com.elixirtech.data2.datasource.processor.ProcessorNode;
import com.elixirtech.data2.datasource.processor.debug.DebugNode;
import com.elixirtech.jdom.Element;
import java.io.IOException;

public class DebugProcessor
extends BasicProcessor {
    private DebugNode m_Node;
    private static int m_SerialId;
    static final ElxLoggerJ m_Log;

    @Override
    public String getName() {
        return "Debug";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getType() {
        return "Debug";
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        this.m_Parent.pushTo(pushContext, new DL2(pushContext, dataListener, this.getSerialId()));
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IAdaptable.class) {
            return clazz.cast(this);
        }
        if (clazz == IDataSource.class) {
            return clazz.cast(this);
        }
        return null;
    }

    @Override
    public void loadFrom(Element element) throws IOException {
        String string = element.getAttributeValue("type");
        if (!this.getType().equals(string)) {
            throw new IOException("Type " + this.getType() + " expected. Got " + string);
        }
        Element element2 = element.getChild("debug", Data2Constants.NS_DATASOURCE);
        String string2 = element2.getAttributeValue("name");
        String string3 = element2.getAttributeValue("inspect");
        this.m_Node = new DebugNode(string2, string3);
    }

    @Override
    public void saveTo(Element element) {
        element.setAttribute("type", this.getType());
        Element element2 = new Element("debug", Data2Constants.NS_DATASOURCE);
        if (this.m_Node != null) {
            element2.setAttribute("name", this.m_Node.getName());
            element2.setAttribute("inspect", this.m_Node.getInspectionString());
        }
        element.addContent(element2);
    }

    @Override
    public void setProcessorNode(ProcessorNode processorNode) {
        this.m_Node = (DebugNode)processorNode;
    }

    @Override
    public ProcessorNode getProcessorNode() {
        return this.m_Node;
    }

    public DebugNode getDebugNode() {
        return this.m_Node;
    }

    public synchronized int getSerialId() {
        return ++m_SerialId;
    }

    static {
        m_Log = ElxLoggerJ.getLogger(DebugProcessor.class);
    }

    private class DL2
    implements DataListener2 {
        private PushContext m_Context;
        private DataListener m_DataListener;
        private int m_RecordCount;
        private final int m_InstanceId;

        public DL2(PushContext pushContext, DataListener dataListener, int n) {
            this.m_Context = pushContext;
            this.m_DataListener = dataListener;
            this.m_InstanceId = n;
        }

        @Override
        public <T> T getAdapter(Class<T> clazz) {
            if (clazz == IAdaptable.class) {
                return clazz.cast(this);
            }
            if (clazz == IDataSource.class) {
                return clazz.cast(DebugProcessor.this.getOwner());
            }
            return null;
        }

        @Override
        public void startData(IDataSource iDataSource) {
            m_Log.info((Object)this.info("startData"));
            String string = DebugProcessor.this.getDebugNode().getInspectionString();
            if (StringUtil.notEmpty(string)) {
                m_Log.info((Object)this.info("inspect: " + this.m_Context.substitute(string)));
            }
            this.m_DataListener.startData(DebugProcessor.this);
        }

        @Override
        public void startGroup(DataGroup dataGroup) {
            m_Log.info((Object)this.info("startGroup"));
            this.m_DataListener.startGroup(dataGroup);
        }

        @Override
        public boolean processRecord(DataRecord dataRecord) {
            ++this.m_RecordCount;
            m_Log.info((Object)this.info("processRecord(" + this.m_RecordCount + ")"));
            return this.m_DataListener.processRecord(dataRecord);
        }

        @Override
        public void endGroup(DataGroup dataGroup) {
            m_Log.info((Object)this.info("endGroup"));
            this.m_DataListener.endGroup(dataGroup);
        }

        @Override
        public void endData(IDataSource iDataSource) {
            m_Log.info((Object)this.info("endData - total records: " + this.m_RecordCount));
            this.m_DataListener.endData(DebugProcessor.this);
        }

        private String info(String string) {
            return DebugProcessor.this.getDebugNode().getName() + ":" + this.m_InstanceId + " - " + string;
        }
    }
}

