/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.javascript;

import com.elixirtech.arch.IAdaptable;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.processor.BasicProcessor;
import com.elixirtech.data2.datasource.processor.ProcessorNode;
import com.elixirtech.data2.datasource.processor.javascript.JSDataListener;
import com.elixirtech.data2.datasource.processor.javascript.JavaScriptNode;
import com.elixirtech.jdom.Element;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class JavaScriptProcessor
extends BasicProcessor {
    private JavaScriptNode m_Node;
    private DataSchema m_Schema;

    @Override
    public ProcessorNode getProcessorNode() {
        return this.m_Node;
    }

    @Override
    public void loadFrom(Element element) throws IOException {
        String string = element.getAttributeValue("type");
        if (!this.getType().equals(string)) {
            throw new IOException("Type " + this.getType() + " expected. Got " + string);
        }
        Element element2 = element.getChild("javascript", Data2Constants.NS_DATASOURCE);
        this.m_Node = new JavaScriptNode();
        this.m_Node.setStartData(this.getScript(element2, "start-data"));
        this.m_Node.setStartGroup(this.getScript(element2, "start-group"));
        this.m_Node.setProcessRecord(this.getScript(element2, "process-record"));
        this.m_Node.setEndGroup(this.getScript(element2, "end-group"));
        this.m_Node.setEndData(this.getScript(element2, "end-data"));
        this.m_Schema = this.readSchema(element2);
        this.m_Node.setSchema(this.m_Schema);
    }

    @Override
    public void saveTo(Element element) {
        element.setAttribute("type", this.getType());
        Element element2 = new Element("javascript", Data2Constants.NS_DATASOURCE);
        if (this.m_Node != null) {
            this.setScript(element2, "start-data", this.m_Node.getStartData());
            this.setScript(element2, "start-group", this.m_Node.getStartGroup());
            this.setScript(element2, "process-record", this.m_Node.getProcessRecord());
            this.setScript(element2, "end-group", this.m_Node.getEndGroup());
            this.setScript(element2, "end-data", this.m_Node.getEndData());
        }
        if (this.m_Schema != null) {
            this.writeSchema(element2, this.m_Schema);
        }
        element.addContent(element2);
    }

    @Override
    public void setProcessorNode(ProcessorNode processorNode) {
        this.m_Node = (JavaScriptNode)processorNode;
        this.m_Schema = this.m_Node.getSchema();
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getName() {
        return "JavaScriptProcessor";
    }

    @Override
    public List<Parameter> getParameters() {
        if (this.m_Node != null) {
            ArgumentMap argumentMap = new ArgumentMap();
            argumentMap.extractParameters(this.m_Node.getStartData());
            argumentMap.extractParameters(this.m_Node.getStartGroup());
            argumentMap.extractParameters(this.m_Node.getProcessRecord());
            argumentMap.extractParameters(this.m_Node.getEndGroup());
            argumentMap.extractParameters(this.m_Node.getEndData());
            return argumentMap.getParameters();
        }
        return Collections.emptyList();
    }

    @Override
    public DataSchema getSchema() {
        return this.m_Schema;
    }

    @Override
    public String getType() {
        return "JavaScript";
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        JSDataListener jSDataListener = new JSDataListener(this, pushContext, dataListener);
        this.m_Parent.pushTo(pushContext, jSDataListener);
    }

    public DataRecord newRecordInstance() {
        Object[] objectArray = new Object[this.m_Schema.getColumnCount()];
        return new DataRecord(this.m_Schema, objectArray);
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IAdaptable.class) {
            return clazz.cast(this);
        }
        if (clazz == IDataSource.class) {
            return clazz.cast(this.m_Owner);
        }
        return null;
    }

    private DataSchema readSchema(Element element) {
        Element element2 = element.getChild("schema", Data2Constants.NS_DATASOURCE);
        if (element2 != null) {
            return DataSourceDefinition.loadSchema(element2);
        }
        return null;
    }

    private void writeSchema(Element element, DataSchema dataSchema) {
        DataSourceDefinition.saveSchema(dataSchema, element);
    }

    private String getScript(Element element, String string) {
        Element element2 = element.getChild(string, Data2Constants.NS_DATASOURCE);
        if (element2 == null) {
            return null;
        }
        return element2.getTextNormalize();
    }

    private void setScript(Element element, String string, String string2) {
        if (StringUtil.notEmpty(string2)) {
            Element element2 = new Element(string, Data2Constants.NS_DATASOURCE);
            element2.setText(string2);
            element.addContent(element2);
        }
    }
}

