/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.map;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.canvas.graph.Node;
import com.elixirtech.canvas.graph.RelCol;
import com.elixirtech.canvas.graph.RelType;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.data2.datasource.processor.ProcessorNode;
import com.elixirtech.ensemble.canvas.SchemaNode;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MapFieldNode
extends ProcessorNode {
    private DataSchema m_CachedSchema;
    protected IDataSource m_SourceDataSource;

    @Override
    public String getProcessorType() {
        return "MapField";
    }

    @Override
    public DataSchema getSchema(DataSchema dataSchema) {
        return this.getSchema();
    }

    public void setMap(Map<String, String> map) {
        this.setUserProperty("map-fields", StringUtil.toString(map));
    }

    public Map<String, String> getMap() {
        String string = this.getUserProperty("map-fields");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string == null) {
            return hashMap;
        }
        String[] stringArray = StringUtil.arrayOfSubstrings(string, ',');
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = StringUtil.keyAndValue(stringArray[i]);
            hashMap.put(stringArray2[0], stringArray2[1]);
        }
        return hashMap;
    }

    public void setReferenceDataSource(String string) {
        this.setUserProperty("ref-ds", string);
    }

    public String getReferenceDataSource() {
        return this.getUserProperty("ref-ds");
    }

    public DataSchema getSchema() {
        if (this.m_CachedSchema == null) {
            this.extractCachedSchema();
        }
        return this.m_CachedSchema;
    }

    public void setSchema(DataSchema dataSchema) {
        SchemaNode schemaNode = (SchemaNode)this.getNode(SchemaNode.class);
        if (schemaNode != null) {
            schemaNode.disconnect();
        }
        if (dataSchema != null) {
            schemaNode = new SchemaNode(dataSchema);
            this.connectTo(schemaNode, RelType.Owns);
        }
        this.m_CachedSchema = dataSchema;
    }

    private void extractCachedSchema() {
        SchemaNode schemaNode = (SchemaNode)this.getNode(SchemaNode.class);
        if (schemaNode != null) {
            this.m_CachedSchema = schemaNode.getSchema();
        }
    }

    private Node getNode(Class<SchemaNode> clazz) {
        RelCol relCol = this.getOutRelCol(RelType.Owns);
        for (Node node : relCol.getTargetElements()) {
            if (!node.getClass().equals(clazz)) continue;
            return node;
        }
        return null;
    }

    public static DataSchema inferSchema(MapFieldNode mapFieldNode, DataSchema dataSchema, DataSchema dataSchema2) {
        SchemaBuilder schemaBuilder = new SchemaBuilder(dataSchema);
        Map<String, String> map = mapFieldNode.getMap();
        Set<String> set = map.keySet();
        for (String string : set) {
            String string2 = map.get(string);
            schemaBuilder.rename(string, string2);
            int n = dataSchema.getColumnIndex(string);
            int n2 = dataSchema2.getColumnIndex(string2);
            DataType dataType = dataSchema2.getColumnType(n2);
            schemaBuilder.setDataType(n, dataType);
        }
        return schemaBuilder.getSchema();
    }
}

