/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.map;

import com.elixirtech.arch.IAdaptable;
import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.processor.BasicProcessor;
import com.elixirtech.data2.datasource.processor.ProcessorNode;
import com.elixirtech.data2.datasource.processor.map.MapFieldNode;
import com.elixirtech.jdom.Element;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MapFieldProcessor
extends BasicProcessor {
    public static String NAME = "MapField";
    private DataSchema m_Schema;
    private MapFieldNode m_Node;

    @Override
    public ProcessorNode getProcessorNode() {
        return this.m_Node;
    }

    @Override
    public void loadFrom(Element element) throws IOException {
        String string = element.getAttributeValue("type");
        if (!this.getType().equals(string)) {
            throw new IOException("Type " + this.getType() + " expected. Got " + string);
        }
        Element element2 = element.getChild("map-field", Data2Constants.NS_DATASOURCE);
        String string2 = element2.getAttributeValue("ref-ds", Data2Constants.NS_DATASOURCE);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Element element3 : element2.getChildren("map", Data2Constants.NS_DATASOURCE)) {
            String string3 = element3.getAttributeValue("from");
            String string4 = element3.getAttributeValue("to");
            hashMap.put(string3, string4);
        }
        this.m_Node = new MapFieldNode();
        this.m_Node.setReferenceDataSource(string2);
        this.m_Schema = this.readSchema(element2);
        this.m_Node.setSchema(this.m_Schema);
    }

    @Override
    public void saveTo(Element element) {
        element.setAttribute("type", this.getType());
        Element element2 = new Element("map-field", Data2Constants.NS_DATASOURCE);
        if (this.m_Node != null) {
            String string = this.m_Node.getReferenceDataSource();
            if (string != null) {
                element2.setAttribute("ref-ds", string);
            }
            element2.removeChildren("map", Data2Constants.NS_DATASOURCE);
            Map<String, String> map = this.m_Node.getMap();
            Set<String> set = map.keySet();
            for (String string2 : set) {
                Element element3 = new Element("map", Data2Constants.NS_DATASOURCE);
                element3.setAttribute("from", string2);
                element3.setAttribute("to", map.get(string2));
            }
        }
        if (this.m_Schema != null) {
            this.writeSchema(element2, this.m_Schema);
        }
        element.addContent(element2);
    }

    @Override
    public void setProcessorNode(ProcessorNode processorNode) {
        this.m_Node = (MapFieldNode)processorNode;
        this.m_Schema = this.m_Node.getSchema();
    }

    @Override
    public String getDescription() {
        return "Map field name";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public DataSchema getSchema() {
        return this.m_Schema;
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        Object[] objectArray;
        DataTable dataTable = DataTable.build(pushContext, this.m_Parent, this.m_Owner);
        DataSchema dataSchema = dataTable.getSchema();
        DataType[] dataTypeArray = new DataType[this.m_Schema.getColumnCount()];
        DataType[] dataTypeArray2 = new DataType[this.m_Schema.getColumnCount()];
        Map<String, String> map = this.m_Node.getMap();
        Set<String> set = map.keySet();
        for (String string : set) {
            objectArray = map.get(string);
            int n = dataSchema.getColumnIndex(string);
            int n2 = this.m_Schema.getColumnIndex((String)objectArray);
            dataTypeArray2[n2] = this.m_Schema.getColumnType(n2);
            dataTypeArray[n2] = dataSchema.getColumnType(n);
            if (dataTypeArray2[n2].getTypeId() != dataTypeArray[n2].getTypeId()) continue;
            dataTypeArray2[n2] = null;
            dataTypeArray[n2] = null;
        }
        DataRecord[] dataRecordArray = dataTable.getRecords();
        dataListener.startData(this);
        for (int i = 0; i < dataRecordArray.length; ++i) {
            objectArray = dataRecordArray[i].getData();
            Object[] objectArray2 = new Object[objectArray.length];
            for (int j = 0; j < objectArray2.length; ++j) {
                objectArray2[j] = dataTypeArray2[j] == null ? objectArray[j] : this.m_Schema.convert(dataTypeArray[j], objectArray[j], dataTypeArray2[j]);
            }
            DataRecord dataRecord = new DataRecord(this.m_Schema, objectArray2);
            boolean bl = dataListener.processRecord(dataRecord);
            if (!bl) break;
        }
        dataListener.endData(this);
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IAdaptable.class) {
            return clazz.cast(this);
        }
        if (clazz == IDataSource.class) {
            return clazz.cast(this.m_Owner);
        }
        return null;
    }

    private void writeSchema(Element element, DataSchema dataSchema) {
        DataSourceDefinition.saveSchema(dataSchema, element);
    }

    private DataSchema readSchema(Element element) {
        Element element2 = element.getChild("schema", Data2Constants.NS_DATASOURCE);
        if (element2 != null) {
            return DataSourceDefinition.loadSchema(element2);
        }
        return null;
    }
}

