/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.xml;

import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.xml.Merge;
import com.elixirtech.data2.datasource.xml.XMLDataSource;
import com.elixirtech.jdom.Element;

public class XMLDefinition
extends DataSourceDefinition {
    public static final String ROOT_XPATH = "root-xpath";
    public static final String RELATIVE_XPATH = "xpath";
    public static final String URL = "url";
    public static final String HUGE = "huge";
    public static final String XML = "xml";
    public static final String HTML = "html";
    public static final String EDIFACT = "edifact";
    public static final String COLUMN = "column";
    public static final String MERGE = "merge";

    @Override
    public IDataSource getDataSource(DataSourceManager dataSourceManager, Element element) throws DataException {
        if (!"datasource".equals(element.getName()) || element.getNamespace() != NS_DATASOURCE) {
            throw new IllegalArgumentException("Element " + element.getName() + " is not a ds:datasource");
        }
        String string = element.getAttributeValue("name");
        Element element2 = element.getChild("schema", NS_DATASOURCE);
        if (element2 == null) {
            throw new DataException("Can't load schema");
        }
        DataSchema dataSchema = XMLDefinition.loadSchema(element2);
        Element element3 = element.getChild(XML, NS_DATASOURCE);
        if (element3 == null) {
            throw new DataException("Can't load xml element");
        }
        XMLDataSource xMLDataSource = new XMLDataSource(string, dataSchema);
        xMLDataSource.setDescription(element.getAttributeValue("description"));
        xMLDataSource.setRootXPath(element3.getAttributeValue(ROOT_XPATH));
        xMLDataSource.setXML(element3.getText().trim());
        xMLDataSource.setURL(element3.getAttributeValue(URL));
        xMLDataSource.setHTML("Yes".equals(element3.getAttributeValue(HTML)));
        xMLDataSource.setHuge("Yes".equals(element3.getAttributeValue(HUGE)));
        xMLDataSource.setEDIFACT("Yes".equals(element3.getAttributeValue(EDIFACT)));
        int n = 0;
        for (Element element4 : element3.getChildren(COLUMN, NS_DATASOURCE)) {
            String string2 = element4.getAttributeValue(RELATIVE_XPATH);
            Merge merge = Merge.lookup(element4.getAttributeValue(MERGE));
            XMLDataSource.Column column = new XMLDataSource.Column(string2, merge);
            xMLDataSource.setColumn(n, column);
            ++n;
        }
        xMLDataSource.setSecurity(this.loadSecurity(element));
        return xMLDataSource;
    }

    @Override
    public Element setDataSource(IDataSource iDataSource) throws DataException {
        if (!(iDataSource instanceof XMLDataSource)) {
            throw new IllegalArgumentException("Not a XMLDataSource : " + iDataSource.getClass().getName());
        }
        XMLDataSource xMLDataSource = (XMLDataSource)iDataSource;
        Element element = this.defineDataSource(xMLDataSource);
        XMLDefinition.saveSchema(xMLDataSource.getSchema(), element);
        this.saveSecurity(xMLDataSource.getSecurity(), element);
        Element element2 = new Element(XML, NS_DATASOURCE);
        XMLDefinition.setAttribute(element2, ROOT_XPATH, xMLDataSource.getRootXPath());
        if (xMLDataSource.getXML() != null) {
            element2.setText(xMLDataSource.getXML());
        }
        XMLDefinition.setAttribute(element2, URL, xMLDataSource.getURL());
        if (xMLDataSource.isHTML()) {
            element2.setAttribute(HTML, "Yes");
        }
        if (xMLDataSource.isHuge()) {
            element2.setAttribute(HUGE, "Yes");
        }
        if (xMLDataSource.isEDIFACT()) {
            element2.setAttribute(EDIFACT, "Yes");
        }
        int n = xMLDataSource.getSchema().getColumnCount();
        for (int i = 0; i < n; ++i) {
            XMLDataSource.Column column = xMLDataSource.getColumn(i);
            Element element3 = new Element(COLUMN, NS_DATASOURCE);
            element3.setAttribute(RELATIVE_XPATH, column.getXPath());
            Merge merge = column.getMerge();
            if (merge != null) {
                element3.setAttribute(MERGE, merge.getName());
            }
            element2.addContent(element3);
        }
        element.addContent(element2);
        return element;
    }
}

