/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.function;

import com.elixirtech.data2.DataType;
import com.elixirtech.data2.DecimalHelper;
import com.elixirtech.data2.function.RangedFunction;
import java.math.BigDecimal;

public class DecimalPercentCount
implements RangedFunction {
    BigDecimal m_Total = BigDecimal.ZERO;
    BigDecimal m_Value = BigDecimal.ZERO;

    @Override
    public void setRange(Object[] objectArray) {
        int n = objectArray.length;
        this.m_Total = n == 0 ? BigDecimal.ZERO : new BigDecimal(n);
    }

    @Override
    public Object clone() {
        DecimalPercentCount decimalPercentCount = new DecimalPercentCount();
        decimalPercentCount.m_Total = this.m_Total;
        return decimalPercentCount;
    }

    @Override
    public String getName() {
        return "PercentCount";
    }

    @Override
    public void update(Object object) {
        this.m_Value = this.m_Value.add(BigDecimal.ONE);
    }

    @Override
    public void update(Object[] objectArray) {
        this.m_Value = this.m_Value.add(new BigDecimal(objectArray.length));
    }

    @Override
    public Object getResult() {
        if (this.m_Total == BigDecimal.ZERO) {
            return new BigDecimal(Double.NaN);
        }
        return this.m_Value.divide(this.m_Total, DecimalHelper.MATH_CONTEXT);
    }

    @Override
    public void reset() {
        this.m_Value = BigDecimal.ZERO;
    }

    @Override
    public String getResultName(String string) {
        return "PercentCount(" + string + ")";
    }

    @Override
    public DataType getResultType(DataType dataType) {
        return DataType.DECIMAL;
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass();
    }
}

