/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.function;

import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.function.RecordFunction;
import com.elixirtech.data2.function.Sum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

public abstract class FilteredDateSumFunction
implements RecordFunction {
    private String m_ColumnName;
    private int m_DateIndex = -2;
    private int m_ColumnIndex = -2;
    private Sum m_Sum = new Sum();
    protected Date m_CurrentDate = new Date();

    @Override
    public abstract Object clone();

    public abstract boolean valid(Date var1);

    protected FilteredDateSumFunction() {
    }

    @Override
    public void setColumnName(String string) {
        this.m_ColumnName = string;
    }

    @Override
    public void setColumnIndex(int n) {
        this.m_ColumnIndex = n;
    }

    @Override
    public Object getResult() {
        return this.m_Sum.getResult();
    }

    @Override
    public DataType getResultType(DataType dataType) {
        return this.m_Sum.getResultType(dataType);
    }

    @Override
    public void reset() {
        this.m_Sum.reset();
        this.m_CurrentDate = new Date();
    }

    @Override
    public void update(Object object) {
        Date date;
        Object[] objectArray;
        if (!(object instanceof DataRecord)) {
            throw new IllegalArgumentException("DataRecord required");
        }
        DataRecord dataRecord = (DataRecord)object;
        if (this.m_ColumnIndex == -2) {
            objectArray = dataRecord.getSchema();
            this.m_ColumnIndex = objectArray.getColumnIndex(this.m_ColumnName);
        }
        if (this.m_DateIndex == -2) {
            objectArray = dataRecord.getSchema();
            this.m_DateIndex = this.getDateIndex((DataSchema)objectArray);
        }
        if (this.m_ColumnIndex >= 0 && this.m_DateIndex >= 0 && this.valid(date = (Date)(objectArray = dataRecord.getData())[this.m_DateIndex])) {
            this.m_Sum.update(objectArray[this.m_ColumnIndex]);
        }
    }

    @Override
    public void update(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.update(objectArray[i]);
        }
    }

    private int getDateIndex(DataSchema dataSchema) {
        ArrayList<SchemaItem> arrayList = new ArrayList<SchemaItem>();
        int n = dataSchema.getColumnCount();
        for (int i = 0; i < n; ++i) {
            DataType dataType = dataSchema.getColumnType(i);
            if (dataType != DataType.DATE && dataType != DataType.TIMESTAMP) continue;
            arrayList.add(new SchemaItem(i, dataSchema.getColumnName(i)));
        }
        if (arrayList.isEmpty()) {
            return -1;
        }
        Collections.sort(arrayList);
        return ((SchemaItem)arrayList.get((int)0)).idx;
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass();
    }

    private static class SchemaItem
    implements Comparable<SchemaItem> {
        public final int idx;
        public final String name;

        public SchemaItem(int n, String string) {
            this.idx = n;
            this.name = string;
        }

        @Override
        public int compareTo(SchemaItem schemaItem) {
            return this.name.compareTo(schemaItem.name);
        }
    }
}

