/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.function;

import com.elixirtech.data2.DataType;
import com.elixirtech.data2.function.Average;
import com.elixirtech.data2.function.CommaSeparatedList;
import com.elixirtech.data2.function.CommaSeparatedSet;
import com.elixirtech.data2.function.Count;
import com.elixirtech.data2.function.CountDistinct;
import com.elixirtech.data2.function.DecimalAverage;
import com.elixirtech.data2.function.DecimalMedian;
import com.elixirtech.data2.function.DecimalNestedPercent;
import com.elixirtech.data2.function.DecimalNestedPercent100;
import com.elixirtech.data2.function.DecimalNestedPercentCount;
import com.elixirtech.data2.function.DecimalNestedPercentCount100;
import com.elixirtech.data2.function.DecimalPercent;
import com.elixirtech.data2.function.DecimalPercent100;
import com.elixirtech.data2.function.DecimalPercentCount;
import com.elixirtech.data2.function.DecimalPercentCount100;
import com.elixirtech.data2.function.DecimalProduct;
import com.elixirtech.data2.function.DecimalStandardDeviation;
import com.elixirtech.data2.function.DecimalSum;
import com.elixirtech.data2.function.DecimalVariance;
import com.elixirtech.data2.function.First;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.function.Last;
import com.elixirtech.data2.function.MTD;
import com.elixirtech.data2.function.Max;
import com.elixirtech.data2.function.Median;
import com.elixirtech.data2.function.Min;
import com.elixirtech.data2.function.NestedPercent;
import com.elixirtech.data2.function.NestedPercent100;
import com.elixirtech.data2.function.NestedPercentCount;
import com.elixirtech.data2.function.NestedPercentCount100;
import com.elixirtech.data2.function.NullFunction;
import com.elixirtech.data2.function.Percent;
import com.elixirtech.data2.function.Percent100;
import com.elixirtech.data2.function.PercentCount;
import com.elixirtech.data2.function.PercentCount100;
import com.elixirtech.data2.function.Product;
import com.elixirtech.data2.function.StandardDeviation;
import com.elixirtech.data2.function.Sum;
import com.elixirtech.data2.function.Variance;
import com.elixirtech.data2.function.YTD;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class FunctionFactory {
    private static final Function FN_AVERAGE = new Average();
    private static final Function FN_COMMA_SEPARATED_LIST = new CommaSeparatedList();
    private static final Function FN_COMMA_SEPARATED_SET = new CommaSeparatedSet();
    private static final Function FN_COUNT = new Count();
    private static final Function FN_COUNT_DISTINCT = new CountDistinct();
    private static final Function FN_FIRST = new First();
    private static final Function FN_LAST = new Last();
    private static final Function FN_MAX = new Max();
    private static final Function FN_MEDIAN = new Median();
    private static final Function FN_MIN = new Min();
    private static final Function FN_NULL = new NullFunction();
    private static final Function FN_PERCENT = new Percent();
    private static final Function FN_PERCENT_COUNT = new PercentCount();
    private static final Function FN_PERCENT100 = new Percent100();
    private static final Function FN_PERCENT_COUNT100 = new PercentCount100();
    private static final Function FN_PRODUCT = new Product();
    private static final Function FN_STANDARD_DEVIATION = new StandardDeviation();
    private static final Function FN_SUM = new Sum();
    private static final Function FN_VARIANCE = new Variance();
    private static final Function FN_NESTED_PERCENT = new NestedPercent();
    private static final Function FN_NESTED_PERCENT_COUNT = new NestedPercentCount();
    private static final Function FN_NESTED_PERCENT100 = new NestedPercent100();
    private static final Function FN_NESTED_PERCENT_COUNT100 = new NestedPercentCount100();
    private static final Function FN_YTD = new YTD();
    private static final Function FN_MTD = new MTD();
    private static final Function FN_DEC_AVERAGE = new DecimalAverage();
    private static final Function FN_DEC_MEDIAN = new DecimalMedian();
    private static final Function FN_DEC_PERCENT = new DecimalPercent();
    private static final Function FN_DEC_PERCENT_COUNT = new DecimalPercentCount();
    private static final Function FN_DEC_PERCENT100 = new DecimalPercent100();
    private static final Function FN_DEC_PERCENT_COUNT100 = new DecimalPercentCount100();
    private static final Function FN_DEC_PRODUCT = new DecimalProduct();
    private static final Function FN_DEC_STANDARD_DEVIATION = new DecimalStandardDeviation();
    private static final Function FN_DEC_SUM = new DecimalSum();
    private static final Function FN_DEC_VARIANCE = new DecimalVariance();
    private static final Function FN_DEC_NESTED_PERCENT = new DecimalNestedPercent();
    private static final Function FN_DEC_NESTED_PERCENT_COUNT = new DecimalNestedPercentCount();
    private static final Function FN_DEC_NESTED_PERCENT100 = new DecimalNestedPercent100();
    private static final Function FN_DEC_NESTED_PERCENT_COUNT100 = new DecimalNestedPercentCount100();
    public static final Function[] ALL = new Function[]{FN_AVERAGE, FN_COMMA_SEPARATED_LIST, FN_COMMA_SEPARATED_SET, FN_COUNT, FN_COUNT_DISTINCT, FN_FIRST, FN_LAST, FN_MAX, FN_MEDIAN, FN_MIN, FN_PERCENT, FN_PERCENT100, FN_PERCENT_COUNT, FN_PERCENT_COUNT100, FN_PRODUCT, FN_STANDARD_DEVIATION, FN_SUM, FN_VARIANCE};
    public static final Function[] CUBE = new Function[]{FN_NESTED_PERCENT, FN_NESTED_PERCENT100, FN_NESTED_PERCENT_COUNT, FN_NESTED_PERCENT_COUNT100, FN_YTD, FN_MTD};
    public static final Function[] RECORD = new Function[]{FN_YTD, FN_MTD};
    private static Map<String, Function> m_Functions = new HashMap<String, Function>();
    private static Map<String, Function> m_DecimalFunctions = new HashMap<String, Function>();
    private static final String OLD_AVERAGE = "Avg";
    private static final String OLD_STANDARD_DEVIATION = "StdDev";
    private static final String OLD_VARIANCE = "Var";

    public static Function getFunction(DataType dataType, String string) {
        if (string == null) {
            return FN_NULL;
        }
        if (dataType == DataType.DECIMAL) {
            return m_DecimalFunctions.get(string);
        }
        return m_Functions.get(string);
    }

    public static Function newFunction(DataType dataType, String string) {
        if (string == null) {
            return FN_NULL;
        }
        Function function = null;
        function = dataType == DataType.DECIMAL ? m_DecimalFunctions.get(string) : m_Functions.get(string);
        if (function != null) {
            return (Function)function.clone();
        }
        return null;
    }

    public static Object getI18N(Object object) {
        if (object == null) {
            return null;
        }
        String string = null;
        string = object instanceof Function ? ((Function)object).getName() : String.valueOf(object);
        return string;
    }

    static {
        m_Functions.put(FN_AVERAGE.getName(), FN_AVERAGE);
        m_Functions.put(OLD_AVERAGE, FN_AVERAGE);
        m_Functions.put(FN_COMMA_SEPARATED_LIST.getName(), FN_COMMA_SEPARATED_LIST);
        m_Functions.put(FN_COMMA_SEPARATED_SET.getName(), FN_COMMA_SEPARATED_SET);
        m_Functions.put(FN_COUNT.getName(), FN_COUNT);
        m_Functions.put(FN_COUNT_DISTINCT.getName(), FN_COUNT_DISTINCT);
        m_Functions.put(FN_MAX.getName(), FN_MAX);
        m_Functions.put(FN_MIN.getName(), FN_MIN);
        m_Functions.put(FN_MEDIAN.getName(), FN_MEDIAN);
        m_Functions.put(FN_NULL.getName(), FN_NULL);
        m_Functions.put(FN_PERCENT.getName(), FN_PERCENT);
        m_Functions.put(FN_PERCENT_COUNT.getName(), FN_PERCENT_COUNT);
        m_Functions.put(FN_PERCENT100.getName(), FN_PERCENT100);
        m_Functions.put(FN_PERCENT_COUNT100.getName(), FN_PERCENT_COUNT100);
        m_Functions.put(FN_PRODUCT.getName(), FN_PRODUCT);
        m_Functions.put(FN_STANDARD_DEVIATION.getName(), FN_STANDARD_DEVIATION);
        m_Functions.put(OLD_STANDARD_DEVIATION, FN_STANDARD_DEVIATION);
        m_Functions.put(FN_SUM.getName(), FN_SUM);
        m_Functions.put(FN_VARIANCE.getName(), FN_VARIANCE);
        m_Functions.put(OLD_VARIANCE, FN_VARIANCE);
        m_Functions.put(FN_FIRST.getName(), FN_FIRST);
        m_Functions.put(FN_LAST.getName(), FN_LAST);
        m_Functions.put(FN_NESTED_PERCENT.getName(), FN_NESTED_PERCENT);
        m_Functions.put(FN_NESTED_PERCENT_COUNT.getName(), FN_NESTED_PERCENT_COUNT);
        m_Functions.put(FN_NESTED_PERCENT100.getName(), FN_NESTED_PERCENT100);
        m_Functions.put(FN_NESTED_PERCENT_COUNT100.getName(), FN_NESTED_PERCENT_COUNT100);
        m_Functions.put(FN_YTD.getName(), FN_YTD);
        m_Functions.put(FN_MTD.getName(), FN_MTD);
        m_DecimalFunctions.putAll(m_Functions);
        m_DecimalFunctions.put(FN_DEC_AVERAGE.getName(), FN_DEC_AVERAGE);
        m_DecimalFunctions.put(OLD_AVERAGE, FN_DEC_AVERAGE);
        m_DecimalFunctions.put(FN_DEC_MEDIAN.getName(), FN_DEC_MEDIAN);
        m_DecimalFunctions.put(FN_DEC_PERCENT.getName(), FN_DEC_PERCENT);
        m_DecimalFunctions.put(FN_DEC_PERCENT_COUNT.getName(), FN_DEC_PERCENT_COUNT);
        m_DecimalFunctions.put(FN_DEC_PERCENT100.getName(), FN_DEC_PERCENT100);
        m_DecimalFunctions.put(FN_DEC_PERCENT_COUNT100.getName(), FN_DEC_PERCENT_COUNT100);
        m_DecimalFunctions.put(FN_DEC_PRODUCT.getName(), FN_DEC_PRODUCT);
        m_DecimalFunctions.put(FN_DEC_STANDARD_DEVIATION.getName(), FN_DEC_STANDARD_DEVIATION);
        m_DecimalFunctions.put(OLD_STANDARD_DEVIATION, FN_DEC_STANDARD_DEVIATION);
        m_DecimalFunctions.put(FN_DEC_SUM.getName(), FN_DEC_SUM);
        m_DecimalFunctions.put(FN_DEC_VARIANCE.getName(), FN_DEC_VARIANCE);
        m_DecimalFunctions.put(OLD_VARIANCE, FN_DEC_VARIANCE);
        m_DecimalFunctions.put(FN_DEC_NESTED_PERCENT.getName(), FN_DEC_NESTED_PERCENT);
        m_DecimalFunctions.put(FN_DEC_NESTED_PERCENT_COUNT.getName(), FN_DEC_NESTED_PERCENT_COUNT);
        m_DecimalFunctions.put(FN_DEC_NESTED_PERCENT100.getName(), FN_DEC_NESTED_PERCENT100);
        m_DecimalFunctions.put(FN_DEC_NESTED_PERCENT_COUNT100.getName(), FN_DEC_NESTED_PERCENT_COUNT100);
    }

    public static class FunctionLCR
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2 = FunctionFactory.getI18N(object);
            return super.getListCellRendererComponent((JList<?>)jList, object2, n, bl, bl2);
        }
    }
}

