/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.function;

import com.elixirtech.data2.DataType;
import com.elixirtech.data2.function.Function;
import java.util.ArrayList;
import java.util.List;

public class Variance
implements Function {
    protected List<Number> m_Data = new ArrayList<Number>();
    protected double m_Total;

    @Override
    public Object clone() {
        return new Variance();
    }

    @Override
    public String getName() {
        return "Variance";
    }

    @Override
    public void update(Object object) {
        if (object instanceof Number) {
            this.m_Data.add((Number)object);
            this.m_Total += ((Number)object).doubleValue();
        }
    }

    @Override
    public void update(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof Number)) continue;
            this.m_Data.add((Number)objectArray[i]);
            this.m_Total += ((Number)objectArray[i]).doubleValue();
        }
    }

    @Override
    public Object getResult() {
        if (this.m_Data.size() < 2) {
            return null;
        }
        return this.calculateVariance();
    }

    @Override
    public String getResultName(String string) {
        return "Variance(" + string + ")";
    }

    @Override
    public DataType getResultType(DataType dataType) {
        return DataType.DOUBLE;
    }

    protected double calculateVariance() {
        double d = this.m_Total / (double)this.m_Data.size();
        double d2 = 0.0;
        for (Number number : this.m_Data) {
            d2 += Math.pow(number.doubleValue() - d, 2.0);
        }
        return d2 / (double)(this.m_Data.size() - 1);
    }

    @Override
    public void reset() {
        this.m_Data.clear();
        this.m_Total = 0.0;
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass();
    }
}

