/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.grouping;

import com.elixirtech.data2.DataType;
import com.elixirtech.data2.grouping.AscendingDateComparator;
import com.elixirtech.data2.grouping.DescendingDateComparator;
import com.elixirtech.data2.grouping.SubstringRange;
import java.text.Collator;
import java.util.Comparator;

public final class ComparatorFactory {
    private static final Comparator m_AscendingComparator = new AscendingComparator();
    private static final Comparator m_DescendingComparator = new DescendingComparator();
    private static final Comparator m_AscendingBooleanComparator = new AscendingBooleanComparator();
    private static final Comparator m_DescendingBooleanComparator = new DescendingBooleanComparator();

    public static Comparator getSortComparator(DataType dataType, String string, String string2, String string3) {
        if ("Ascending-Lexicographic".equals(string)) {
            if (dataType == DataType.STRING) {
                if ("Substring".equals(string2)) {
                    return new SimpleAscendingSubstringComparator(string3);
                }
                return m_AscendingComparator;
            }
            if (dataType == DataType.BOOLEAN) {
                return m_AscendingBooleanComparator;
            }
            if (dataType == DataType.DATE || dataType == DataType.TIME || dataType == DataType.TIMESTAMP) {
                return new AscendingDateComparator(string2);
            }
            return m_AscendingComparator;
        }
        if ("Ascending".equals(string)) {
            if (dataType == DataType.STRING) {
                if ("Substring".equals(string2)) {
                    return new AscendingSubstringComparator(string3);
                }
                return Collator.getInstance();
            }
            if (dataType == DataType.BOOLEAN) {
                return m_AscendingBooleanComparator;
            }
            if (dataType == DataType.DATE || dataType == DataType.TIME || dataType == DataType.TIMESTAMP) {
                return new AscendingDateComparator(string2);
            }
            return m_AscendingComparator;
        }
        if ("Descending-Lexicographic".equals(string)) {
            if (dataType == DataType.STRING) {
                if ("Substring".equals(string2)) {
                    return new SimpleDescendingSubstringComparator(string3);
                }
                return m_DescendingComparator;
            }
            if (dataType == DataType.BOOLEAN) {
                return m_DescendingBooleanComparator;
            }
            if (dataType == DataType.DATE || dataType == DataType.TIME || dataType == DataType.TIMESTAMP) {
                return new DescendingDateComparator(string2);
            }
            return m_DescendingComparator;
        }
        if ("Descending".equals(string)) {
            if (dataType == DataType.STRING) {
                if ("Substring".equals(string2)) {
                    return new DescendingSubstringComparator(string3);
                }
                return new ReversingComparator(Collator.getInstance());
            }
            if (dataType == DataType.BOOLEAN) {
                return m_DescendingBooleanComparator;
            }
            if (dataType == DataType.DATE || dataType == DataType.TIME || dataType == DataType.TIMESTAMP) {
                return new DescendingDateComparator(string2);
            }
            return m_DescendingComparator;
        }
        return null;
    }

    private static class SimpleAscendingSubstringComparator
    implements Comparator<Object> {
        private SubstringRange m_Range;

        public SimpleAscendingSubstringComparator(String string) {
            this.m_Range = new SubstringRange(string);
        }

        @Override
        public int compare(Object object, Object object2) {
            String string = this.m_Range.substring((String)object);
            String string2 = this.m_Range.substring((String)object2);
            return string.compareTo(string2);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof SimpleAscendingSubstringComparator;
        }
    }

    private static class AscendingSubstringComparator
    implements Comparator<Object> {
        private SubstringRange m_Range;
        private Collator m_Collator;

        public AscendingSubstringComparator(String string) {
            this.m_Range = new SubstringRange(string);
            this.m_Collator = Collator.getInstance();
        }

        @Override
        public int compare(Object object, Object object2) {
            String string = this.m_Range.substring((String)object);
            String string2 = this.m_Range.substring((String)object2);
            return this.m_Collator.compare(string, string2);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof AscendingSubstringComparator;
        }
    }

    private static class SimpleDescendingSubstringComparator
    implements Comparator<Object> {
        private SubstringRange m_Range;

        public SimpleDescendingSubstringComparator(String string) {
            this.m_Range = new SubstringRange(string);
        }

        @Override
        public int compare(Object object, Object object2) {
            String string = this.m_Range.substring((String)object);
            String string2 = this.m_Range.substring((String)object2);
            return string2.compareTo(string);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof SimpleDescendingSubstringComparator;
        }
    }

    private static class DescendingSubstringComparator
    implements Comparator<Object> {
        private SubstringRange m_Range;
        private Collator m_Collator;

        public DescendingSubstringComparator(String string) {
            this.m_Range = new SubstringRange(string);
            this.m_Collator = Collator.getInstance();
        }

        @Override
        public int compare(Object object, Object object2) {
            String string = this.m_Range.substring((String)object);
            String string2 = this.m_Range.substring((String)object2);
            return this.m_Collator.compare(string2, string);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof DescendingSubstringComparator;
        }
    }

    private static class ReversingComparator
    implements Comparator<Object> {
        private final Comparator m_Comparator;

        public ReversingComparator(Comparator comparator) {
            this.m_Comparator = comparator;
        }

        @Override
        public int compare(Object object, Object object2) {
            return this.m_Comparator.compare(object2, object);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof ReversingComparator) {
                return this.m_Comparator.equals(((ReversingComparator)object).m_Comparator);
            }
            return false;
        }
    }

    private static class AscendingComparator
    implements Comparator<Object> {
        private AscendingComparator() {
        }

        @Override
        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof AscendingComparator;
        }
    }

    private static class DescendingComparator
    implements Comparator<Object> {
        private DescendingComparator() {
        }

        @Override
        public int compare(Object object, Object object2) {
            return ((Comparable)object2).compareTo(object);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof DescendingComparator;
        }
    }

    private static class AscendingBooleanComparator
    implements Comparator<Object> {
        private AscendingBooleanComparator() {
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object.equals(object2)) {
                return 0;
            }
            if (Boolean.FALSE.equals(object)) {
                return -1;
            }
            return 1;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof AscendingBooleanComparator;
        }
    }

    private static class DescendingBooleanComparator
    implements Comparator<Object> {
        private DescendingBooleanComparator() {
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object.equals(object2)) {
                return 0;
            }
            if (Boolean.TRUE.equals(object)) {
                return -1;
            }
            return 1;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof DescendingBooleanComparator;
        }
    }
}

