/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.grouping;

import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataListener2;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.GroupNode;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.grouping.GroupDataSource2;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class GroupBuilder
implements DataListener2 {
    private GroupDataSource2 m_DataSource;
    private DataTable m_Table;
    private PushContext m_PushContext;
    private DataListener m_DataListener;
    private List<DataRecord> m_Records = new ArrayList<DataRecord>();
    private Stack<GroupNode> m_Groups = new Stack();

    public GroupBuilder(GroupDataSource2 groupDataSource2, PushContext pushContext, DataListener dataListener) {
        this.m_DataSource = groupDataSource2;
        this.m_PushContext = pushContext;
        this.m_DataListener = dataListener;
    }

    public PushContext getPushContext() {
        return this.m_PushContext;
    }

    public DataListener getDataListener() {
        return this.m_DataListener;
    }

    public DataTable getTable() {
        return this.m_Table;
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IDataSource.class) {
            return clazz.cast(this.m_DataSource);
        }
        return null;
    }

    @Override
    public void startData(IDataSource iDataSource) {
        this.m_Groups.push(new GroupNode());
    }

    @Override
    public void startGroup(DataGroup dataGroup) {
        GroupNode groupNode = this.m_Groups.peek();
        GroupNode groupNode2 = new GroupNode(groupNode, dataGroup.getName());
        groupNode2.setStart(this.m_Records.size());
        this.m_Groups.push(groupNode2);
    }

    @Override
    public boolean processRecord(DataRecord dataRecord) {
        this.m_Records.add(dataRecord);
        return true;
    }

    @Override
    public void endGroup(DataGroup dataGroup) {
        GroupNode groupNode = this.m_Groups.pop();
        groupNode.setStop(this.m_Records.size() - 1);
    }

    @Override
    public void endData(IDataSource iDataSource) {
        DataRecord[] dataRecordArray = new DataRecord[this.m_Records.size()];
        this.m_Records.toArray(dataRecordArray);
        this.m_Table = new DataTable("", iDataSource.getSchema(), dataRecordArray);
        GroupNode groupNode = this.m_Groups.pop();
        groupNode.setStart(0);
        groupNode.setStop(dataRecordArray.length - 1);
        this.m_Table.setGroups(groupNode);
        this.m_DataSource.proceed(this);
    }
}

