/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.grouping;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.NullGroup;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.grouping.CountGrouper;
import com.elixirtech.data2.grouping.Grouper;
import com.elixirtech.data2.grouping.NamedGrouper;
import com.elixirtech.data2.grouping.RangeGrouper;
import com.elixirtech.data2.grouping.SubstringRange;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class GrouperFactory {
    public static final String GROUP_DATE_YEAR = "Year";
    public static final String GROUP_DATE_QUARTER = "Quarter";
    public static final String GROUP_DATE_MONTH = "Month";
    public static final String GROUP_DATE_MONTH_NAME = "Month (Name)";
    public static final String GROUP_DATE_MONTH_SHORT_NAME = "Month (Short Name)";
    public static final String GROUP_DATE_WEEK_OF_YEAR = "Week of Year";
    public static final String GROUP_DATE_WEEK_OF_MONTH = "Week of Month";
    public static final String GROUP_DATE_DAY_OF_YEAR = "Day of Year";
    public static final String GROUP_DATE_DAY_OF_MONTH = "Day of Month";
    public static final String GROUP_DATE_DAY_OF_WEEK = "Day of Week";
    public static final String GROUP_DATE_DAY_OF_WEEK_NAME = "Day of Week (Name)";
    public static final String GROUP_DATE_DAY_OF_WEEK_SHORT_NAME = "Day of Week (Short Name)";
    public static final String GROUP_DATE_HOUR = "Hour";
    public static final String GROUP_DATE_MINUTE = "Minute";
    public static final String GROUP_DATE_SECOND = "Second";
    public static final String GROUP_EACH_VALUE = "Each Value";
    public static final String GROUP_SUBSTRING = "Substring";
    public static final String GROUP_NONE = "None";
    public static final String GROUP_ALL = "All";
    public static final String GROUP_RANGE = "Range";
    public static final String GROUP_COUNT = "Count";
    private static final String NULL_GROUP_NAME = "null";
    private static final String[] GROUP_ON_NAMES = new String[]{"Year", "Quarter", "Month", "Month (Name)", "Month (Short Name)", "Week of Year", "Week of Month", "Day of Year", "Day of Month", "Day of Week", "Day of Week (Name)", "Day of Week (Short Name)", "Hour", "Minute", "Second", "Each Value", "Substring", "None", "All", "Range", "Count"};
    private static final Grouper EQUALITY_GROUPER = new EqualityGrouper();
    private static final Grouper ALL_GROUPER = new AllGrouper();
    private static final Grouper QUARTER_GROUPER = new QuarterGrouper();
    public static final NullGroup NULL_GROUP = NullGroup.INSTANCE;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(GrouperFactory.class);

    public static String[] getGroupOnNames() {
        return GROUP_ON_NAMES;
    }

    public static String[] getGroupOnNames(DataType dataType) {
        int n = dataType.getTypeId();
        switch (n) {
            case 3: {
                return new String[]{GROUP_NONE, GROUP_EACH_VALUE, GROUP_ALL, GROUP_COUNT};
            }
            case 6: 
            case 8: 
            case 18: {
                return new String[]{GROUP_NONE, GROUP_EACH_VALUE, GROUP_RANGE, GROUP_ALL, GROUP_COUNT};
            }
            case 4: {
                return new String[]{GROUP_NONE, GROUP_EACH_VALUE, GROUP_DATE_YEAR, GROUP_DATE_QUARTER, GROUP_DATE_MONTH, GROUP_DATE_MONTH_NAME, GROUP_DATE_MONTH_SHORT_NAME, GROUP_DATE_WEEK_OF_YEAR, GROUP_DATE_WEEK_OF_MONTH, GROUP_DATE_DAY_OF_YEAR, GROUP_DATE_DAY_OF_MONTH, GROUP_DATE_DAY_OF_WEEK, GROUP_DATE_DAY_OF_WEEK_NAME, GROUP_DATE_DAY_OF_WEEK_SHORT_NAME, GROUP_RANGE, GROUP_ALL, GROUP_COUNT};
            }
            case 12: {
                return new String[]{GROUP_NONE, GROUP_EACH_VALUE, GROUP_DATE_HOUR, GROUP_DATE_MINUTE, GROUP_DATE_SECOND, GROUP_RANGE, GROUP_ALL, GROUP_COUNT};
            }
            case 13: {
                return new String[]{GROUP_NONE, GROUP_EACH_VALUE, GROUP_DATE_YEAR, GROUP_DATE_QUARTER, GROUP_DATE_MONTH, GROUP_DATE_MONTH_NAME, GROUP_DATE_MONTH_SHORT_NAME, GROUP_DATE_WEEK_OF_YEAR, GROUP_DATE_WEEK_OF_MONTH, GROUP_DATE_DAY_OF_YEAR, GROUP_DATE_DAY_OF_MONTH, GROUP_DATE_DAY_OF_WEEK, GROUP_DATE_DAY_OF_WEEK_NAME, GROUP_DATE_DAY_OF_WEEK_SHORT_NAME, GROUP_DATE_HOUR, GROUP_DATE_MINUTE, GROUP_DATE_SECOND, GROUP_RANGE, GROUP_ALL, GROUP_COUNT};
            }
            case 2: {
                return new String[]{GROUP_NONE, GROUP_EACH_VALUE, GROUP_SUBSTRING, GROUP_RANGE, GROUP_ALL, GROUP_COUNT};
            }
        }
        return new String[]{GROUP_NONE, GROUP_ALL, GROUP_COUNT};
    }

    public static DataType getGroupType(String string, DataType dataType) {
        if (GROUP_DATE_YEAR.equals(string)) {
            return DataType.LONG;
        }
        if (GROUP_DATE_QUARTER.equals(string)) {
            return DataType.LONG;
        }
        if (GROUP_DATE_MONTH.equals(string)) {
            return DataType.LONG;
        }
        if (GROUP_DATE_MONTH_NAME.equals(string)) {
            return DataType.STRING;
        }
        if (GROUP_DATE_MONTH_SHORT_NAME.equals(string)) {
            return DataType.STRING;
        }
        if (GROUP_DATE_WEEK_OF_YEAR.equals(string)) {
            return DataType.LONG;
        }
        if (GROUP_DATE_WEEK_OF_MONTH.equals(string)) {
            return DataType.LONG;
        }
        if (GROUP_DATE_DAY_OF_YEAR.equals(string)) {
            return DataType.LONG;
        }
        if (GROUP_DATE_DAY_OF_MONTH.equals(string)) {
            return DataType.LONG;
        }
        if (GROUP_DATE_DAY_OF_WEEK.equals(string)) {
            return DataType.LONG;
        }
        if (GROUP_DATE_DAY_OF_WEEK_NAME.equals(string)) {
            return DataType.STRING;
        }
        if (GROUP_DATE_DAY_OF_WEEK_SHORT_NAME.equals(string)) {
            return DataType.STRING;
        }
        if (GROUP_DATE_HOUR.equals(string)) {
            return DataType.LONG;
        }
        if (GROUP_DATE_MINUTE.equals(string)) {
            return DataType.LONG;
        }
        if (GROUP_DATE_SECOND.equals(string)) {
            return DataType.LONG;
        }
        if (GROUP_EACH_VALUE.equals(string)) {
            return dataType;
        }
        if (GROUP_SUBSTRING.equals(string)) {
            return DataType.STRING;
        }
        if (GROUP_NONE.equals(string)) {
            return DataType.UNKNOWN;
        }
        if (GROUP_ALL.equals(string)) {
            return DataType.STRING;
        }
        if (GROUP_RANGE.equals(string)) {
            return DataType.STRING;
        }
        if (GROUP_COUNT.equals(string)) {
            return DataType.LONG;
        }
        return DataType.UNKNOWN;
    }

    public static Grouper getInstance(PushContext pushContext, DataSchema dataSchema, DataType dataType, String string, String string2) {
        if (string == null || string.length() == 0) {
            return EQUALITY_GROUPER;
        }
        if (GROUP_NONE.equals(string)) {
            return null;
        }
        if (GROUP_ALL.equals(string)) {
            return ALL_GROUPER;
        }
        if (GROUP_COUNT.equals(string)) {
            return new CountGrouper(pushContext.substitute(string2));
        }
        if (GROUP_EACH_VALUE.equals(string)) {
            return EQUALITY_GROUPER;
        }
        if (GROUP_DATE_QUARTER.equals(string)) {
            return QUARTER_GROUPER;
        }
        if (GROUP_RANGE.equals(string)) {
            return new RangeGrouper(dataSchema, dataType, pushContext.substitute(string2));
        }
        switch (dataType.getTypeId()) {
            case 6: 
            case 8: {
                int n = 1;
                String string3 = pushContext.substitute(string2);
                try {
                    n = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    m_Log.warn((Object)("Unable to parse " + string3 + " as an integer"));
                }
                return new NumberGrouper(n);
            }
            case 2: {
                if (GROUP_SUBSTRING.equals(string)) {
                    SubstringRange substringRange = new SubstringRange(string2);
                    return new StringGrouper(substringRange, true);
                }
                return EQUALITY_GROUPER;
            }
            case 4: 
            case 12: 
            case 13: {
                int n = 1;
                if (StringUtil.notEmpty(string2)) {
                    String string4 = pushContext.substitute(string2);
                    try {
                        n = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        m_Log.warn((Object)("Unable to parse " + string4 + " as an integer"));
                    }
                }
                if (n == 0) {
                    return EQUALITY_GROUPER;
                }
                return new DateGrouper(string, n);
            }
        }
        return EQUALITY_GROUPER;
    }

    public static Grouper getEqualityInstance() {
        return EQUALITY_GROUPER;
    }

    public static Grouper getStringInstance(SubstringRange substringRange, boolean bl) {
        return new StringGrouper(substringRange, bl);
    }

    public static Grouper getNumberInstance(int n) {
        return new NumberGrouper(n);
    }

    public static Grouper getRangeInstance(DataSchema dataSchema, DataType dataType, String string) {
        return new RangeGrouper(dataSchema, dataType, string);
    }

    public static Grouper getRangeInstance(Comparable[] comparableArray) {
        return new SimpleRangeGrouper(comparableArray);
    }

    public static Grouper getDateInstance(int n, String string, int n2) {
        return new DateGrouper(n, string, n2);
    }

    public static Grouper getQuarterInstance() {
        return QUARTER_GROUPER;
    }

    private static class NumberGrouper
    implements Grouper {
        private int m_GroupInterval;

        public NumberGrouper(int n) {
            this.m_GroupInterval = n;
        }

        @Override
        public Object getGroup(Object object) {
            if (object == null) {
                return NULL_GROUP;
            }
            long l = ((Number)object).longValue();
            return l / (long)this.m_GroupInterval;
        }

        @Override
        public DataType getGroupType(DataType dataType) {
            return DataType.LONG;
        }
    }

    private static class StringGrouper
    implements NamedGrouper {
        private final SubstringRange m_Range;
        private final boolean m_CaseSensitive;

        public StringGrouper(SubstringRange substringRange, boolean bl) {
            this.m_Range = substringRange;
            this.m_CaseSensitive = bl;
        }

        @Override
        public Object getGroup(Object object) {
            if (object == null) {
                return NULL_GROUP;
            }
            String string = this.m_Range.substring((String)object);
            if (!this.m_CaseSensitive) {
                string = string.toUpperCase(Locale.getDefault());
            }
            return string;
        }

        @Override
        public DataType getGroupType(DataType dataType) {
            return DataType.STRING;
        }

        @Override
        public String getGroupName(Object object, DataType dataType) {
            if (object == null) {
                return GrouperFactory.NULL_GROUP_NAME;
            }
            String string = this.m_Range.substring((String)object);
            if (!this.m_CaseSensitive) {
                string = string.toUpperCase(Locale.getDefault());
            }
            return string;
        }
    }

    private static class DateGrouper
    implements NamedGrouper {
        private final String m_GroupOn;
        private final Calendar m_Calendar;
        private final DateFormatSymbols m_Symbols;
        private final int m_GroupInterval;
        private final int m_Field;

        public DateGrouper(String string, int n) {
            this.m_GroupOn = string;
            this.m_Calendar = Calendar.getInstance();
            this.m_Symbols = new DateFormatSymbols();
            this.m_Field = GrouperFactory.GROUP_DATE_YEAR.equals(string) ? 1 : (GrouperFactory.GROUP_DATE_MONTH.equals(string) ? 2 : (GrouperFactory.GROUP_DATE_MONTH_NAME.equals(string) ? 2 : (GrouperFactory.GROUP_DATE_MONTH_SHORT_NAME.equals(string) ? 2 : (GrouperFactory.GROUP_DATE_WEEK_OF_YEAR.equals(string) ? 3 : (GrouperFactory.GROUP_DATE_WEEK_OF_MONTH.equals(string) ? 4 : (GrouperFactory.GROUP_DATE_DAY_OF_YEAR.equals(string) ? 6 : (GrouperFactory.GROUP_DATE_DAY_OF_MONTH.equals(string) ? 5 : (GrouperFactory.GROUP_DATE_DAY_OF_WEEK.equals(string) ? 7 : (GrouperFactory.GROUP_DATE_DAY_OF_WEEK_NAME.equals(string) ? 7 : (GrouperFactory.GROUP_DATE_DAY_OF_WEEK_SHORT_NAME.equals(string) ? 7 : (GrouperFactory.GROUP_DATE_HOUR.equals(string) ? 11 : (GrouperFactory.GROUP_DATE_MINUTE.equals(string) ? 12 : (GrouperFactory.GROUP_DATE_SECOND.equals(string) ? 13 : -1)))))))))))));
            this.m_GroupInterval = n;
        }

        public DateGrouper(int n, String string, int n2) {
            this.m_Calendar = Calendar.getInstance();
            this.m_Symbols = new DateFormatSymbols();
            this.m_Field = n;
            this.m_GroupOn = string;
            this.m_GroupInterval = n2;
        }

        @Override
        public Object getGroup(Object object) {
            if (object == null) {
                return NULL_GROUP;
            }
            this.m_Calendar.setTime((Date)object);
            return this.m_Calendar.get(this.m_Field) / this.m_GroupInterval;
        }

        @Override
        public DataType getGroupType(DataType dataType) {
            return DataType.LONG;
        }

        @Override
        public String getGroupName(Object object, DataType dataType) {
            if (object == null) {
                return GrouperFactory.NULL_GROUP_NAME;
            }
            this.m_Calendar.setTime((Date)object);
            int n = this.m_Calendar.get(this.m_Field);
            if (this.m_GroupInterval == 1) {
                return this.getName(n);
            }
            int n2 = n / this.m_GroupInterval * this.m_GroupInterval;
            int n3 = n2 + this.m_GroupInterval - 1;
            return this.getName(n2) + "-" + this.getName(n3);
        }

        protected String getName(int n) {
            if (GrouperFactory.GROUP_DATE_MONTH_NAME.equals(this.m_GroupOn)) {
                return this.m_Symbols.getMonths()[Math.min(n, 11)];
            }
            if (GrouperFactory.GROUP_DATE_MONTH_SHORT_NAME.equals(this.m_GroupOn)) {
                return this.m_Symbols.getShortMonths()[Math.min(n, 11)];
            }
            if (GrouperFactory.GROUP_DATE_DAY_OF_WEEK_NAME.equals(this.m_GroupOn)) {
                return this.m_Symbols.getWeekdays()[Math.min(n, 7)];
            }
            if (GrouperFactory.GROUP_DATE_DAY_OF_WEEK_SHORT_NAME.equals(this.m_GroupOn)) {
                return this.m_Symbols.getShortWeekdays()[Math.min(n, 7)];
            }
            if (GrouperFactory.GROUP_DATE_MONTH.equals(this.m_GroupOn)) {
                return Integer.toString(n + 1);
            }
            return Integer.toString(n);
        }
    }

    private static class SimpleRangeGrouper
    implements Grouper {
        private final Comparable[] m_Comparables;

        public SimpleRangeGrouper(Comparable[] comparableArray) {
            this.m_Comparables = comparableArray;
            Arrays.sort(this.m_Comparables);
        }

        @Override
        public Object getGroup(Object object) {
            if (object == null) {
                return NULL_GROUP;
            }
            if (this.m_Comparables.length == 0) {
                return object;
            }
            if (this.m_Comparables[0].compareTo(object) > 0) {
                return 0;
            }
            for (int i = 1; i < this.m_Comparables.length; ++i) {
                if (this.m_Comparables[i].compareTo(object) <= 0) continue;
                return i;
            }
            return this.m_Comparables.length;
        }

        @Override
        public DataType getGroupType(DataType dataType) {
            return DataType.LONG;
        }
    }

    private static class EqualityGrouper
    implements NamedGrouper {
        private EqualityGrouper() {
        }

        @Override
        public Object getGroup(Object object) {
            if (object == null) {
                return NULL_GROUP;
            }
            return object;
        }

        @Override
        public DataType getGroupType(DataType dataType) {
            return dataType;
        }

        @Override
        public String getGroupName(Object object, DataType dataType) {
            if (object == null) {
                return GrouperFactory.NULL_GROUP_NAME;
            }
            int n = dataType.getTypeId();
            if (n == 4) {
                DateFormat dateFormat = DateFormat.getDateInstance();
                return dateFormat.format(object);
            }
            if (n == 12) {
                DateFormat dateFormat = DateFormat.getTimeInstance();
                return dateFormat.format(object);
            }
            return object.toString();
        }
    }

    private static class AllGrouper
    implements NamedGrouper {
        private AllGrouper() {
        }

        @Override
        public Object getGroup(Object object) {
            return GrouperFactory.GROUP_ALL;
        }

        @Override
        public DataType getGroupType(DataType dataType) {
            return DataType.STRING;
        }

        @Override
        public String getGroupName(Object object, DataType dataType) {
            return GrouperFactory.GROUP_ALL;
        }
    }

    private static class QuarterGrouper
    implements NamedGrouper {
        private final Calendar m_Calendar = Calendar.getInstance();

        @Override
        public Object getGroup(Object object) {
            if (object == null) {
                return NULL_GROUP;
            }
            this.m_Calendar.setTime((Date)object);
            return this.m_Calendar.get(2) / 3;
        }

        @Override
        public DataType getGroupType(DataType dataType) {
            return DataType.LONG;
        }

        @Override
        public String getGroupName(Object object, DataType dataType) {
            if (object == null) {
                return GrouperFactory.NULL_GROUP_NAME;
            }
            this.m_Calendar.setTime((Date)object);
            int n = this.m_Calendar.get(2) / 3 + 1;
            return "Q" + n;
        }
    }
}

