/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.grouping;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.GroupNode;
import com.elixirtech.data2.grouping.CountGrouper;
import com.elixirtech.data2.grouping.GroupDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TreeBuilder {
    private final DataRecord[] m_Records;
    private final DataSchema m_Schema;
    private final GroupNode m_Root;
    private List<GroupNode> m_Current;

    public TreeBuilder(DataRecord[] dataRecordArray) {
        this.m_Records = dataRecordArray;
        this.m_Schema = this.m_Records.length > 0 ? this.m_Records[0].getSchema() : new DataSchema();
        this.m_Root = new GroupNode(0, this.m_Records.length - 1);
        this.m_Current = new ArrayList<GroupNode>();
        this.m_Current.add(this.m_Root);
    }

    public void process(GroupDefinition groupDefinition) {
        if (this.m_Current == null) {
            throw new IllegalStateException("Cannot process more groups after getRoot() called");
        }
        if (this.m_Records.length > 0) {
            ArrayList<GroupNode> arrayList = new ArrayList<GroupNode>();
            for (GroupNode groupNode : this.m_Current) {
                if (groupDefinition.needsSorting()) {
                    Arrays.sort(this.m_Records, groupNode.getStart(), groupNode.getStop() + 1, groupDefinition);
                }
                if (!groupDefinition.needsGrouping()) continue;
                this.group(groupNode, groupDefinition, arrayList);
            }
            if (groupDefinition.needsGrouping()) {
                this.m_Current = arrayList;
            }
        }
    }

    public GroupNode getRoot() {
        this.m_Current = null;
        return this.m_Root;
    }

    protected void group(GroupNode groupNode, GroupDefinition groupDefinition, List<GroupNode> list) {
        if (groupDefinition.m_Grouper instanceof CountGrouper) {
            this.counterGroup(groupNode, groupDefinition, list);
        } else if (groupDefinition.m_Grouper != null) {
            this.grouperGroup(groupNode, groupDefinition, list);
        }
    }

    protected void counterGroup(GroupNode groupNode, GroupDefinition groupDefinition, List<GroupNode> list) {
        int n = -1;
        String string = groupDefinition.getDerivedFieldName();
        if (StringUtil.notEmpty(string)) {
            n = this.m_Schema.getColumnIndex(string);
        }
        CountGrouper countGrouper = (CountGrouper)groupDefinition.m_Grouper;
        int n2 = countGrouper.getChunkSize();
        int n3 = 0;
        int n4 = 0;
        int n5 = groupNode.getStart();
        for (int i = groupNode.getStart(); i <= groupNode.getStop(); ++i) {
            if (n3 == n2) {
                list.add(new GroupNode(groupNode, String.valueOf(n4), n5, i - 1));
                ++n4;
                n3 = 1;
                n5 = i;
            } else {
                ++n3;
            }
            if (n < 0) continue;
            this.m_Records[i].setData(n, n4);
        }
        if (n3 != 0) {
            list.add(new GroupNode(groupNode, String.valueOf(n4), n5, groupNode.getStop()));
        }
    }

    protected void grouperGroup(GroupNode groupNode, GroupDefinition groupDefinition, List<GroupNode> list) {
        int n = -1;
        String string = groupDefinition.getDerivedFieldName();
        if (StringUtil.notEmpty(string)) {
            n = this.m_Schema.getColumnIndex(string);
        }
        int n2 = groupDefinition.getIndex();
        int n3 = groupNode.getStart();
        Object object = this.m_Records[n3].getData(n2);
        Object object2 = groupDefinition.getGroup(object);
        if (n >= 0) {
            this.m_Records[n3].setData(n, object2);
        }
        for (int i = groupNode.getStart() + 1; i <= groupNode.getStop(); ++i) {
            Object object3 = this.m_Records[i].getData(n2);
            Object object4 = groupDefinition.getGroup(object3);
            if (n >= 0) {
                this.m_Records[i].setData(n, object4);
            }
            if (!this.isSameGroup(object2, object4)) {
                list.add(new GroupNode(groupNode, groupDefinition.getGroupName(this.m_Records[n3]), n3, i - 1));
                object = object3;
                object2 = object4;
                n3 = i;
                continue;
            }
            if (!groupDefinition.canMerge(object, object3)) continue;
            this.m_Records[i].setData(n2, object);
        }
        list.add(new GroupNode(groupNode, groupDefinition.getGroupName(this.m_Records[n3]), n3, groupNode.getStop()));
    }

    private boolean isSameGroup(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        return object.equals(object2);
    }
}

