/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.olap;

import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.function.RecordFunction;
import com.elixirtech.data2.olap.AllDataSet;
import com.elixirtech.util.BitSetIterator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;

public class Index {
    BitSet m_Bits;

    public Index() {
        this.m_Bits = new BitSet(10);
    }

    protected Index(BitSet bitSet) {
        this.m_Bits = bitSet;
    }

    public void add(int n) {
        this.m_Bits.set(n);
    }

    public boolean get(int n) {
        return this.m_Bits.get(n);
    }

    public Index intersection(Index index) {
        BitSet bitSet = (BitSet)this.m_Bits.clone();
        if (!(index instanceof AllDataSet)) {
            bitSet.and(index.m_Bits);
        }
        return new Index(bitSet);
    }

    public Index union(Index index) {
        if (index instanceof AllDataSet) {
            return index;
        }
        BitSet bitSet = (BitSet)this.m_Bits.clone();
        bitSet.or(index.m_Bits);
        return new Index(bitSet);
    }

    public Object getResult(Function function, DataRecord[] dataRecordArray, int n) {
        BitSetIterator bitSetIterator = new BitSetIterator(this.m_Bits);
        if (function instanceof RecordFunction) {
            ((RecordFunction)function).setColumnIndex(n);
            while (bitSetIterator.hasNext()) {
                function.update(dataRecordArray[bitSetIterator.next()]);
            }
        } else {
            while (bitSetIterator.hasNext()) {
                function.update(dataRecordArray[bitSetIterator.next()].getData(n));
            }
        }
        Object object = function.getResult();
        function.reset();
        return object;
    }

    public void apply(Function function, DataRecord[] dataRecordArray, int n) {
        BitSetIterator bitSetIterator = new BitSetIterator(this.m_Bits);
        if (function instanceof RecordFunction) {
            ((RecordFunction)function).setColumnIndex(n);
            while (bitSetIterator.hasNext()) {
                function.update(dataRecordArray[bitSetIterator.next()]);
            }
        } else {
            while (bitSetIterator.hasNext()) {
                function.update(dataRecordArray[bitSetIterator.next()].getData(n));
            }
        }
    }

    public Object[] collect(DataRecord[] dataRecordArray, int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        BitSetIterator bitSetIterator = new BitSetIterator(this.m_Bits);
        while (bitSetIterator.hasNext()) {
            arrayList.add(dataRecordArray[bitSetIterator.next()].getData(n));
        }
        return arrayList.toArray();
    }

    public boolean isEmpty() {
        return this.m_Bits.isEmpty();
    }

    public int size() {
        return this.m_Bits.size();
    }

    public int getFirst() {
        return this.m_Bits.nextSetBit(0);
    }

    public Iterator<DataRecord> iterator(DataRecord[] dataRecordArray) {
        return new IndexIterator(dataRecordArray);
    }

    public BitSet getBitSet() {
        return this.m_Bits;
    }

    private class IndexIterator
    implements Iterator<DataRecord> {
        private DataRecord[] m_Records;
        private BitSetIterator m_It;

        public IndexIterator(DataRecord[] dataRecordArray) {
            this.m_Records = dataRecordArray;
            this.m_It = new BitSetIterator(Index.this.m_Bits);
        }

        @Override
        public boolean hasNext() {
            return this.m_It.hasNext();
        }

        @Override
        public DataRecord next() {
            int n = this.m_It.next();
            if (n >= 0) {
                return this.m_Records[n];
            }
            throw new IllegalStateException("No more elements");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

