/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.output;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.arch.job.JobLogging;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.data2.datasource.composite.CompositeScope;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.data2.output.IDataStore2;
import com.elixirtech.data2.output.XMLDataStore;
import com.elixirtech.data2.output.jdbc.ErrorSource;
import com.elixirtech.data2.output.jdbc.Exists;
import com.elixirtech.data2.output.jdbc.PreparedStatementUtil;
import com.elixirtech.data2.output.sql.BasicSQLBuilder;
import com.elixirtech.data2.output.sql.ISQLBuilder;
import com.elixirtech.js.JavaScriptEngine;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.BitSet;
import java.util.List;
import org.mozilla.javascript.Scriptable;

public abstract class BaseJDBCDataStore
implements IDataStore2 {
    protected PushContext m_Context;
    private DataType[] m_Types;
    private String m_Name;
    private DataStore m_DataStore;
    protected boolean m_AutoCommit;
    protected boolean m_UpdateInsert;
    protected boolean m_ReturnKeys;
    protected int m_RecordCount;
    protected int m_BatchSize;
    protected String m_TableName;
    protected boolean m_Exists;
    protected boolean m_Append;
    protected Connection m_Connection;
    protected PreparedStatement m_ExistsStatement;
    protected PreparedStatement m_InsertStatement;
    protected PreparedStatement m_UpdateStatement;
    protected String m_ErrorStoreURL;
    protected int m_SuccessCount;
    protected int m_FailCount;
    protected XMLDataStore m_Errors;
    protected ErrorSource m_ErrorSource;
    protected String m_Driver;
    protected String m_Dialect;
    private String m_DropSQL;
    private String m_CreateSQL;
    private String m_DeleteSQL;
    private String m_InsertSQL;
    private String m_ExistsSQL;
    private String m_UpdateSQL;
    private int[] m_PrimaryKeys;
    private int[] m_OtherValues;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(BaseJDBCDataStore.class);

    public static int getSQLType(DataType dataType) {
        return PreparedStatementUtil.getSQLType(dataType);
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public void setName(String string) {
        this.m_Name = string;
    }

    @Override
    public DataStore getDataStore() {
        return this.m_DataStore;
    }

    @Override
    public void setDataStore(DataStore dataStore) {
        this.m_DataStore = dataStore;
    }

    public boolean isAppend() {
        return this.m_Append;
    }

    public void setAppend(boolean bl) {
        this.m_Append = bl;
    }

    public boolean isAutoCommit() {
        return this.m_AutoCommit;
    }

    public void setAutoCommit(boolean bl) {
        this.m_AutoCommit = bl;
    }

    public boolean isUpdateInsert() {
        return this.m_UpdateInsert;
    }

    public void setUpdateInsert(boolean bl) {
        this.m_UpdateInsert = bl;
    }

    public boolean isReturnKeys() {
        return this.m_ReturnKeys;
    }

    public void setReturnKeys(boolean bl) {
        this.m_ReturnKeys = bl;
    }

    public boolean isExists() {
        return this.m_Exists;
    }

    public void setExists(boolean bl) {
        this.m_Exists = bl;
    }

    public String getDialect() {
        return this.m_Dialect;
    }

    public void setDialect(String string) {
        this.m_Dialect = string;
    }

    public String getTableName() {
        return this.m_TableName;
    }

    public void setTableName(String string) {
        this.m_TableName = string;
    }

    public String getErrorStoreURL() {
        return this.m_ErrorStoreURL;
    }

    public void setErrorStoreURL(String string) {
        this.m_ErrorStoreURL = string;
    }

    private void exec(String string) throws SQLException {
        this.getLog().debug((Object)string);
        try (Statement statement = null;){
            statement = this.m_Connection.createStatement();
            statement.execute(string);
        }
    }

    protected void closeConnection() throws SQLException {
        if (this.m_Connection != null) {
            try {
                if (this.m_InsertStatement != null) {
                    this.m_InsertStatement.close();
                }
                if (this.m_UpdateStatement != null) {
                    this.m_UpdateStatement.close();
                }
                if (this.m_ExistsStatement != null) {
                    this.m_ExistsStatement.close();
                }
                if (!this.m_AutoCommit) {
                    this.m_Connection.commit();
                }
            }
            finally {
                this.m_Connection.close();
                this.m_Connection = null;
            }
        }
    }

    private void logException(String string, SQLException sQLException) {
        Object object;
        this.getLog().info((Object)string);
        String string2 = sQLException.toString();
        while (string2.length() > 200) {
            object = string2.substring(0, 200);
            this.getLog().info((Object)("--" + (String)object));
            string2 = string2.substring(200);
        }
        this.getLog().info((Object)("--" + string2));
        object = sQLException.getNextException();
        if (object != null && object != sQLException) {
            this.logException("Next error follows:", sQLException);
        }
    }

    protected abstract Connection openConnection();

    public abstract ElxLoggerJ getLog();

    @Override
    public abstract List<Parameter> getParameters();

    @Override
    public void setContext(PushContext pushContext) {
        this.m_Context = pushContext;
    }

    @Override
    public void startGroup(DataGroup dataGroup) {
    }

    @Override
    public void endGroup(DataGroup dataGroup) {
    }

    @Override
    public void startData(IDataSource iDataSource) {
        this.getLog().debug((Object)"startData");
        this.m_Connection = this.openConnection();
        DataSchema dataSchema = iDataSource.getSchema();
        this.initBuilder(dataSchema);
        int n = dataSchema.getColumnCount();
        this.m_Types = new DataType[n];
        for (int i = 0; i < n; ++i) {
            this.m_Types[i] = dataSchema.getColumnType(i);
        }
        if (!this.m_Append && !this.m_Exists) {
            try {
                this.exec(this.m_DropSQL);
            }
            catch (SQLException sQLException) {
                this.getLog().debug((Object)("Error dropping table: " + String.valueOf(sQLException)));
            }
        }
        if (!this.m_Exists) {
            try {
                this.exec(this.m_CreateSQL);
            }
            catch (SQLException sQLException) {
                try {
                    this.closeConnection();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new RuntimeException("Can't create table: " + this.m_CreateSQL, sQLException);
            }
        }
        if (!this.m_Append && this.m_Exists) {
            try {
                this.exec(this.m_DeleteSQL);
            }
            catch (SQLException sQLException) {
                try {
                    this.closeConnection();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new RuntimeException("Can't delete existing contents: " + this.m_DeleteSQL, sQLException);
            }
        }
        try {
            this.m_InsertStatement = this.m_ReturnKeys ? this.m_Connection.prepareStatement(this.m_InsertSQL, 1) : this.m_Connection.prepareStatement(this.m_InsertSQL);
            if (this.m_UpdateInsert) {
                this.m_ExistsStatement = this.m_Connection.prepareStatement(this.m_ExistsSQL);
                this.m_UpdateStatement = this.m_Connection.prepareStatement(this.m_UpdateSQL);
            }
        }
        catch (SQLException sQLException) {
            try {
                this.closeConnection();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new RuntimeException("Can't prepare statement " + this.m_InsertSQL, sQLException);
        }
        this.initErrors(iDataSource);
    }

    @Override
    public void endData(IDataSource iDataSource) {
        this.getLog().debug((Object)"endData");
        try {
            try {
                if (this.m_RecordCount > 0 && this.m_BatchSize > 1) {
                    this.m_InsertStatement.executeBatch();
                    this.m_RecordCount = 0;
                }
            }
            finally {
                this.closeConnection();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error closing connection: " + String.valueOf(exception));
        }
        finally {
            if (this.m_Errors != null) {
                if (this.m_FailCount == 0) {
                    m_Log.info((Object)("JDBC DataStore successfully wrote " + this.m_SuccessCount + " records"));
                } else {
                    m_Log.warn((Object)("JDBC DataStore successfully wrote " + this.m_SuccessCount + " records, but " + this.m_FailCount + " records failed"));
                }
                this.m_Errors.endData(iDataSource);
                this.m_Errors = null;
            }
        }
    }

    private void initBuilder(DataSchema dataSchema) {
        ElxLoggerJ elxLoggerJ;
        String string = this.m_Context.substitute(this.m_TableName);
        ISQLBuilder iSQLBuilder = BasicSQLBuilder.getBuilder(this.m_Connection, this.m_Driver, this.m_Dialect, string, dataSchema);
        this.m_RecordCount = 0;
        this.m_BatchSize = iSQLBuilder.getBatchSize();
        this.m_DropSQL = iSQLBuilder.dropString();
        this.m_CreateSQL = iSQLBuilder.createString();
        this.m_DeleteSQL = iSQLBuilder.deleteString();
        this.m_InsertSQL = iSQLBuilder.insertString();
        if (this.m_UpdateInsert) {
            int n;
            int n2;
            elxLoggerJ = iSQLBuilder.getPrimaryKeys();
            if (elxLoggerJ.isEmpty()) {
                throw new RuntimeException("Can't test exists: no primary key available");
            }
            this.m_ExistsSQL = iSQLBuilder.existsString();
            this.m_UpdateSQL = iSQLBuilder.updateString();
            this.m_PrimaryKeys = new int[elxLoggerJ.size()];
            BitSet bitSet = new BitSet();
            for (n2 = 0; n2 < elxLoggerJ.size(); ++n2) {
                n = dataSchema.getColumnIndex((String)elxLoggerJ.get(n2));
                if (n < 0) {
                    throw new RuntimeException("Primary key \"" + (String)elxLoggerJ.get(n2) + "\" not found.");
                }
                this.m_PrimaryKeys[n2] = dataSchema.getColumnIndex((String)elxLoggerJ.get(n2));
                bitSet.set(this.m_PrimaryKeys[n2]);
            }
            n2 = dataSchema.getColumnCount();
            this.m_OtherValues = new int[dataSchema.getColumnCount() - this.m_PrimaryKeys.length];
            n = 0;
            for (int i = 0; i < n2; ++i) {
                if (bitSet.get(i)) continue;
                this.m_OtherValues[n++] = i;
            }
            this.m_BatchSize = 1;
        }
        if ((elxLoggerJ = this.getLog()).isDebugEnabled()) {
            elxLoggerJ.debug((Object)("using Dialect: " + iSQLBuilder.getDialect().getName()));
            elxLoggerJ.debug((Object)("drop SQL = " + this.m_DropSQL));
            elxLoggerJ.debug((Object)("create SQL = " + this.m_CreateSQL));
            elxLoggerJ.debug((Object)("delete SQL = " + this.m_DeleteSQL));
            elxLoggerJ.debug((Object)("insert SQL = " + this.m_InsertSQL));
            elxLoggerJ.debug((Object)("exists SQL = " + this.m_ExistsSQL));
            elxLoggerJ.debug((Object)("update SQL = " + this.m_UpdateSQL));
            elxLoggerJ.debug((Object)("batch size = " + this.m_BatchSize));
        }
    }

    public void initErrors(IDataSource iDataSource) {
        if (StringUtil.notEmpty(this.m_ErrorStoreURL)) {
            this.m_Errors = new XMLDataStore();
            this.m_Errors.setContext(this.m_Context);
            this.m_Errors.setName("Error Records");
            this.m_Errors.setURL(this.m_Context.substitute(this.m_ErrorStoreURL));
            SchemaBuilder schemaBuilder = new SchemaBuilder(iDataSource.getSchema());
            schemaBuilder.add("jdbc_operation", DataType.STRING, new DataAttributes());
            schemaBuilder.add("jdbc_error", DataType.STRING, new DataAttributes());
            this.m_ErrorSource = new ErrorSource(schemaBuilder.getSchema());
            this.m_Errors.startData(this.m_ErrorSource);
            this.m_BatchSize = 1;
        }
    }

    @Override
    public boolean processRecord(DataRecord dataRecord) {
        if (this.m_UpdateInsert) {
            Exists exists = this.exists(dataRecord);
            switch (exists.code) {
                case 1: {
                    if (this.m_ReturnKeys) {
                        this.updateAndReturnKeys(dataRecord);
                        break;
                    }
                    this.updateRecord(dataRecord);
                    break;
                }
                case 2: {
                    if (this.m_ReturnKeys) {
                        this.insertAndReturnKeys(dataRecord);
                        break;
                    }
                    this.insertRecord(dataRecord);
                    break;
                }
                default: {
                    this.processFail(dataRecord, "exists", exists.ex);
                    break;
                }
            }
        } else if (this.m_ReturnKeys) {
            this.insertAndReturnKeys(dataRecord);
        } else {
            this.insertRecord(dataRecord);
        }
        return this.m_Context != null ? !this.m_Context.isAborted() : true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Exists exists(DataRecord dataRecord) {
        assert (this.m_UpdateInsert);
        DataSchema dataSchema = dataRecord.getSchema();
        Object[] objectArray = dataRecord.getData();
        try {
            this.m_ExistsStatement.clearParameters();
            for (int i = 0; i < this.m_PrimaryKeys.length; ++i) {
                PreparedStatementUtil.update(this.m_ExistsStatement, i, dataSchema.getColumnType(this.m_PrimaryKeys[i]), objectArray[this.m_PrimaryKeys[i]]);
            }
            try (ResultSet resultSet = this.m_ExistsStatement.executeQuery();){
                if (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    if (n > 0) {
                        Exists exists = Exists.TRUE;
                        return exists;
                    }
                    Exists exists = Exists.FALSE;
                    return exists;
                }
                Exists exists = Exists.FALSE;
                return exists;
            }
        }
        catch (SQLException sQLException) {
            JobLogging.logError("JDBCDataStore", "Error processing record", sQLException);
            this.getLog().error((Object)("Error processing record: " + String.valueOf(sQLException)));
            return new Exists(sQLException);
        }
    }

    protected void insertAndReturnKeys(DataRecord dataRecord) {
        Object[] objectArray = dataRecord.getData();
        try {
            this.m_InsertStatement.clearParameters();
            for (int i = 0; i < objectArray.length; ++i) {
                PreparedStatementUtil.update(this.m_InsertStatement, i, this.m_Types[i], objectArray[i]);
            }
            try {
                this.m_InsertStatement.executeUpdate();
                ++this.m_SuccessCount;
                ResultSet resultSet = this.m_InsertStatement.getGeneratedKeys();
                if (resultSet.next()) {
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n = resultSetMetaData.getColumnCount();
                    JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
                    Scriptable scriptable = javaScriptEngine.getScope();
                    if (scriptable instanceof CompositeScope) {
                        ((CompositeScope)scriptable).addProperty("JDBC_INSERT_UPDATE_MODE", "INSERT");
                    }
                    for (int i = 1; i <= n; ++i) {
                        String string = "JDBC_GENERATED_KEY_" + i;
                        Object object = resultSet.getObject(i);
                        if (scriptable instanceof CompositeScope) {
                            ((CompositeScope)scriptable).addProperty(string, object);
                            continue;
                        }
                        scriptable.put(string, scriptable, object);
                    }
                }
            }
            catch (SQLException sQLException) {
                this.processFail(dataRecord, "insert", sQLException);
            }
        }
        catch (SQLException sQLException) {
            JobLogging.logError("JDBCDataStore", "Error inserting record", sQLException);
            this.getLog().error((Object)("Error inserting record: " + String.valueOf(sQLException)));
        }
    }

    protected void insertRecord(DataRecord dataRecord) {
        block10: {
            Object[] objectArray = dataRecord.getData();
            try {
                this.m_InsertStatement.clearParameters();
                for (int i = 0; i < objectArray.length; ++i) {
                    PreparedStatementUtil.update(this.m_InsertStatement, i, this.m_Types[i], objectArray[i]);
                }
                if (this.m_BatchSize > 1) {
                    this.m_InsertStatement.addBatch();
                    ++this.m_RecordCount;
                    if (this.m_RecordCount != this.m_BatchSize) break block10;
                    try {
                        this.m_InsertStatement.executeBatch();
                        if (!this.m_AutoCommit) {
                            this.m_Connection.commit();
                        }
                        this.m_RecordCount = 0;
                    }
                    catch (SQLException sQLException) {
                        JobLogging.logError("JDBCDataStore", "Error processing insert batch", sQLException);
                        this.getLog().error((Object)("Error processing batch: " + String.valueOf(sQLException)));
                        if (this.getLog().isInfoEnabled()) {
                            this.logException("Error details follow:", sQLException);
                        }
                        break block10;
                    }
                }
                try {
                    this.m_InsertStatement.executeUpdate();
                    ++this.m_SuccessCount;
                }
                catch (SQLException sQLException) {
                    this.processFail(dataRecord, "insert", sQLException);
                }
            }
            catch (SQLException sQLException) {
                JobLogging.logError("JDBCDataStore", "Error inserting record", sQLException);
                this.getLog().error((Object)("Error inserting record: " + String.valueOf(sQLException)));
            }
        }
    }

    protected void updateRecord(DataRecord dataRecord) {
        assert (this.m_UpdateInsert);
        Object[] objectArray = dataRecord.getData();
        try {
            int n;
            this.m_UpdateStatement.clearParameters();
            for (n = 0; n < this.m_OtherValues.length; ++n) {
                PreparedStatementUtil.update(this.m_UpdateStatement, n, this.m_Types[this.m_OtherValues[n]], objectArray[this.m_OtherValues[n]]);
            }
            for (n = 0; n < this.m_PrimaryKeys.length; ++n) {
                PreparedStatementUtil.update(this.m_UpdateStatement, this.m_OtherValues.length + n, this.m_Types[this.m_PrimaryKeys[n]], objectArray[this.m_PrimaryKeys[n]]);
            }
            try {
                this.m_UpdateStatement.executeUpdate();
                ++this.m_SuccessCount;
            }
            catch (SQLException sQLException) {
                this.processFail(dataRecord, "update", sQLException);
            }
        }
        catch (SQLException sQLException) {
            JobLogging.logError("JDBCDataStore", "Error updating record", sQLException);
            this.getLog().error((Object)("Error updating record: " + String.valueOf(sQLException)));
        }
    }

    protected void updateAndReturnKeys(DataRecord dataRecord) {
        assert (this.m_UpdateInsert);
        Object[] objectArray = dataRecord.getData();
        try {
            int n;
            this.m_UpdateStatement.clearParameters();
            for (n = 0; n < this.m_OtherValues.length; ++n) {
                PreparedStatementUtil.update(this.m_UpdateStatement, n, this.m_Types[this.m_OtherValues[n]], objectArray[this.m_OtherValues[n]]);
            }
            for (n = 0; n < this.m_PrimaryKeys.length; ++n) {
                PreparedStatementUtil.update(this.m_UpdateStatement, this.m_OtherValues.length + n, this.m_Types[this.m_PrimaryKeys[n]], objectArray[this.m_PrimaryKeys[n]]);
            }
            try {
                this.m_UpdateStatement.executeUpdate();
                ++this.m_SuccessCount;
                JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
                Scriptable scriptable = javaScriptEngine.getScope();
                if (scriptable instanceof CompositeScope) {
                    ((CompositeScope)scriptable).addProperty("JDBC_INSERT_UPDATE_MODE", "UPDATE");
                }
                for (int i = 0; i < this.m_PrimaryKeys.length; ++i) {
                    String string = "JDBC_GENERATED_KEY_" + i;
                    Object object = objectArray[this.m_PrimaryKeys[i]];
                    if (scriptable instanceof CompositeScope) {
                        ((CompositeScope)scriptable).addProperty(string, object);
                        continue;
                    }
                    scriptable.put(string, scriptable, object);
                }
            }
            catch (SQLException sQLException) {
                this.processFail(dataRecord, "update", sQLException);
            }
        }
        catch (SQLException sQLException) {
            JobLogging.logError("JDBCDataStore", "Error updating record", sQLException);
            this.getLog().error((Object)("Error updating record: " + String.valueOf(sQLException)));
        }
    }

    protected void processFail(DataRecord dataRecord, String string, SQLException sQLException) {
        ++this.m_FailCount;
        if (this.m_Errors != null) {
            DataSchema dataSchema = this.m_ErrorSource.getSchema();
            Object[] objectArray = new Object[dataSchema.getColumnCount()];
            System.arraycopy(dataRecord.getData(), 0, objectArray, 0, objectArray.length - 2);
            objectArray[objectArray.length - 2] = string;
            objectArray[objectArray.length - 1] = sQLException != null ? sQLException.getMessage() : "";
            DataRecord dataRecord2 = new DataRecord(dataSchema, objectArray);
            this.m_Errors.processRecord(dataRecord2);
        } else {
            JobLogging.logError("JDBCDataStore", "Error processing record", sQLException);
            this.getLog().error((Object)("Error processing record: " + String.valueOf(sQLException)));
        }
    }
}

