/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.output;

import ambience.api.MongoDBConnectionPools;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.Holder2;
import com.elixirtech.arch.Holder2$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.job.JobLogging$;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.data2.output.DSWrapper;
import com.elixirtech.data2.output.ScalaDataStore;
import com.elixirtech.mongodb.RichMongoCollection;
import com.mongodb.client.result.InsertManyResult;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.UUID;
import monix.execution.Scheduler$;
import org.bson.BsonDocument;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonBoolean$;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonDecimal128$;
import org.mongodb.scala.bson.BsonDouble$;
import org.mongodb.scala.bson.BsonInt32$;
import org.mongodb.scala.bson.BsonInt64$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.jdk.CollectionConverters$;
import scala.math.BigDecimal$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class MongoDBDataStore
implements ScalaDataStore,
LoggingHelper2 {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(MongoDBDataStore.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MongoDBDataStore.class.getDeclaredField("ConnectionPool$lzy1"));
    private volatile Object log$lzy1;
    private final int DefaultBatchSize;
    private final FiniteDuration BatchTimeout = FiniteDuration$.MODULE$.apply(30L, scala.concurrent.duration.package$.MODULE$.SECONDS());
    private volatile Object ConnectionPool$lzy1;
    private final ListBuffer<String> groupLevel = new ListBuffer();
    private Option<BsonString> elxGroup = None$.MODULE$;
    private final ListBuffer<Document> batch = new ListBuffer();
    private String _name = "";
    private DataStore _datastore = null;
    private PushContext cxt = null;
    private final Holder2<String> m_Pool = new Holder2(Holder2$.MODULE$.$lessinit$greater$default$1());
    private final Holder2<String> m_Collection = new Holder2(Holder2$.MODULE$.$lessinit$greater$default$1());
    private final Holder2<Object> m_BatchSize = new Holder2(Holder2$.MODULE$.$lessinit$greater$default$1());
    private Option<RichMongoCollection> optCollection = None$.MODULE$;
    private String uuid = "";
    private List<String> schemaNames = package$.MODULE$.Nil();

    public MongoDBDataStore() {
        this.DefaultBatchSize = 50;
        this.m_BatchSize.set((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.DefaultBatchSize())));
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int DefaultBatchSize() {
        return this.DefaultBatchSize;
    }

    public FiniteDuration BatchTimeout() {
        return this.BatchTimeout;
    }

    public MongoDBConnectionPools ConnectionPool() {
        Object object = this.ConnectionPool$lzy1;
        if (object instanceof MongoDBConnectionPools) {
            return (MongoDBConnectionPools)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (MongoDBConnectionPools)this.ConnectionPool$lzyINIT1();
    }

    private Object ConnectionPool$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.ConnectionPool$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    MongoDBConnectionPools mongoDBConnectionPools = null;
                    try {
                        mongoDBConnectionPools = (MongoDBConnectionPools)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(MongoDBConnectionPools.class));
                        object2 = mongoDBConnectionPools == null ? LazyVals.NullValue$.MODULE$ : mongoDBConnectionPools;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.ConnectionPool$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return mongoDBConnectionPools;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void setPool(String p) {
        this.m_Pool.set((Option<String>)Some$.MODULE$.apply((Object)p));
    }

    public String getPool() {
        return this.m_Pool.getOrElse("");
    }

    public void setCollection(String c) {
        this.m_Collection.set((Option<String>)Some$.MODULE$.apply((Object)c));
    }

    public String getCollection() {
        return this.m_Collection.getOrElse("");
    }

    public void setBatchSize(int b) {
        this.m_BatchSize.set((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)b)));
    }

    public int getBatchSize() {
        return BoxesRunTime.unboxToInt((Object)this.m_BatchSize.getOrElse(BoxesRunTime.boxToInteger((int)100)));
    }

    @Override
    public void startData(IDataSource src) {
        this.uuid = UUID.randomUUID().toString();
        this.log().info(this::startData$$anonfun$1, Line$.MODULE$.apply(66), FullName$.MODULE$.apply("com.elixirtech.data2.output.MongoDBDataStore.startData"));
        JobLogging$.MODULE$.info("MongoDB DataStore", (Function0<String>)((Function0 & Serializable)MongoDBDataStore::startData$$anonfun$2));
        this.groupLevel.clear();
        this.batch.clear();
        String collection = this.cxt.substitute(this.m_Collection.getOrElse(""));
        String pool = this.m_Pool.getOrElse("");
        try {
            this.optCollection = this.ConnectionPool().getDatabase(pool).map((Function1 & Serializable)_$1 -> _$1.getRichCollection(collection));
            if (this.optCollection.isEmpty()) {
                String msg = "Unable to open pool=" + pool + " and collection=" + collection;
                JobLogging$.MODULE$.error("MongoDB DataStore", (Function0<String>)((Function0 & Serializable)() -> MongoDBDataStore.startData$$anonfun$4(msg)));
                this.log().error(() -> this.startData$$anonfun$5(msg), Line$.MODULE$.apply(77), FullName$.MODULE$.apply("com.elixirtech.data2.output.MongoDBDataStore.startData"));
            }
        }
        catch (Exception ex) {
            String msg = "Exception connecting with pool=" + pool + " and collection=" + collection;
            JobLogging$.MODULE$.error("MongoDB DataStore", (Function0<String>)((Function0 & Serializable)() -> MongoDBDataStore.startData$$anonfun$6(msg)), ex);
            this.log().error(() -> this.startData$$anonfun$7(msg), (Throwable)ex, Line$.MODULE$.apply(84), FullName$.MODULE$.apply("com.elixirtech.data2.output.MongoDBDataStore.startData"));
        }
    }

    @Override
    public void startGroup(DataGroup group) {
        this.groupLevel.$plus$eq((Object)group.getName());
        this.elxGroup = Some$.MODULE$.apply((Object)BsonString$.MODULE$.apply(this.groupLevel.mkString("/")));
    }

    @Override
    public boolean processRecord(DataRecord record) {
        if (this.optCollection.isEmpty()) {
            return false;
        }
        if (this.schemaNames.isEmpty()) {
            this.schemaNames = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(record.getSchema().getColumns()).asScala().map((Function1 & Serializable)_$2 -> _$2.name)).toList();
        }
        this.batch.$plus$eq((Object)this.toDocument(record));
        if (this.batch.size() >= BoxesRunTime.unboxToInt((Object)this.m_BatchSize.getOrElse(BoxesRunTime.boxToInteger((int)100)))) {
            this.writeBatch();
        }
        return true;
    }

    @Override
    public void endGroup(DataGroup group) {
        this.groupLevel.remove(this.groupLevel.size() - 1);
        if (this.groupLevel.isEmpty()) {
            this.elxGroup = None$.MODULE$;
            return;
        }
        this.elxGroup = Some$.MODULE$.apply((Object)BsonString$.MODULE$.apply(this.groupLevel.mkString("/")));
    }

    @Override
    public void endData(IDataSource src) {
        if (this.batch.nonEmpty()) {
            this.writeBatch();
        }
        this.log().info(this::endData$$anonfun$1, Line$.MODULE$.apply(109), FullName$.MODULE$.apply("com.elixirtech.data2.output.MongoDBDataStore.endData"));
        JobLogging$.MODULE$.info("MongoDB DataStore", (Function0<String>)((Function0 & Serializable)MongoDBDataStore::endData$$anonfun$2));
    }

    @Override
    public <T> T getAdapter(Class<T> cls) {
        Class<T> clazz = cls;
        Class<IDataSource> clazz2 = IDataSource.class;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            return cls.cast(new DSWrapper(this));
        }
        return null;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public void setContext(PushContext cxt) {
        this.cxt = cxt;
    }

    @Override
    public java.util.List<Parameter> getParameters() {
        ArgumentMap map = new ArgumentMap();
        map.extractParameters(this.m_Collection.getOrElse(""));
        return map.getParameters();
    }

    @Override
    public DataStore getDataStore() {
        return this._datastore;
    }

    @Override
    public void setDataStore(DataStore store) {
        this._datastore = store;
    }

    public Document toDocument(DataRecord rec) {
        BsonDocument doc = new BsonDocument();
        this.elxGroup.foreach((Function1 & Serializable)_$3 -> doc.append("_elxGroup", (BsonValue)_$3));
        ((List)this.schemaNames.zipWithIndex()).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return doc.append(name, this.toBson(rec.getData(i)));
            }
            throw new MatchError((Object)tuple2);
        });
        return Document$.MODULE$.apply(doc);
    }

    /*
     * Enabled aggressive block sorting
     */
    public BsonValue toBson(Object obj) {
        BsonNull bsonNull;
        Option option = Option$.MODULE$.apply(obj);
        if (option instanceof Some) {
            Object object = ((Some)option).value();
            if (object instanceof String) {
                String s = (String)object;
                bsonNull = BsonString$.MODULE$.apply(s);
                return (BsonValue)bsonNull;
            }
            if (object instanceof Boolean) {
                Boolean b = (Boolean)object;
                bsonNull = BsonBoolean$.MODULE$.apply(Predef$.MODULE$.Boolean2boolean(b));
                return (BsonValue)bsonNull;
            }
            if (object instanceof Long) {
                Long n = (Long)object;
                bsonNull = BsonInt64$.MODULE$.apply(Predef$.MODULE$.Long2long(n));
                return (BsonValue)bsonNull;
            }
            if (object instanceof Integer) {
                Integer n = (Integer)object;
                bsonNull = BsonInt32$.MODULE$.apply(Predef$.MODULE$.Integer2int(n));
                return (BsonValue)bsonNull;
            }
            if (object instanceof Double) {
                Double n = (Double)object;
                bsonNull = BsonDouble$.MODULE$.apply(Predef$.MODULE$.Double2double(n));
                return (BsonValue)bsonNull;
            }
            if (object instanceof Float) {
                Float n = (Float)object;
                bsonNull = BsonDouble$.MODULE$.apply(n.doubleValue());
                return (BsonValue)bsonNull;
            }
            if (object instanceof BigDecimal) {
                BigDecimal n = (BigDecimal)object;
                bsonNull = BsonDecimal128$.MODULE$.apply(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(n));
                return (BsonValue)bsonNull;
            }
            if (object instanceof Date) {
                Date n = (Date)object;
                bsonNull = BsonDateTime$.MODULE$.apply(n);
                return (BsonValue)bsonNull;
            }
        }
        if (None$.MODULE$.equals(option)) {
            bsonNull = BsonNull.VALUE;
            return (BsonValue)bsonNull;
        }
        bsonNull = BsonString$.MODULE$.apply(obj.toString());
        return (BsonValue)bsonNull;
    }

    public void writeBatch() {
        if (BoxesRunTime.unboxToInt((Object)this.m_BatchSize.getOrElse(BoxesRunTime.boxToInteger((int)100))) > 1) {
            this.log().info(this::writeBatch$$anonfun$1, Line$.MODULE$.apply(166), FullName$.MODULE$.apply("com.elixirtech.data2.output.MongoDBDataStore.writeBatch"));
            JobLogging$.MODULE$.info("MongoDB DataStore", (Function0<String>)((Function0 & Serializable)this::writeBatch$$anonfun$2));
        }
        this.optCollection.foreach((Function1 & Serializable)cltn -> (InsertManyResult)Await$.MODULE$.result((Awaitable)cltn.insertManyT(this.batch.toSeq()).runToFuture(Scheduler$.MODULE$.global()), (Duration)this.BatchTimeout()));
        this.batch.clear();
    }

    private final Object startData$$anonfun$1() {
        return this.uuid + " startData";
    }

    private static final String startData$$anonfun$2() {
        return "startData";
    }

    private static final String startData$$anonfun$4(String msg$1) {
        return msg$1;
    }

    private final Object startData$$anonfun$5(String msg$2) {
        return this.uuid + " " + msg$2;
    }

    private static final String startData$$anonfun$6(String msg$3) {
        return msg$3;
    }

    private final Object startData$$anonfun$7(String msg$4) {
        return this.uuid + " " + msg$4;
    }

    private final Object endData$$anonfun$1() {
        return this.uuid + " endData";
    }

    private static final String endData$$anonfun$2() {
        return "endData";
    }

    private final Object writeBatch$$anonfun$1() {
        return this.uuid + " Writing batch size " + this.batch.size();
    }

    private final String writeBatch$$anonfun$2() {
        return "Writing batch size " + this.batch.size();
    }
}

