/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.types;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeDataType
extends DataType {
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(TimeDataType.class);

    @Override
    public int getTypeId() {
        return 12;
    }

    @Override
    public String getTypeName() {
        return "Time";
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public Object defaultValue() {
        return new Date(0L);
    }

    @Override
    public int compare(Object object, Object object2) {
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        Date date = (Date)object;
        Date date2 = (Date)object2;
        return date.compareTo(date2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date narrow(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Number) {
            return new Date(((Number)object).longValue());
        }
        try {
            String string = String.valueOf(object);
            if (string.trim().length() == 0) {
                return null;
            }
            DateFormat dateFormat = TIME_FORMAT;
            synchronized (dateFormat) {
                return TIME_FORMAT.parse(string);
            }
        }
        catch (ParseException parseException) {
            m_Log.error((Object)("Cannot parse " + String.valueOf(object) + " as a Time"));
            return new Date(0L);
        }
    }

    @Override
    public int writeLength(Object object) {
        if (object == null) {
            return 1;
        }
        return 9;
    }

    @Override
    public void write(DataOutputStream dataOutputStream, Object object) throws IOException {
        if (object == null) {
            dataOutputStream.writeByte(0);
        } else {
            Date date = (Date)object;
            dataOutputStream.writeByte(12);
            dataOutputStream.writeLong(date.getTime());
        }
    }

    @Override
    public Object read(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        if (by == 0) {
            return null;
        }
        if (by != 12) {
            throw new IOException("Time tag expected, got " + by);
        }
        long l = dataInputStream.readLong();
        return new Date(l);
    }
}

