/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.types;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimestampDataType
extends DataType {
    private static final DateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(TimestampDataType.class);

    @Override
    public int getTypeId() {
        return 13;
    }

    @Override
    public String getTypeName() {
        return "Timestamp";
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public Object defaultValue() {
        return new Date(0L);
    }

    @Override
    public int compare(Object object, Object object2) {
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        Date date = (Date)object;
        Date date2 = (Date)object2;
        return date.compareTo(date2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date narrow(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Number) {
            return new Date(((Number)object).longValue());
        }
        try {
            String string = String.valueOf(object);
            if (string.trim().length() == 0) {
                return null;
            }
            DateFormat dateFormat = TIMESTAMP_FORMAT;
            synchronized (dateFormat) {
                return TIMESTAMP_FORMAT.parse(string);
            }
        }
        catch (ParseException parseException) {
            m_Log.error((Object)("Cannot parse " + String.valueOf(object) + " as a Timestamp"));
            return new Date(0L);
        }
    }

    @Override
    public int writeLength(Object object) {
        if (object == null) {
            return 1;
        }
        return 9;
    }

    @Override
    public void write(DataOutputStream dataOutputStream, Object object) throws IOException {
        if (object == null) {
            dataOutputStream.writeByte(0);
        } else {
            Date date = (Date)object;
            dataOutputStream.writeByte(13);
            dataOutputStream.writeLong(date.getTime());
        }
    }

    @Override
    public Object read(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        if (by == 0) {
            return null;
        }
        if (by != 13) {
            throw new IOException("Timestamp tag expected, got " + by);
        }
        long l = dataInputStream.readLong();
        return new Date(l);
    }
}

