/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.canvas;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.canvas.graph.RelCol;
import com.elixirtech.canvas.graph.RelType;
import com.elixirtech.canvas.graph.Relationship;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.ensemble.LoadSchema;
import com.elixirtech.ensemble.canvas.GOUtil;
import com.elixirtech.ensemble.canvas.InOutGO;
import com.elixirtech.ensemble.canvas.InitialText;
import com.elixirtech.ensemble.canvas.ParameterNode;
import java.util.Set;

public class DataSourceGO
extends InOutGO {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DataSourceGO.class);

    public DataSourceGO() {
        this.m_Outs.add(new InOutGO.Out(this, "data", 0.5));
        this.m_Text = InitialText.DataSourceGO();
    }

    @Override
    public DataSchema getSchema() {
        DataSchema dataSchema = this.getOriginalSchema();
        if (dataSchema == null) {
            return null;
        }
        SchemaBuilder schemaBuilder = new SchemaBuilder(dataSchema);
        Set<String> set = GOUtil.getDiscardSet(this, "DataSource_Discard");
        schemaBuilder.discard(set);
        return schemaBuilder.getSchema();
    }

    public String getDSName() {
        return this.getUserProperty("DataSource");
    }

    public DataSchema getOriginalSchema() {
        return LoadSchema.getSchemaJ(this.getDSName());
    }

    public IDataSource getDataSource() {
        String string = this.getDSName();
        if (string != null) {
            DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
            if (dataSourceManager != null) {
                IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, string);
                return iDataSource;
            }
            m_Log.info((Object)("No DataSourceManager available to resolve " + string));
        }
        return null;
    }

    @Override
    public void buildParameters(ArgumentMap argumentMap) {
        int n = this.getParameterCount();
        for (int i = 0; i < n; ++i) {
            ParameterNode parameterNode = this.getParameter(i);
            argumentMap.extractParameters(parameterNode.getValue());
        }
    }

    public void removeAllParameters() {
        this.removeOutRelationships(RelType.Owns);
    }

    public void addParameter(String string, String string2) {
        ParameterNode parameterNode = new ParameterNode(string, string2);
        this.connectTo(parameterNode, RelType.Owns);
    }

    public int getParameterCount() {
        RelCol relCol = this.getOutRelCol(RelType.Owns);
        return relCol.getCount();
    }

    public ParameterNode getParameter(int n) {
        RelCol relCol = this.getOutRelCol(RelType.Owns);
        Relationship relationship = relCol.getItem(n);
        return (ParameterNode)relationship.getDestination();
    }
}

