/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.canvas;

import com.elixirtech.canvas.graph.Node;
import com.elixirtech.canvas.graph.RelCol;
import com.elixirtech.canvas.graph.RelType;
import com.elixirtech.ensemble.canvas.SortNode;
import java.util.Map;

public class DimensionNode
extends Node {
    private String m_Name;

    public DimensionNode() {
    }

    public DimensionNode(String string, SortNode[] sortNodeArray) {
        this.m_Name = string;
        for (int i = 0; i < sortNodeArray.length; ++i) {
            SortNode sortNode = sortNodeArray[i];
            if (sortNode.getClass() != SortNode.class) {
                sortNode = new SortNode(sortNode);
            }
            this.connectTo(sortNode, RelType.Owns);
        }
    }

    public String getName() {
        return this.m_Name;
    }

    public SortNode[] getPath() {
        RelCol relCol = this.getOutRelCol(RelType.Owns);
        SortNode[] sortNodeArray = new SortNode[relCol.getCount()];
        for (int i = 0; i < sortNodeArray.length; ++i) {
            sortNodeArray[i] = (SortNode)relCol.getItem(i).getDestination();
        }
        return sortNodeArray;
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> map = super.getProperties();
        map.put("Name", this.m_Name);
        return map;
    }

    @Override
    public void setProperty(String string, String string2) {
        if (string.equals("Name")) {
            this.m_Name = string2;
        } else if (string.equals("Path")) {
            String[] stringArray = string2.split("/");
            for (int i = 0; i < stringArray.length; ++i) {
                SortNode sortNode = new SortNode();
                sortNode.setName(stringArray[i]);
                sortNode.setSortOrder("Ascending");
                sortNode.setGroupOn("Each Value");
                this.connectTo(sortNode, RelType.Owns);
            }
        }
    }
}

