/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.canvas;

import com.elixirtech.canvas.graph.Node;
import com.elixirtech.canvas.graph.RelCol;
import com.elixirtech.canvas.graph.RelType;
import com.elixirtech.data2.DataAttribute;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.ensemble.canvas.AttributeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SchemaNode
extends Node {
    private boolean m_IsCaseSensitive;
    private String m_DateFormat;
    private String m_TimeFormat;
    private String m_TimestampFormat;

    public SchemaNode() {
    }

    public SchemaNode(DataSchema dataSchema) {
        this.m_IsCaseSensitive = dataSchema.isCaseSensitive();
        this.m_DateFormat = dataSchema.getDateFormat();
        this.m_TimeFormat = dataSchema.getTimeFormat();
        this.m_TimestampFormat = dataSchema.getTimestampFormat();
        int n = dataSchema.getColumnCount();
        for (int i = 0; i < n; ++i) {
            ItemNode itemNode = new ItemNode(dataSchema.getColumnName(i), dataSchema.getColumnType(i), dataSchema.getAttributes(i));
            this.connectTo(itemNode, RelType.Owns);
        }
    }

    public DataSchema getSchema() {
        SchemaBuilder schemaBuilder = new SchemaBuilder(this.m_IsCaseSensitive);
        RelCol relCol = this.getOutRelCol(RelType.Owns);
        for (Node node : relCol.getTargetElements()) {
            ItemNode itemNode = (ItemNode)node;
            schemaBuilder.add(itemNode.getName(), itemNode.getType(), itemNode.getAttributes());
        }
        DataSchema dataSchema = schemaBuilder.getSchema();
        dataSchema.setDateFormat(this.m_DateFormat);
        dataSchema.setTimeFormat(this.m_TimeFormat);
        dataSchema.setTimestampFormat(this.m_TimestampFormat);
        return dataSchema;
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> map = super.getProperties();
        map.put("CaseSensitive", this.m_IsCaseSensitive ? "Yes" : "No");
        map.put("DateFormat", this.m_DateFormat);
        map.put("TimeFormat", this.m_TimeFormat);
        map.put("TimestampFormat", this.m_TimestampFormat);
        return map;
    }

    @Override
    public void setProperty(String string, String string2) {
        if (string.equals("CaseSensitive")) {
            this.m_IsCaseSensitive = "Yes".equals(string2);
        } else if (string.equals("DateFormat")) {
            this.m_DateFormat = string2;
        } else if (string.equals("TimeFormat")) {
            this.m_TimeFormat = string2;
        } else if (string.equals("TimestampFormat")) {
            this.m_TimestampFormat = string2;
        } else {
            super.setProperty(string, string2);
        }
    }

    public static class ItemNode
    extends Node {
        private String m_Name;
        private DataType m_Type;

        public ItemNode() {
        }

        public ItemNode(String string, DataType dataType, DataAttributes dataAttributes) {
            this.m_Name = string;
            this.m_Type = dataType;
            if (dataAttributes != null) {
                for (DataAttribute dataAttribute : dataAttributes.getAttributes()) {
                    AttributeNode attributeNode = new AttributeNode(dataAttribute);
                    this.connectTo(attributeNode, RelType.Owns);
                }
            }
        }

        public ItemNode(String string, DataType dataType, List<DataAttribute> list) {
            this.m_Name = string;
            this.m_Type = dataType;
            if (list != null) {
                for (DataAttribute dataAttribute : list) {
                    AttributeNode attributeNode = new AttributeNode(dataAttribute);
                    this.connectTo(attributeNode, RelType.Owns);
                }
            }
        }

        public String getName() {
            return this.m_Name;
        }

        public DataType getType() {
            return this.m_Type;
        }

        public DataAttributes getAttributes() {
            RelCol relCol = this.getOutRelCol(RelType.Owns);
            ArrayList<DataAttribute> arrayList = new ArrayList<DataAttribute>();
            int n = relCol.getCount();
            for (int i = 0; i < n; ++i) {
                AttributeNode attributeNode = (AttributeNode)relCol.getItem(i).getDestination();
                arrayList.add(attributeNode.getDataAttribute());
            }
            return new DataAttributes(arrayList);
        }

        @Override
        public Map<String, String> getProperties() {
            Map<String, String> map = super.getProperties();
            map.put("Name", this.m_Name);
            map.put("Type", this.m_Type.getTypeName());
            return map;
        }

        @Override
        public void setProperty(String string, String string2) {
            if (string.equals("Name")) {
                this.m_Name = string2;
            } else if (string.equals("Type")) {
                this.m_Type = DataType.getInstance(string2);
            } else {
                super.setProperty(string, string2);
            }
        }
    }
}

