/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.cube;

import com.elixirtech.ensemble.cube.ITableStyle;
import java.awt.Color;

public class TableStyle
implements ITableStyle {
    private int m_TotalDepth;
    private Color m_Depth0;
    private Color m_Depth100;
    private Color[] m_Colors;

    public TableStyle(Color color, Color color2, int n) {
        this.m_Depth0 = color;
        this.m_Depth100 = color2;
        this.m_TotalDepth = n;
        this.m_Colors = new Color[n + 1];
        for (int i = 0; i <= n; ++i) {
            this.m_Colors[i] = this.calcTreeColor(i);
        }
    }

    @Override
    public Color getTreeColor(int n) {
        return this.m_Colors[n];
    }

    private Color calcTreeColor(int n) {
        if (this.m_Depth0 == null || this.m_Depth100 == null) {
            return null;
        }
        if (this.m_TotalDepth == 0) {
            return this.m_Depth0;
        }
        double d = (double)n / (double)this.m_TotalDepth;
        int n2 = this.m_Depth0.getRed();
        int n3 = this.m_Depth0.getGreen();
        int n4 = this.m_Depth0.getBlue();
        int n5 = this.m_Depth0.getAlpha();
        n2 += (int)(d * (double)(this.m_Depth100.getRed() - n2));
        n3 += (int)(d * (double)(this.m_Depth100.getGreen() - n3));
        n4 += (int)(d * (double)(this.m_Depth100.getBlue() - n4));
        n5 += (int)(d * (double)(this.m_Depth100.getAlpha() - n5));
        return new Color(n2, n3, n4, n5);
    }
}

