/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.ds;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.canvas.corego.Diagram;
import com.elixirtech.canvas.corego.GO;
import com.elixirtech.data2.AbstractDataSource;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.datasource.NamedDataSource;
import com.elixirtech.data2.datasource.RefDataSource;
import com.elixirtech.data2.datasource.composite.CompositeDataSource;
import com.elixirtech.data2.datasource.composite.DataDropDataSource;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.data2.datasource.composite.DataStoreRegistry;
import com.elixirtech.data2.datasource.discard.DiscardDataSource;
import com.elixirtech.ensemble.canvas.CacheGO;
import com.elixirtech.ensemble.canvas.ConcatGO;
import com.elixirtech.ensemble.canvas.CubeGO;
import com.elixirtech.ensemble.canvas.DataDropGO;
import com.elixirtech.ensemble.canvas.DataFlowGO;
import com.elixirtech.ensemble.canvas.DataSourceGO;
import com.elixirtech.ensemble.canvas.DataStoreGO;
import com.elixirtech.ensemble.canvas.DerivativeGO;
import com.elixirtech.ensemble.canvas.FilterGO;
import com.elixirtech.ensemble.canvas.GOUtil;
import com.elixirtech.ensemble.canvas.InOutGO;
import com.elixirtech.ensemble.canvas.JoinGO;
import com.elixirtech.ensemble.canvas.ParameterNode;
import com.elixirtech.ensemble.canvas.ParametersGO;
import com.elixirtech.ensemble.canvas.ProcessorGO;
import com.elixirtech.ensemble.canvas.ResultGO;
import com.elixirtech.ensemble.canvas.SortGO;
import com.elixirtech.ensemble.canvas.sub.InputGO;
import com.elixirtech.ensemble.canvas.sub.OutputGO;
import com.elixirtech.ensemble.canvas.sub.SubCompositeDiagram;
import com.elixirtech.ensemble.canvas.sub.SubGO;
import com.elixirtech.ensemble.ds.builders.BuildContext;
import com.elixirtech.ensemble.ds.builders.CacheBuilder;
import com.elixirtech.ensemble.ds.builders.ConcatBuilder;
import com.elixirtech.ensemble.ds.builders.CubeBuilder;
import com.elixirtech.ensemble.ds.builders.DerivativeBuilder;
import com.elixirtech.ensemble.ds.builders.FilterBuilder;
import com.elixirtech.ensemble.ds.builders.InputBuilder;
import com.elixirtech.ensemble.ds.builders.JoinBuilder;
import com.elixirtech.ensemble.ds.builders.OutputBuilder;
import com.elixirtech.ensemble.ds.builders.ParametersBuilder;
import com.elixirtech.ensemble.ds.builders.ProcessorBuilder;
import com.elixirtech.ensemble.ds.builders.SortBuilder;
import com.elixirtech.ensemble.ds.builders.SubFlowBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DSBuilder
implements Data2Constants {
    CompositeDataSource m_Composite;
    Diagram m_Diagram;
    Map<InOutGO, String> m_Names = new HashMap<InOutGO, String>();
    Map<String, IDataSource> m_DataSources = new HashMap<String, IDataSource>();
    private DataSourceManager m_DSM = new DSM();
    private BuildContext m_BuildContext = new MyBuildContext();
    private FilterBuilder m_FilterBuilder = new FilterBuilder();
    private DerivativeBuilder m_DerivativeBuilder = new DerivativeBuilder();
    private JoinBuilder m_JoinBuilder = new JoinBuilder();
    private CubeBuilder m_CubeBuilder = new CubeBuilder();
    private CacheBuilder m_CacheBuilder = new CacheBuilder();
    private SortBuilder m_SortBuilder = new SortBuilder();
    private ConcatBuilder m_ConcatBuilder = new ConcatBuilder();
    private ParametersBuilder m_ParametersBuilder = new ParametersBuilder();
    private SubFlowBuilder m_SubFlowBuilder = new SubFlowBuilder();
    private OutputBuilder m_OutputBuilder = new OutputBuilder();
    private InputBuilder m_InputBuilder = new InputBuilder();
    private ProcessorBuilder m_ProcessorBuilder = new ProcessorBuilder();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DSBuilder.class);

    public DSBuilder(CompositeDataSource compositeDataSource) {
        this.m_Composite = compositeDataSource;
        this.m_Diagram = compositeDataSource.getDiagram();
        this.m_Composite.init();
        this.buildChildDataSources();
        this.buildResult();
        if (this.m_Diagram != null) {
            this.buildChildDataStores(this.m_Diagram);
        }
    }

    public void buildSpecial(InOutGO inOutGO) {
        this.m_BuildContext.addGO(inOutGO);
    }

    protected void buildChildDataSources() {
        if (this.m_Diagram != null) {
            for (GO gO : this.m_Diagram.getChildGOs()) {
                if (!(gO instanceof DataSourceGO)) continue;
                this.addDataSource((DataSourceGO)gO);
            }
        }
    }

    protected void buildChildDataStores(Diagram diagram) {
        for (GO gO : diagram.getChildGOs()) {
            SubCompositeDiagram subCompositeDiagram;
            if (gO instanceof DataStoreGO) {
                this.addDataStore((DataStoreGO)gO);
                continue;
            }
            if (!(gO instanceof SubGO) || (subCompositeDiagram = ((SubGO)gO).getSubDiagram()) == null) continue;
            this.buildChildDataStores(subCompositeDiagram);
        }
    }

    protected void buildResult() {
        if (this.m_Diagram != null) {
            for (GO gO : this.m_Diagram.getChildGOs()) {
                if (!(gO instanceof ResultGO)) continue;
                this.addResult((ResultGO)gO);
                break;
            }
        }
    }

    protected void addDataSource(DataSourceGO dataSourceGO) {
        IDataSource iDataSource;
        Object object = dataSourceGO.getUserProperty("DataSource");
        String string = this.m_BuildContext.getNodeId(dataSourceGO);
        Set<String> set = GOUtil.getDiscardSet(dataSourceGO, "DataSource_Discard");
        if (set.size() > 0) {
            try {
                iDataSource = this.m_DSM.getDataSource(this.m_DSM, (String)object);
                object = string + "_discard";
                DiscardDataSource discardDataSource = new DiscardDataSource((String)object, iDataSource);
                discardDataSource.setDiscardSet(set);
                this.m_DataSources.put((String)object, discardDataSource);
            }
            catch (RuntimeException runtimeException) {
                m_Log.error((Object)("Can't add datasource " + (String)object));
            }
        }
        iDataSource = new RefDataSource(string, this.m_DSM, (String)object);
        ((RefDataSource)iDataSource).setScoped(true);
        int n = dataSourceGO.getParameterCount();
        for (int i = 0; i < n; ++i) {
            ParameterNode parameterNode = dataSourceGO.getParameter(i);
            ((RefDataSource)iDataSource).addArgument(parameterNode.getName(), parameterNode.getValue());
        }
        this.m_DataSources.put(string, iDataSource);
        this.m_Composite.addDataSource(dataSourceGO, iDataSource);
    }

    protected void addDataStore(DataStoreGO dataStoreGO) {
        if (dataStoreGO.getSchema() != null) {
            List<DataFlowGO> list = dataStoreGO.getFlowGOs(dataStoreGO.getIn("save"));
            if (list.size() != 1) {
                return;
            }
            DataFlowGO dataFlowGO = list.get(0);
            InOutGO inOutGO = (InOutGO)dataFlowGO.getStartGO();
            this.m_BuildContext.addGO(inOutGO);
            IDataSource iDataSource = this.m_BuildContext.getDataSource(inOutGO);
            String string = dataStoreGO.getType();
            String string2 = DataStoreRegistry.getPrefix(string);
            DataStore dataStore = new DataStore(string);
            dataStore.setName(dataStoreGO.getText());
            this.copy(dataStoreGO, dataStore, string2);
            ArgumentMap argumentMap = new ArgumentMap();
            dataStoreGO.buildParameters(argumentMap);
            for (Parameter list2 : argumentMap.getParameters()) {
                dataStore.addParameter(list2);
            }
            this.m_Composite.addDataStore(dataStoreGO, dataStore);
            if (dataStoreGO instanceof DataDropGO) {
                var10_10 = GOUtil.getDiscardSet(dataStoreGO, "DataStore_Discard");
                List<String> list2 = GOUtil.getOrderList(dataStoreGO, "DataStore_Order");
                String string3 = this.m_BuildContext.getNodeId(dataStoreGO);
                DataDropDataSource dataDropDataSource = new DataDropDataSource(string3, iDataSource, dataStore, var10_10, list2);
                this.m_DataSources.put(string3, dataDropDataSource);
                this.m_Composite.addDataSource(dataStoreGO, dataDropDataSource);
                dataStore.setDataSource(dataDropDataSource);
            } else {
                var10_10 = GOUtil.getDiscardSet(dataStoreGO, "DataStore_Discard");
                List<String> list3 = GOUtil.getOrderList(dataStoreGO, "DataStore_Order");
                if (!var10_10.isEmpty() || !list3.isEmpty()) {
                    String string4 = this.m_BuildContext.getNodeId(dataStoreGO);
                    String string5 = string4 + "_discard";
                    DiscardDataSource discardDataSource = new DiscardDataSource(string5, iDataSource);
                    discardDataSource.setDiscardSet(var10_10);
                    discardDataSource.setOrderList(list3);
                    this.m_DataSources.put(string5, discardDataSource);
                    iDataSource = discardDataSource;
                }
                dataStore.setDataSource(iDataSource);
            }
        }
    }

    protected void copy(DataStoreGO dataStoreGO, DataStore dataStore, String string) {
        Map<String, String> map = dataStoreGO.getUserProperties();
        for (String string2 : map.keySet()) {
            if (!string2.startsWith(string)) continue;
            dataStore.setProperty(string2, map.get(string2));
        }
    }

    protected void addResult(ResultGO resultGO) {
        if (resultGO.getSchema() != null) {
            AbstractDataSource abstractDataSource;
            Object object;
            List<DataFlowGO> list = resultGO.getFlowGOs(resultGO.getIn("result"));
            DataFlowGO dataFlowGO = list.get(0);
            InOutGO inOutGO = (InOutGO)dataFlowGO.getStartGO();
            this.m_BuildContext.addGO(inOutGO);
            Object object2 = this.m_BuildContext.getNodeId(inOutGO);
            Set<String> set = GOUtil.getDiscardSet(resultGO, "Result_Discard");
            if (set.size() > 0) {
                object = (String)object2 + "_discard";
                abstractDataSource = new DiscardDataSource((String)object, this.m_DataSources.get(object2));
                ((DiscardDataSource)abstractDataSource).setDiscardSet(set);
                this.m_DataSources.put((String)object, abstractDataSource);
                object2 = object;
            }
            object = this.m_BuildContext.getNodeId(resultGO);
            abstractDataSource = new RefDataSource((String)object, this.m_DSM, (String)object2);
            this.m_Composite.setResult(abstractDataSource);
            ArgumentMap argumentMap = new ArgumentMap();
            resultGO.buildParameters(argumentMap);
            List<Parameter> list2 = argumentMap.getParameters();
            this.m_Composite.setParameters(list2);
        }
    }

    protected void addFilter(FilterGO filterGO) {
        this.m_FilterBuilder.build(this.m_BuildContext, filterGO);
    }

    protected void addJoin(JoinGO joinGO) {
        this.m_JoinBuilder.build(this.m_BuildContext, joinGO);
    }

    protected void addDerivative(DerivativeGO derivativeGO) {
        this.m_DerivativeBuilder.build(this.m_BuildContext, derivativeGO);
    }

    protected void addCube(CubeGO cubeGO) {
        this.m_CubeBuilder.build(this.m_BuildContext, cubeGO);
    }

    protected void addCache(CacheGO cacheGO) {
        this.m_CacheBuilder.build(this.m_BuildContext, cacheGO);
    }

    protected void addSort(SortGO sortGO) {
        this.m_SortBuilder.build(this.m_BuildContext, sortGO);
    }

    protected void addConcat(ConcatGO concatGO) {
        this.m_ConcatBuilder.build(this.m_BuildContext, concatGO);
    }

    protected void addParameters(ParametersGO parametersGO) {
        this.m_ParametersBuilder.build(this.m_BuildContext, parametersGO);
    }

    protected void addSubFlow(SubGO subGO) {
        this.m_SubFlowBuilder.build(this.m_BuildContext, subGO);
    }

    protected void addOutput(OutputGO outputGO) {
        this.m_OutputBuilder.build(this.m_BuildContext, outputGO);
    }

    protected void addInput(InputGO inputGO) {
        this.m_InputBuilder.build(this.m_BuildContext, inputGO);
    }

    protected void addProcessor(ProcessorGO processorGO) {
        this.m_ProcessorBuilder.build(this.m_BuildContext, processorGO);
    }

    private class DSM
    implements DataSourceManager {
        private DSM() {
        }

        @Override
        public IDataSource getDataSource(DataSourceManager dataSourceManager, String string) {
            IDataSource iDataSource = DSBuilder.this.m_DataSources.get(string);
            if (iDataSource != null) {
                return iDataSource;
            }
            DataSourceManager dataSourceManager2 = (DataSourceManager)Elixir.get(DataSourceManager.class);
            return new NamedDataSource(string, dataSourceManager2.getDataSource(dataSourceManager, string));
        }
    }

    private class MyBuildContext
    implements BuildContext {
        private MyBuildContext() {
        }

        @Override
        public void addGO(InOutGO inOutGO) {
            if (DSBuilder.this.m_Composite.getDataSource(inOutGO) == null) {
                if (inOutGO instanceof FilterGO) {
                    DSBuilder.this.addFilter((FilterGO)inOutGO);
                } else if (inOutGO instanceof JoinGO) {
                    DSBuilder.this.addJoin((JoinGO)inOutGO);
                } else if (inOutGO instanceof DerivativeGO) {
                    DSBuilder.this.addDerivative((DerivativeGO)inOutGO);
                } else if (inOutGO instanceof CubeGO) {
                    DSBuilder.this.addCube((CubeGO)inOutGO);
                } else if (inOutGO instanceof CacheGO) {
                    DSBuilder.this.addCache((CacheGO)inOutGO);
                } else if (inOutGO instanceof SortGO) {
                    DSBuilder.this.addSort((SortGO)inOutGO);
                } else if (inOutGO instanceof ConcatGO) {
                    DSBuilder.this.addConcat((ConcatGO)inOutGO);
                } else if (inOutGO instanceof ParametersGO) {
                    DSBuilder.this.addParameters((ParametersGO)inOutGO);
                } else if (inOutGO instanceof SubGO) {
                    DSBuilder.this.addSubFlow((SubGO)inOutGO);
                } else if (inOutGO instanceof OutputGO) {
                    DSBuilder.this.addOutput((OutputGO)inOutGO);
                } else if (inOutGO instanceof InputGO) {
                    DSBuilder.this.addInput((InputGO)inOutGO);
                } else if (inOutGO instanceof DataDropGO) {
                    DSBuilder.this.addDataStore((DataStoreGO)inOutGO);
                } else if (inOutGO instanceof ProcessorGO) {
                    DSBuilder.this.addProcessor((ProcessorGO)inOutGO);
                } else if (inOutGO instanceof DataSourceGO) {
                    DSBuilder.this.addDataSource((DataSourceGO)inOutGO);
                } else {
                    m_Log.warn((Object)("Not adding " + inOutGO.getClass().getName()));
                }
            }
        }

        @Override
        public void addDataSource(InOutGO inOutGO, String string, IDataSource iDataSource) {
            DSBuilder.this.m_DataSources.put(string, iDataSource);
            DSBuilder.this.m_Composite.addDataSource(inOutGO, iDataSource);
        }

        @Override
        public IDataSource getDataSource(String string) {
            IDataSource iDataSource = DSBuilder.this.m_DataSources.get(string);
            if (iDataSource == null) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String string2 : DSBuilder.this.m_DataSources.keySet()) {
                    stringBuilder.append(string2).append(" ");
                }
                m_Log.error((Object)("Can't find " + string + " choices: " + stringBuilder.toString()));
            }
            return iDataSource;
        }

        @Override
        public IDataSource getDataSource(InOutGO inOutGO) {
            this.addGO(inOutGO);
            IDataSource iDataSource = DSBuilder.this.m_Composite.getDataSource(inOutGO);
            if (iDataSource == null && inOutGO instanceof DataSourceGO) {
                iDataSource = ((DataSourceGO)inOutGO).getDataSource();
            }
            return iDataSource;
        }

        @Override
        public String getNodeId(InOutGO inOutGO) {
            if (DSBuilder.this.m_Diagram == null) {
                return null;
            }
            String string = DSBuilder.this.m_Diagram.getNodeId(inOutGO);
            return string;
        }
    }
}

