/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.ds.builders;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.datasource.filter.AndFilter;
import com.elixirtech.data2.datasource.filter.EqualsFilter;
import com.elixirtech.data2.datasource.filter.Filter;
import com.elixirtech.data2.datasource.filter.FilteredDataSource;
import com.elixirtech.data2.datasource.filter.InDataSetFilter;
import com.elixirtech.data2.datasource.filter.InRangeFilter;
import com.elixirtech.data2.datasource.filter.JavaScriptFilter;
import com.elixirtech.data2.datasource.filter.LessThanFilter;
import com.elixirtech.data2.datasource.filter.MoreThanFilter;
import com.elixirtech.data2.datasource.filter.NotWrapper;
import com.elixirtech.data2.datasource.filter.NullFilter;
import com.elixirtech.data2.datasource.filter.OrFilter;
import com.elixirtech.data2.datasource.filter.RegExpFilter;
import com.elixirtech.data2.datasource.filter.When;
import com.elixirtech.ensemble.canvas.DataFlowGO;
import com.elixirtech.ensemble.canvas.FilterGO;
import com.elixirtech.ensemble.canvas.FilterNode;
import com.elixirtech.ensemble.canvas.InOutGO;
import com.elixirtech.ensemble.ds.builders.BuildContext;
import java.util.List;

public class FilterBuilder {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(FilterBuilder.class);

    public void build(BuildContext buildContext, InOutGO inOutGO) {
        FilterGO filterGO = (FilterGO)inOutGO;
        List<DataFlowGO> list = filterGO.getFlowGOs(filterGO.getIn("filter"));
        if (list.size() != 1) {
            return;
        }
        DataFlowGO dataFlowGO = list.get(0);
        InOutGO inOutGO2 = (InOutGO)dataFlowGO.getStartGO();
        buildContext.addGO(inOutGO2);
        String string = buildContext.getNodeId(inOutGO2);
        DataSchema dataSchema = dataFlowGO.getSchema();
        if (string != null && dataSchema != null) {
            String string2;
            int n;
            String string3 = buildContext.getNodeId(filterGO);
            FilteredDataSource filteredDataSource = new FilteredDataSource(string3, buildContext.getDataSource(string));
            OrFilter orFilter = new OrFilter();
            AndFilter[] andFilterArray = new AndFilter[3];
            int n2 = filterGO.getFilterCount();
            for (n = 0; n < n2; ++n) {
                Filter filter;
                FilterNode filterNode = filterGO.getFilter(n);
                int n3 = filterNode.getSetId();
                When when = filterNode.getWhen();
                boolean bl = when.getName().startsWith("Not ");
                if (bl) {
                    when = When.getInstance(when.getName().substring(4));
                }
                if ((filter = FilterBuilder.buildFilter(filterGO, filterNode, when)) == null) continue;
                if (bl) {
                    filter = new NotWrapper(filter);
                }
                if (andFilterArray[n3] == null) {
                    andFilterArray[n3] = new AndFilter();
                }
                andFilterArray[n3].addFilter(filter);
            }
            for (n = 0; n < andFilterArray.length; ++n) {
                if (andFilterArray[n] == null) continue;
                orFilter.addFilter(andFilterArray[n]);
            }
            if (orFilter.getFilters().hasNext()) {
                filteredDataSource.addFilter(orFilter);
            }
            if (StringUtil.notEmpty(string2 = filterGO.getUserProperty("Filter_JavaScript"))) {
                filteredDataSource.addFilter(new JavaScriptFilter(string2));
            }
            buildContext.addDataSource(filterGO, string3, filteredDataSource);
        }
    }

    private static Filter buildFilter(FilterGO filterGO, FilterNode filterNode, When when) {
        Filter filter = null;
        try {
            if (!when.equals(When.NONE)) {
                if (when.equals(When.EQUALS)) {
                    filter = new EqualsFilter(filterNode.getName(), filterNode.getValue());
                } else if (when.equals(When.LESS_THAN)) {
                    filter = new LessThanFilter(filterNode.getName(), filterNode.getValue());
                } else if (when.equals(When.MORE_THAN)) {
                    filter = new MoreThanFilter(filterNode.getName(), filterNode.getValue());
                } else if (when.equals(When.IN_DATASET)) {
                    filter = new InDataSetFilter(filterNode.getName(), filterNode.getValue());
                } else if (when.equals(When.IN_RANGE)) {
                    filter = new InRangeFilter(filterNode.getName(), filterNode.getValue());
                } else if (when.equals(When.NULL)) {
                    filter = new NullFilter(filterNode.getName());
                } else if (when.equals(When.MATCHES)) {
                    String string = filterNode.getValue();
                    filter = new RegExpFilter(filterNode.getName(), string);
                } else if (when.equals(When.SCRIPT)) {
                    String string = filterNode.getValue();
                    filter = new JavaScriptFilter(string);
                }
            }
        }
        catch (Exception exception) {
            m_Log.error((Object)("Data error while processing Filter " + filterGO.getText()), (Throwable)exception);
        }
        return filter;
    }
}

