/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.glint.Color;
import com.elixirtech.glint.Font;
import com.elixirtech.glint.GraphicsCodes;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.IResourceManager;
import com.elixirtech.glint.Image;
import com.elixirtech.glint.Pen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GlintMerger
implements IGlint {
    private IGlint m_Next;
    private IResourceManager m_ResourceManager;
    private final Map<IGlint.PenId, IGlint.PenId> m_PenMap = new HashMap<IGlint.PenId, IGlint.PenId>();
    private final Map<IGlint.ColorId, IGlint.ColorId> m_ColorMap = new HashMap<IGlint.ColorId, IGlint.ColorId>();
    private final Map<IGlint.FontId, IGlint.FontId> m_FontMap = new HashMap<IGlint.FontId, IGlint.FontId>();
    private final Map<IGlint.ImageId, IGlint.ImageId> m_ImageMap = new HashMap<IGlint.ImageId, IGlint.ImageId>();
    private final Map<IGlint.StringId, IGlint.StringId> m_StringMap = new HashMap<IGlint.StringId, IGlint.StringId>();
    private int m_Width;
    private int m_Height;
    private int m_Orientation;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(GlintMerger.class);

    public GlintMerger() {
    }

    public GlintMerger(IGlint iGlint) {
        this.m_Next = iGlint;
    }

    public IGlint getNext() {
        return this.m_Next;
    }

    public void setNext(IGlint iGlint) {
        this.m_Next = iGlint;
    }

    @Override
    public void init(int n, int n2, int n3) {
        this.m_PenMap.clear();
        this.m_ColorMap.clear();
        this.m_ImageMap.clear();
        this.m_FontMap.clear();
        this.m_Width = n;
        this.m_Height = n2;
        this.m_Orientation = n3;
        this.m_ResourceManager = new MergeResourceManager();
    }

    @Override
    public IGlint.FontId defineFont(Font font) {
        IGlint.FontId fontId = this.m_ResourceManager.defineFont(font);
        IGlint.FontId fontId2 = this.m_Next.defineFont(font);
        this.m_FontMap.put(fontId, fontId2);
        m_Log.debug((Object)("Font map " + fontId.id + "->" + fontId2.id));
        return fontId;
    }

    @Override
    public IGlint.ColorId defineColor(Color color) {
        IGlint.ColorId colorId = this.m_ResourceManager.defineColor(color);
        IGlint.ColorId colorId2 = this.m_Next.defineColor(color);
        this.m_ColorMap.put(colorId, colorId2);
        m_Log.debug((Object)("Color map " + colorId.id + "->" + colorId2.id));
        return colorId;
    }

    @Override
    public IGlint.ImageId defineImage(Image image) {
        IGlint.ImageId imageId = this.m_ResourceManager.defineImage(image);
        IGlint.ImageId imageId2 = this.m_Next.defineImage(image);
        this.m_ImageMap.put(imageId, imageId2);
        m_Log.debug((Object)("Image map " + imageId.id + "->" + imageId2.id));
        return imageId;
    }

    @Override
    public IGlint.PenId definePen(Pen pen) {
        IGlint.PenId penId = this.m_ResourceManager.definePen(pen);
        IGlint.PenId penId2 = this.m_Next.definePen(pen);
        this.m_PenMap.put(penId, penId2);
        m_Log.debug((Object)("Pen map " + penId.id + "->" + penId2.id));
        return penId;
    }

    @Override
    public IGlint.StringId defineString() {
        IGlint.StringId stringId = this.m_ResourceManager.defineString();
        IGlint.StringId stringId2 = this.m_Next.defineString();
        this.m_StringMap.put(stringId, stringId2);
        m_Log.debug((Object)("String map " + stringId.id + "->" + stringId2.id));
        return stringId;
    }

    @Override
    public void setString(IGlint.StringId stringId, String string) {
        this.m_ResourceManager.setString(stringId, string);
        IGlint.StringId stringId2 = this.m_StringMap.get(stringId);
        this.m_Next.setString(stringId2, string);
    }

    @Override
    public Font getFont(IGlint.FontId fontId) {
        return this.m_ResourceManager.getFont(fontId);
    }

    @Override
    public Color getColor(IGlint.ColorId colorId) {
        return this.m_ResourceManager.getColor(colorId);
    }

    @Override
    public Image getImage(IGlint.ImageId imageId) {
        return this.m_ResourceManager.getImage(imageId);
    }

    @Override
    public Pen getPen(IGlint.PenId penId) {
        return this.m_ResourceManager.getPen(penId);
    }

    @Override
    public String getString(IGlint.StringId stringId) {
        return this.m_ResourceManager.getString(stringId);
    }

    @Override
    public int getWidth() {
        return this.m_Width;
    }

    @Override
    public int getHeight() {
        return this.m_Height;
    }

    @Override
    public int getOrientation() {
        return this.m_Orientation;
    }

    @Override
    public void offsetOrigin(int n, int n2) {
        this.m_Next.offsetOrigin(n, n2);
    }

    @Override
    public void setOrigin(int n, int n2) {
        this.m_Next.setOrigin(n, n2);
    }

    @Override
    public int getOriginX() {
        return this.m_Next.getOriginX();
    }

    @Override
    public int getOriginY() {
        return this.m_Next.getOriginY();
    }

    @Override
    public void setURL(String string, String string2) {
        this.m_Next.setURL(string, string2);
    }

    @Override
    public void resetURL() {
        this.m_Next.resetURL();
    }

    @Override
    public void drawLine(IGlint.PenId penId, int n, int n2, int n3, int n4) {
        this.m_Next.drawLine(this.mapPen(penId), n, n2, n3, n4);
    }

    @Override
    public void drawPolyline(IGlint.PenId penId, int[] nArray, int[] nArray2) {
        this.m_Next.drawPolyline(this.mapPen(penId), nArray, nArray2);
    }

    @Override
    public void drawRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4) {
        this.m_Next.drawRect(this.mapPen(penId), this.mapColor(colorId), n, n2, n3, n4);
    }

    @Override
    public void drawCellRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5) {
        this.m_Next.drawCellRect(this.mapPen(penId), this.mapColor(colorId), n, n2, n3, n4, n5);
    }

    @Override
    public void drawRoundRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5, int n6) {
        this.m_Next.drawRoundRect(this.mapPen(penId), this.mapColor(colorId), n, n2, n3, n4, n5, n6);
    }

    @Override
    public void drawRoundCellRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.m_Next.drawRoundCellRect(this.mapPen(penId), this.mapColor(colorId), n, n2, n3, n4, n5, n6, n7);
    }

    @Override
    public void drawEllipse(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4) {
        this.m_Next.drawEllipse(this.mapPen(penId), this.mapColor(colorId), n, n2, n3, n4);
    }

    @Override
    public void drawPolygon(IGlint.PenId penId, IGlint.ColorId colorId, int[] nArray, int[] nArray2) {
        this.m_Next.drawPolygon(this.mapPen(penId), this.mapColor(colorId), nArray, nArray2);
    }

    @Override
    public void drawImage(IGlint.ImageId imageId, int n, int n2) {
        this.m_Next.drawImage(this.mapImage(imageId), n, n2);
    }

    @Override
    public void drawScaledImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4) {
        this.m_Next.drawScaledImage(this.mapImage(imageId), n, n2, n3, n4);
    }

    @Override
    public void drawSubImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4, int n5, int n6) {
        this.m_Next.drawSubImage(this.mapImage(imageId), n, n2, n3, n4, n5, n6);
    }

    @Override
    public void drawScaledSubImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.m_Next.drawScaledSubImage(this.mapImage(imageId), n, n2, n3, n4, n5, n6, n7, n8);
    }

    @Override
    public void drawText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, String string) {
        this.m_Next.drawText(this.mapFont(fontId), this.mapColor(colorId), n, n2, n3, string);
    }

    @Override
    public void drawJustifiedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, String string) {
        this.m_Next.drawJustifiedText(this.mapFont(fontId), this.mapColor(colorId), n, n2, n3, string);
    }

    @Override
    public void drawRotatedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, String string) {
        this.m_Next.drawRotatedText(this.mapFont(fontId), this.mapColor(colorId), n, n2, n3, n4, string);
    }

    @Override
    public void drawRotatedJustifiedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, String string) {
        this.m_Next.drawRotatedJustifiedText(this.mapFont(fontId), this.mapColor(colorId), n, n2, n3, n4, string);
    }

    @Override
    public void drawRTF(int n, int n2, int n3, int n4, String string) {
        this.m_Next.drawRTF(n, n2, n3, n4, string);
    }

    @Override
    public void pushClip(int n, int n2, int n3, int n4) {
        this.m_Next.pushClip(n, n2, n3, n4);
    }

    @Override
    public void pushClip(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.m_Next.pushClip(n, n2, n3, n4, n5, n6, n7);
    }

    @Override
    public void popClip() {
        this.m_Next.popClip();
    }

    @Override
    public void flush() {
    }

    protected IGlint.PenId mapPen(IGlint.PenId penId) {
        if (penId.id == 0) {
            return penId;
        }
        IGlint.PenId penId2 = this.m_PenMap.get(penId);
        if (penId2 == null) {
            m_Log.error((Object)("No pen matches " + penId.id));
        }
        return penId2;
    }

    protected IGlint.ColorId mapColor(IGlint.ColorId colorId) {
        if (colorId.id == 0) {
            return colorId;
        }
        IGlint.ColorId colorId2 = this.m_ColorMap.get(colorId);
        if (colorId2 == null) {
            m_Log.error((Object)("No color matches " + colorId.id));
        }
        return colorId2;
    }

    protected IGlint.FontId mapFont(IGlint.FontId fontId) {
        IGlint.FontId fontId2 = this.m_FontMap.get(fontId);
        if (fontId2 == null) {
            m_Log.error((Object)("No font matches " + fontId.id));
            this.dumpFonts();
        }
        return fontId2;
    }

    protected void dumpFonts() {
        m_Log.debug((Object)"Available fonts are:");
        for (IGlint.FontId fontId : this.m_FontMap.keySet()) {
            IGlint.FontId fontId2 = this.m_FontMap.get(fontId);
            m_Log.debug((Object)(fontId.id + "->" + fontId2.id));
        }
        m_Log.debug((Object)"End of Font Map");
    }

    protected IGlint.ImageId mapImage(IGlint.ImageId imageId) {
        IGlint.ImageId imageId2 = this.m_ImageMap.get(imageId);
        if (imageId2 == null) {
            m_Log.error((Object)("No image matches " + imageId.id));
        }
        return imageId2;
    }

    private static class MergeResourceManager
    implements IResourceManager,
    GraphicsCodes {
        private Map<String, IGlint.FontId> m_FontMap = new HashMap<String, IGlint.FontId>();
        private Map<String, IGlint.ColorId> m_ColorMap = new HashMap<String, IGlint.ColorId>();
        private Map<String, IGlint.ImageId> m_ImageMap = new HashMap<String, IGlint.ImageId>();
        private Map<String, IGlint.PenId> m_PenMap = new HashMap<String, IGlint.PenId>();
        private List<Font> m_FontList = new ArrayList<Font>();
        private List<Color> m_ColorList = new ArrayList<Color>();
        private List<Image> m_ImageList = new ArrayList<Image>();
        private List<Pen> m_PenList = new ArrayList<Pen>();
        private List<String> m_StringList = new ArrayList<String>();

        public MergeResourceManager() {
            this.initConstants();
        }

        private void initConstants() {
            this.m_PenMap.put(this.getKey(Pen.NONE), new IGlint.PenId(0));
            this.m_PenList.add(Pen.NONE);
            this.m_ColorMap.put(this.getKey(Color.NONE), new IGlint.ColorId(0));
            this.m_ColorList.add(Color.NONE);
        }

        @Override
        public IGlint.FontId defineFont(Font font) {
            String string = this.getKey(font);
            IGlint.FontId fontId = this.m_FontMap.get(string);
            if (fontId == null) {
                fontId = new IGlint.FontId(this.m_FontList.size());
                this.m_FontMap.put(string, fontId);
                this.m_FontList.add(font);
            }
            return fontId;
        }

        @Override
        public IGlint.ColorId defineColor(Color color) {
            String string = this.getKey(color);
            IGlint.ColorId colorId = this.m_ColorMap.get(string);
            if (colorId == null) {
                colorId = new IGlint.ColorId(this.m_ColorList.size());
                this.m_ColorMap.put(string, colorId);
                this.m_ColorList.add(color);
            }
            return colorId;
        }

        @Override
        public IGlint.ImageId defineImage(Image image) {
            String string = this.getKey(image);
            IGlint.ImageId imageId = this.m_ImageMap.get(string);
            if (imageId == null) {
                imageId = new IGlint.ImageId(this.m_ImageList.size());
                if (string != null) {
                    this.m_ImageMap.put(string, imageId);
                }
                this.m_ImageList.add(image);
            }
            return imageId;
        }

        @Override
        public IGlint.PenId definePen(Pen pen) {
            String string = this.getKey(pen);
            IGlint.PenId penId = this.m_PenMap.get(string);
            if (penId == null) {
                penId = new IGlint.PenId(this.m_PenList.size());
                this.m_PenMap.put(string, penId);
                this.m_PenList.add(pen);
            }
            return penId;
        }

        @Override
        public IGlint.StringId defineString() {
            IGlint.StringId stringId = new IGlint.StringId(this.m_StringList.size());
            this.m_StringList.add("");
            return stringId;
        }

        @Override
        public void setString(IGlint.StringId stringId, String string) {
            this.m_StringList.set(stringId.id, string);
        }

        @Override
        public Font getFont(IGlint.FontId fontId) {
            return this.m_FontList.get(fontId.id);
        }

        @Override
        public Color getColor(IGlint.ColorId colorId) {
            return this.m_ColorList.get(colorId.id);
        }

        @Override
        public Image getImage(IGlint.ImageId imageId) {
            return this.m_ImageList.get(imageId.id);
        }

        @Override
        public Pen getPen(IGlint.PenId penId) {
            return this.m_PenList.get(penId.id);
        }

        @Override
        public String getString(IGlint.StringId stringId) {
            return this.m_StringList.get(stringId.id);
        }

        @Override
        public int getFontCount() {
            return this.m_FontList.size();
        }

        @Override
        public int getColorCount() {
            return this.m_ColorList.size();
        }

        @Override
        public int getImageCount() {
            return this.m_ImageList.size();
        }

        @Override
        public int getPenCount() {
            return this.m_PenList.size();
        }

        @Override
        public int getStringCount() {
            return this.m_StringList.size();
        }

        private String getKey(Font font) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(font.getName());
            stringBuffer.append('|');
            stringBuffer.append(font.getSize());
            stringBuffer.append('|');
            stringBuffer.append(font.getStyle());
            return stringBuffer.toString();
        }

        private String getKey(Color color) {
            if (color == Color.NONE) {
                return "None";
            }
            return Integer.toString(color.getRGB());
        }

        private String getKey(Image image) {
            return image.getId();
        }

        private String getKey(Pen pen) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(pen.getColor().getRGB());
            stringBuffer.append('|');
            stringBuffer.append(pen.getWidth());
            stringBuffer.append('|');
            stringBuffer.append(pen.getStyle());
            return stringBuffer.toString();
        }
    }
}

