/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.glint.Color;
import com.elixirtech.glint.Font;
import com.elixirtech.glint.GlintException;
import com.elixirtech.glint.GraphicsCodes;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.IResourceManager;
import com.elixirtech.glint.Image;
import com.elixirtech.glint.Pen;
import com.elixirtech.glint.ResourceManager;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class GlintOutput
implements IGlint,
GraphicsCodes {
    private static final String NULL_PEN = "Null pen";
    private static final String NULL_FILL = "Null fill";
    private static final String NULL_IMAGE = "Null image";
    private static final String NULL_FONT = "Null font";
    private static final String NULL_RGB = "Null rgb";
    private static final String NULL_TEXT = "Null text";
    protected DataOutputStream m_Out;
    protected IResourceManager m_ResourceManager;
    protected int m_Width;
    protected int m_Height;
    protected int m_Orientation;
    protected int m_OriginX;
    protected int m_OriginY;

    protected GlintOutput() {
    }

    public GlintOutput(OutputStream outputStream) {
        this.m_Out = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        this.initResourceManager();
    }

    @Override
    public void init(int n, int n2, int n3) {
        if (this.m_Orientation == 0) {
            this.m_Width = n;
            this.m_Height = n2;
            this.m_Orientation = n3;
            try {
                this.m_Out.write(MARKER.bytes());
                this.m_Out.write(VERSION.bytes());
                this.m_Out.writeInt(this.m_Width);
                this.m_Out.writeInt(this.m_Height);
                this.m_Out.write(this.m_Orientation);
            }
            catch (IOException iOException) {
                throw new GlintException("init", iOException);
            }
        }
    }

    public void initResourceManager() {
        this.m_ResourceManager = new ResourceManager(this.m_Out);
    }

    @Override
    public IGlint.FontId defineFont(Font font) {
        return this.m_ResourceManager.defineFont(font);
    }

    @Override
    public IGlint.ColorId defineColor(Color color) {
        return this.m_ResourceManager.defineColor(color);
    }

    @Override
    public IGlint.ImageId defineImage(Image image) {
        return this.m_ResourceManager.defineImage(image);
    }

    @Override
    public IGlint.PenId definePen(Pen pen) {
        return this.m_ResourceManager.definePen(pen);
    }

    @Override
    public IGlint.StringId defineString() {
        return this.m_ResourceManager.defineString();
    }

    @Override
    public void setString(IGlint.StringId stringId, String string) {
        this.m_ResourceManager.setString(stringId, string);
    }

    @Override
    public Font getFont(IGlint.FontId fontId) {
        return this.m_ResourceManager.getFont(fontId);
    }

    @Override
    public Color getColor(IGlint.ColorId colorId) {
        return this.m_ResourceManager.getColor(colorId);
    }

    @Override
    public Image getImage(IGlint.ImageId imageId) {
        return this.m_ResourceManager.getImage(imageId);
    }

    @Override
    public Pen getPen(IGlint.PenId penId) {
        return this.m_ResourceManager.getPen(penId);
    }

    @Override
    public String getString(IGlint.StringId stringId) {
        return this.m_ResourceManager.getString(stringId);
    }

    @Override
    public int getWidth() {
        return this.m_Width;
    }

    @Override
    public int getHeight() {
        return this.m_Height;
    }

    @Override
    public int getOrientation() {
        return this.m_Orientation;
    }

    @Override
    public void offsetOrigin(int n, int n2) {
        if (n != 0 || n2 != 0) {
            this.m_OriginX += n;
            this.m_OriginY += n2;
            try {
                this.m_Out.write(96);
                this.m_Out.writeInt(n);
                this.m_Out.writeInt(n2);
            }
            catch (IOException iOException) {
                throw new GlintException("offsetOrigin", iOException);
            }
        }
    }

    @Override
    public void setOrigin(int n, int n2) {
        this.m_OriginX = n;
        this.m_OriginY = n2;
        try {
            this.m_Out.write(97);
            this.m_Out.writeInt(n);
            this.m_Out.writeInt(n2);
        }
        catch (IOException iOException) {
            throw new GlintException("setOrigin", iOException);
        }
    }

    @Override
    public int getOriginX() {
        return this.m_OriginX;
    }

    @Override
    public int getOriginY() {
        return this.m_OriginY;
    }

    @Override
    public void setURL(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Null url");
        }
        try {
            if (StringUtil.isEmpty(string2)) {
                this.m_Out.write(98);
                this.m_Out.writeUTF(string);
            } else {
                this.m_Out.write(99);
                this.m_Out.writeUTF(string);
                this.m_Out.writeUTF(string2);
            }
        }
        catch (IOException iOException) {
            throw new GlintException("setURL", iOException);
        }
    }

    @Override
    public void resetURL() {
        try {
            this.m_Out.write(100);
        }
        catch (IOException iOException) {
            throw new GlintException("setURL", iOException);
        }
    }

    @Override
    public void pushClip(int n, int n2, int n3, int n4) {
        try {
            this.m_Out.write(101);
            this.m_Out.writeInt(n);
            this.m_Out.writeInt(n2);
            this.m_Out.writeInt(n3);
            this.m_Out.writeInt(n4);
        }
        catch (IOException iOException) {
            throw new GlintException("pushClip", iOException);
        }
    }

    @Override
    public void pushClip(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        try {
            this.m_Out.write(103);
            this.m_Out.writeInt(n);
            this.m_Out.writeInt(n2);
            this.m_Out.writeInt(n3);
            this.m_Out.writeInt(n4);
            this.m_Out.writeInt(n5);
            this.m_Out.writeInt(n6);
            this.m_Out.write(n7);
        }
        catch (IOException iOException) {
            throw new GlintException("pushClip", iOException);
        }
    }

    @Override
    public void popClip() {
        try {
            this.m_Out.write(102);
        }
        catch (IOException iOException) {
            throw new GlintException("popClip", iOException);
        }
    }

    @Override
    public void drawLine(IGlint.PenId penId, int n, int n2, int n3, int n4) {
        if (penId == null) {
            throw new IllegalArgumentException(NULL_PEN);
        }
        try {
            if (n == n3) {
                this.m_Out.write(2);
                this.m_Out.writeShort(penId.id);
                this.m_Out.writeInt(n);
                this.m_Out.writeInt(n2);
                this.m_Out.writeInt(n4);
            } else if (n2 == n4) {
                this.m_Out.write(1);
                this.m_Out.writeShort(penId.id);
                this.m_Out.writeInt(n);
                this.m_Out.writeInt(n2);
                this.m_Out.writeInt(n3);
            } else {
                this.m_Out.write(3);
                this.m_Out.writeShort(penId.id);
                this.m_Out.writeInt(n);
                this.m_Out.writeInt(n2);
                this.m_Out.writeInt(n3);
                this.m_Out.writeInt(n4);
            }
        }
        catch (IOException iOException) {
            throw new GlintException("drawLine", iOException);
        }
    }

    @Override
    public void drawPolyline(IGlint.PenId penId, int[] nArray, int[] nArray2) {
        if (penId == null) {
            throw new IllegalArgumentException(NULL_PEN);
        }
        try {
            this.m_Out.write(4);
            this.m_Out.writeShort(penId.id);
            this.m_Out.writeInt(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                this.m_Out.writeInt(nArray[i]);
                this.m_Out.writeInt(nArray2[i]);
            }
        }
        catch (IOException iOException) {
            throw new GlintException("drawPolyline", iOException);
        }
    }

    @Override
    public void drawRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4) {
        if (penId == null) {
            throw new IllegalArgumentException(NULL_PEN);
        }
        if (colorId == null) {
            throw new IllegalArgumentException(NULL_FILL);
        }
        try {
            this.m_Out.write(16);
            this.m_Out.writeShort(penId.id);
            this.m_Out.writeShort(colorId.id);
            this.m_Out.writeInt(n);
            this.m_Out.writeInt(n2);
            this.m_Out.writeInt(n3);
            this.m_Out.writeInt(n4);
        }
        catch (IOException iOException) {
            throw new GlintException("drawRect", iOException);
        }
    }

    @Override
    public void drawCellRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5) {
        if (penId == null) {
            throw new IllegalArgumentException(NULL_PEN);
        }
        if (colorId == null) {
            throw new IllegalArgumentException(NULL_FILL);
        }
        try {
            this.m_Out.write(17);
            this.m_Out.writeShort(penId.id);
            this.m_Out.writeShort(colorId.id);
            this.m_Out.writeInt(n);
            this.m_Out.writeInt(n2);
            this.m_Out.writeInt(n3);
            this.m_Out.writeInt(n4);
            this.m_Out.write(n5);
        }
        catch (IOException iOException) {
            throw new GlintException("drawRect", iOException);
        }
    }

    @Override
    public void drawRoundRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5, int n6) {
        if (penId == null) {
            throw new IllegalArgumentException(NULL_PEN);
        }
        if (colorId == null) {
            throw new IllegalArgumentException(NULL_FILL);
        }
        try {
            this.m_Out.write(18);
            this.m_Out.writeShort(penId.id);
            this.m_Out.writeShort(colorId.id);
            this.m_Out.writeInt(n);
            this.m_Out.writeInt(n2);
            this.m_Out.writeInt(n3);
            this.m_Out.writeInt(n4);
            this.m_Out.writeInt(n5);
            this.m_Out.writeInt(n6);
        }
        catch (IOException iOException) {
            throw new GlintException("drawRoundRect", iOException);
        }
    }

    @Override
    public void drawRoundCellRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (penId == null) {
            throw new IllegalArgumentException(NULL_PEN);
        }
        if (colorId == null) {
            throw new IllegalArgumentException(NULL_FILL);
        }
        try {
            this.m_Out.write(21);
            this.m_Out.writeShort(penId.id);
            this.m_Out.writeShort(colorId.id);
            this.m_Out.writeInt(n);
            this.m_Out.writeInt(n2);
            this.m_Out.writeInt(n3);
            this.m_Out.writeInt(n4);
            this.m_Out.writeInt(n5);
            this.m_Out.writeInt(n6);
            this.m_Out.write(n7);
        }
        catch (IOException iOException) {
            throw new GlintException("drawRoundCellRect", iOException);
        }
    }

    @Override
    public void drawEllipse(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4) {
        if (penId == null) {
            throw new IllegalArgumentException(NULL_PEN);
        }
        if (colorId == null) {
            throw new IllegalArgumentException(NULL_FILL);
        }
        try {
            this.m_Out.write(19);
            this.m_Out.writeShort(penId.id);
            this.m_Out.writeShort(colorId.id);
            this.m_Out.writeInt(n);
            this.m_Out.writeInt(n2);
            this.m_Out.writeInt(n3);
            this.m_Out.writeInt(n4);
        }
        catch (IOException iOException) {
            throw new GlintException("drawEllipse", iOException);
        }
    }

    @Override
    public void drawPolygon(IGlint.PenId penId, IGlint.ColorId colorId, int[] nArray, int[] nArray2) {
        if (penId == null) {
            throw new IllegalArgumentException(NULL_PEN);
        }
        if (colorId == null) {
            throw new IllegalArgumentException(NULL_FILL);
        }
        try {
            this.m_Out.write(20);
            this.m_Out.writeShort(penId.id);
            this.m_Out.writeShort(colorId.id);
            this.m_Out.writeInt(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                this.m_Out.writeInt(nArray[i]);
                this.m_Out.writeInt(nArray2[i]);
            }
        }
        catch (IOException iOException) {
            throw new GlintException("drawPolygon", iOException);
        }
    }

    @Override
    public void drawImage(IGlint.ImageId imageId, int n, int n2) {
        if (imageId == null) {
            throw new IllegalArgumentException(NULL_IMAGE);
        }
        try {
            this.m_Out.write(80);
            this.m_Out.writeShort(imageId.id);
            this.m_Out.writeInt(n);
            this.m_Out.writeInt(n2);
        }
        catch (IOException iOException) {
            throw new GlintException("drawImage", iOException);
        }
    }

    @Override
    public void drawScaledImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4) {
        if (imageId == null) {
            throw new IllegalArgumentException(NULL_IMAGE);
        }
        Image image = this.getImage(imageId);
        if (image.getWidth() * 20 == n3 && image.getHeight() * 20 == n4) {
            this.drawImage(imageId, n, n2);
        } else {
            try {
                this.m_Out.write(81);
                this.m_Out.writeShort(imageId.id);
                this.m_Out.writeInt(n);
                this.m_Out.writeInt(n2);
                this.m_Out.writeInt(n3);
                this.m_Out.writeInt(n4);
            }
            catch (IOException iOException) {
                throw new GlintException("drawScaledImage", iOException);
            }
        }
    }

    @Override
    public void drawSubImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4, int n5, int n6) {
        if (imageId == null) {
            throw new IllegalArgumentException(NULL_IMAGE);
        }
        try {
            this.m_Out.write(82);
            this.m_Out.writeShort(imageId.id);
            this.m_Out.writeInt(n);
            this.m_Out.writeInt(n2);
            this.m_Out.writeInt(n3);
            this.m_Out.writeInt(n4);
            this.m_Out.writeInt(n5);
            this.m_Out.writeInt(n6);
        }
        catch (IOException iOException) {
            throw new GlintException("drawSubImage", iOException);
        }
    }

    @Override
    public void drawScaledSubImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (imageId == null) {
            throw new IllegalArgumentException(NULL_IMAGE);
        }
        try {
            this.m_Out.write(83);
            this.m_Out.writeShort(imageId.id);
            this.m_Out.writeInt(n);
            this.m_Out.writeInt(n2);
            this.m_Out.writeInt(n3);
            this.m_Out.writeInt(n4);
            this.m_Out.writeInt(n5);
            this.m_Out.writeInt(n6);
            this.m_Out.writeInt(n7);
            this.m_Out.writeInt(n8);
        }
        catch (IOException iOException) {
            throw new GlintException("drawScaledSubImage", iOException);
        }
    }

    @Override
    public void drawText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, String string) {
        if (fontId == null) {
            throw new IllegalArgumentException(NULL_FONT);
        }
        if (colorId == null) {
            throw new IllegalArgumentException(NULL_RGB);
        }
        try {
            if (n3 == 1) {
                this.m_Out.write(112);
            } else if (n3 == 2) {
                this.m_Out.write(113);
            } else if (n3 == 3) {
                this.m_Out.write(114);
            } else {
                return;
            }
            this.m_Out.writeShort(fontId.id);
            this.m_Out.writeShort(colorId.id);
            this.m_Out.writeInt(n);
            this.m_Out.writeInt(n2);
            this.m_Out.writeUTF(string);
        }
        catch (IOException iOException) {
            throw new GlintException("drawText", iOException);
        }
    }

    @Override
    public void drawJustifiedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, String string) {
        if (fontId == null) {
            throw new IllegalArgumentException(NULL_FONT);
        }
        if (colorId == null) {
            throw new IllegalArgumentException(NULL_RGB);
        }
        try {
            this.m_Out.write(118);
            this.m_Out.writeShort(fontId.id);
            this.m_Out.writeShort(colorId.id);
            this.m_Out.writeInt(n);
            this.m_Out.writeInt(n2);
            this.m_Out.writeInt(n3);
            this.m_Out.writeUTF(string);
        }
        catch (IOException iOException) {
            throw new GlintException("drawText", iOException);
        }
    }

    @Override
    public void drawRotatedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, String string) {
        if (fontId == null) {
            throw new IllegalArgumentException(NULL_FONT);
        }
        if (colorId == null) {
            throw new IllegalArgumentException(NULL_RGB);
        }
        if (string == null) {
            throw new IllegalArgumentException(NULL_TEXT);
        }
        try {
            if (n3 == 1) {
                this.m_Out.write(115);
            } else if (n3 == 2) {
                this.m_Out.write(116);
            } else if (n3 == 3) {
                this.m_Out.write(117);
            } else {
                return;
            }
            this.m_Out.writeShort(fontId.id);
            this.m_Out.writeShort(colorId.id);
            this.m_Out.writeInt(n);
            this.m_Out.writeInt(n2);
            this.m_Out.writeInt(n4);
            this.m_Out.writeUTF(string);
        }
        catch (IOException iOException) {
            throw new GlintException("drawRotatedText", iOException);
        }
    }

    @Override
    public void drawRotatedJustifiedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, String string) {
        if (fontId == null) {
            throw new IllegalArgumentException(NULL_FONT);
        }
        if (colorId == null) {
            throw new IllegalArgumentException(NULL_RGB);
        }
        if (string == null) {
            throw new IllegalArgumentException(NULL_TEXT);
        }
        try {
            this.m_Out.write(119);
            this.m_Out.writeShort(fontId.id);
            this.m_Out.writeShort(colorId.id);
            this.m_Out.writeInt(n);
            this.m_Out.writeInt(n2);
            this.m_Out.writeInt(n3);
            this.m_Out.writeInt(n4);
            this.m_Out.writeUTF(string);
        }
        catch (IOException iOException) {
            throw new GlintException("drawRotatedJustifiedText", iOException);
        }
    }

    @Override
    public void drawRTF(int n, int n2, int n3, int n4, String string) {
        try {
            this.m_Out.write(120);
            this.m_Out.writeInt(n);
            this.m_Out.writeInt(n2);
            this.m_Out.writeInt(n3);
            this.m_Out.writeInt(n4);
            this.m_Out.writeUTF(string);
        }
        catch (IOException iOException) {
            throw new GlintException("drawRTF", iOException);
        }
    }

    @Override
    public void flush() {
        try {
            this.m_Out.flush();
        }
        catch (IOException iOException) {
            throw new GlintException("flush", iOException);
        }
    }
}

