/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint;

import com.elixirtech.glint.Color;

public class Pen {
    public static final byte STYLE_NONE = 0;
    public static final byte STYLE_SOLID = 1;
    public static final byte STYLE_DASHED = 2;
    public static final byte STYLE_DOTTED = 3;
    public static final byte STYLE_DOUBLE = 4;
    public static final byte STYLE_GROOVE = 5;
    public static final byte STYLE_RIDGE = 6;
    public static final byte STYLE_INSET = 7;
    public static final byte STYLE_OUTSET = 8;
    public static final byte STYLE_DOTDASH = 9;
    public static final byte STYLE_DOTDOTDASH = 10;
    public static final byte STYLE_WAVE = 11;
    public static final Pen NONE = new Pen(Color.NONE, 0, 0);
    private final Color m_Color;
    private final short m_Width;
    private final byte m_Style;

    public static Pen newInstance(Color color, int n) {
        return Pen.newInstance(color, n, 1);
    }

    public static Pen newInstance(Color color, int n, int n2) {
        if (color == Color.NONE || n2 == 0) {
            return NONE;
        }
        return new Pen(color, n, n2);
    }

    protected Pen(Color color, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative width: " + n);
        }
        if (n > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Width too large: " + n);
        }
        this.m_Color = color;
        this.m_Width = (short)n;
        this.m_Style = (byte)n2;
    }

    public Color getColor() {
        return this.m_Color;
    }

    public short getWidth() {
        return this.m_Width;
    }

    public byte getStyle() {
        return this.m_Style;
    }
}

