/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint;

import com.elixirtech.glint.GlintException;
import com.elixirtech.report2.print.PrintAttribute;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;

public class PrintAttributes {
    static final byte[] MARKER = new byte[]{82, 69, 78, 68};
    static final byte[] VERSION = new byte[]{0, 1, 0, 0};
    private Map<String, String> m_Attributes = new HashMap<String, String>();

    public static PrintAttributes read(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = null;
        dataInputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        for (int i = 0; i < MARKER.length; ++i) {
            if (dataInputStream.read() == MARKER[i]) continue;
            throw new GlintException("Error at marker " + i);
        }
        byte[] byArray = new byte[VERSION.length];
        dataInputStream.readFully(byArray);
        if (byArray[2] > VERSION[2]) {
            throw new GlintException("Unsupported version [" + byArray[0] + byArray[1] + "." + byArray[2] + byArray[3]);
        }
        int n = dataInputStream.readInt();
        PrintAttributes printAttributes = new PrintAttributes();
        for (int i = 0; i < n; ++i) {
            String string = dataInputStream.readUTF();
            String string2 = dataInputStream.readUTF();
            printAttributes.put(string, string2);
        }
        return printAttributes;
    }

    public static void write(PrintAttributes printAttributes, OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = null;
        dataOutputStream = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        dataOutputStream.write(MARKER);
        dataOutputStream.write(VERSION);
        dataOutputStream.writeInt(printAttributes.getAttributeCount());
        Iterator<Map.Entry<String, String>> iterator = printAttributes.getAttributeIterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            dataOutputStream.writeUTF(entry.getKey());
            dataOutputStream.writeUTF(entry.getValue());
        }
        dataOutputStream.flush();
    }

    public int getAttributeCount() {
        return this.m_Attributes.size();
    }

    public void put(String string, String string2) {
        this.m_Attributes.put(string, string2);
    }

    public String get(String string) {
        return this.m_Attributes.get(string);
    }

    public Iterator<Map.Entry<String, String>> getAttributeIterator() {
        return this.m_Attributes.entrySet().iterator();
    }

    public PrintRequestAttributeSet toPrintRequestAttributeSet() {
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        Iterator<Map.Entry<String, String>> iterator = this.getAttributeIterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            PrintAttribute printAttribute = PrintAttribute.create(entry.getKey(), entry.getValue());
            if (printAttribute == null) continue;
            printAttribute.buildAttributeSet(hashPrintRequestAttributeSet);
        }
        return hashPrintRequestAttributeSet;
    }
}

