/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint;

import com.elixirtech.glint.GlintException;
import com.elixirtech.glint.TOC;
import com.elixirtech.glint.TickBuilder;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class TickReader {
    public static TOC read(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = null;
        dataInputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        for (int i = 0; i < TickBuilder.MARKER.length; ++i) {
            if (dataInputStream.read() == TickBuilder.MARKER[i]) continue;
            throw new GlintException("Error at marker " + i);
        }
        byte[] byArray = new byte[TickBuilder.VERSION.length];
        dataInputStream.readFully(byArray);
        if (byArray[2] > TickBuilder.VERSION[2]) {
            throw new GlintException("Unsupported version [" + byArray[0] + byArray[1] + "." + byArray[2] + byArray[3]);
        }
        TOC tOC = new TOC();
        tOC.read(dataInputStream);
        return tOC;
    }

    public static TreeModel buildTreeModel(TOC tOC) throws IOException {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(tOC);
        TickReader.build(tOC, defaultMutableTreeNode);
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    private static void build(TOC tOC, DefaultMutableTreeNode defaultMutableTreeNode) {
        Iterator<TOC> iterator = tOC.getChildIterator();
        while (iterator.hasNext()) {
            TOC tOC2 = iterator.next();
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(tOC2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            TickReader.build(tOC2, defaultMutableTreeNode2);
        }
    }
}

