/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint.g2d;

import com.elixirtech.glint.g2d.URLMap;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class GLListener
implements MouseListener,
MouseMotionListener {
    private URLMap m_URLMap;
    private Point m_DownPt;
    private final List<HyperlinkListener> m_Listeners = new ArrayList<HyperlinkListener>();

    public void setURLMap(URLMap uRLMap) {
        this.m_URLMap = uRLMap;
    }

    public void addHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.m_Listeners.add(hyperlinkListener);
    }

    public void removeHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.m_Listeners.remove(hyperlinkListener);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.m_DownPt = mouseEvent.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.m_DownPt != null) {
            Point point = mouseEvent.getPoint();
            if (this.withinRange(this.m_DownPt, point)) {
                try {
                    this.processClick(point);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            this.m_DownPt = null;
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    protected boolean withinRange(Point point, Point point2) {
        return Math.abs(point.x - point2.x) < 5 && Math.abs(point.y - point2.y) < 5;
    }

    protected void processClick(Point point) throws MalformedURLException {
        URLMap.URLStruct uRLStruct;
        if (this.m_URLMap != null && (uRLStruct = this.m_URLMap.getURLStruct(point)) != null) {
            HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(this, HyperlinkEvent.EventType.ACTIVATED, new URL(uRLStruct.getURL()), uRLStruct.getDescription());
            this.notifyClick(hyperlinkEvent);
        }
    }

    private void notifyClick(HyperlinkEvent hyperlinkEvent) {
        for (HyperlinkListener hyperlinkListener : this.m_Listeners) {
            hyperlinkListener.hyperlinkUpdate(hyperlinkEvent);
        }
    }
}

