/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint.midp;

import com.elixirtech.glint.Color;
import com.elixirtech.glint.EyeReader;
import com.elixirtech.glint.EyeWriter;
import com.elixirtech.glint.Font;
import com.elixirtech.glint.GlintException;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GlintIndexer {
    private static List<Record> m_Records = new ArrayList<Record>();
    private static IGlint.FontId m_LinkFont;
    private static int m_Y;

    public static void main(String[] stringArray) throws Exception {
        Object object;
        File file;
        if (stringArray.length != 3) {
            System.out.println("Usage: GlintIndexer hostpath glintdir index.glint");
            System.exit(-1);
        }
        if (!stringArray[0].endsWith("/")) {
            stringArray[0] = stringArray[0] + "/";
        }
        if ((file = new File(stringArray[2])).exists()) {
            file.delete();
        }
        System.out.println("Reading " + stringArray[1]);
        File[] fileArray = new File(stringArray[1]).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].getName().endsWith(".glint")) continue;
            try {
                object = EyeReader.getCaption(fileArray[i]);
                if (object == null) continue;
                System.out.println(fileArray[i].getName() + " : Eye file caption=" + (String)object);
                m_Records.add(new Record((String)object, stringArray[0] + fileArray[i].getName()));
                continue;
            }
            catch (GlintException glintException) {
                System.out.println(fileArray[i].getName() + " : Glint file");
                m_Records.add(new Record(fileArray[i].getName(), stringArray[0] + fileArray[i].getName()));
                continue;
            }
            catch (IOException iOException) {
                System.out.println("Exception processing " + fileArray[i].getName() + " : " + String.valueOf(iOException));
            }
        }
        Collections.sort(m_Records);
        System.out.println("Writing " + String.valueOf(file));
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        object = new EyeWriter("Index", fileOutputStream, false);
        IGlint iGlint = ((EyeWriter)object).newPage();
        iGlint.init(95, 30 + m_Records.size() * 15, 1);
        m_LinkFont = iGlint.defineFont(Font.newInstance("Serif", 4, 200));
        iGlint.drawRect(new IGlint.PenId(0), iGlint.defineColor(Color.WHITE), 0, 0, 90, 100);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL uRL = classLoader.getResource("com/elixirtech/glint/midp/ElixirReport.png");
        IGlint.ImageId imageId = iGlint.defineImage(Image.getInstance(uRL));
        iGlint.drawImage(imageId, 0, 0);
        m_Y = 30;
        for (Record record : m_Records) {
            GlintIndexer.index(iGlint, record.caption, record.url);
        }
        iGlint.flush();
        ((EyeWriter)object).close();
        fileOutputStream.close();
    }

    private static void index(IGlint iGlint, String string, String string2) throws Exception {
        iGlint.setURL(string2, string);
        iGlint.drawText(m_LinkFont, iGlint.defineColor(Color.BLACK), 10, m_Y, 1, string);
        iGlint.resetURL();
        m_Y += 14;
    }

    private static class Record
    implements Comparable<Record> {
        public String caption;
        public String url;

        public Record(String string, String string2) {
            this.caption = string;
            this.url = string2;
        }

        @Override
        public int compareTo(Record record) {
            return this.caption.compareTo(record.caption);
        }

        public boolean equals(Object object) {
            if (object instanceof Record) {
                Record record = (Record)object;
                return this.caption.equals(record.caption) && this.url.equals(record.url);
            }
            return false;
        }

        public int hashCode() {
            return this.caption.hashCode() ^ this.url.hashCode();
        }
    }
}

