/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint.splitter;

import com.elixirtech.glint.EyeReader;
import com.elixirtech.glint.EyeWriter;
import com.elixirtech.glint.IEye;
import com.elixirtech.glint.TOC;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class GlintSplitter {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.err.println("Usage: GlintSplitter -level # -out dir in1.glint in2.glint ...");
            System.err.println("level defaults to 1 and outdir defaults to the current directory");
            System.exit(-1);
        }
        int n = 1;
        File file = new File(".");
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < stringArray.length; ++i) {
            if ("-level".equals(stringArray[i])) {
                n = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if ("-out".equals(stringArray[i])) {
                file = new File(stringArray[++i]);
                continue;
            }
            if (stringArray[i].startsWith("-")) {
                System.err.println("Unknown option: " + stringArray[i]);
                continue;
            }
            arrayList.add(new File(stringArray[i]));
        }
        Iterator iterator = arrayList.iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                File file2 = (File)iterator.next();
                System.out.println("Splitting " + file2.getName());
                GlintSplitter.splitToDir(file2, n, file);
            }
            System.out.println("Done");
        } else {
            System.out.println("No glints specified");
        }
    }

    private GlintSplitter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void split(IEye iEye, int n, Callback callback) throws IOException {
        TOC tOC = iEye.getTick();
        TOC[] tOCArray = GlintSplitter.getRanges(tOC, n);
        for (int i = 0; i < tOCArray.length; ++i) {
            OutputStream outputStream = callback.getOutputStream(tOCArray[i]);
            if (outputStream == null) continue;
            try {
                int n2 = iEye.getPageCount() + 1;
                if (i < tOCArray.length - 1) {
                    n2 = tOCArray[i + 1].getPageNo();
                }
                GlintSplitter.write(iEye, tOCArray[i], n2, outputStream);
                continue;
            }
            finally {
                outputStream.close();
            }
        }
    }

    public static void splitToDir(File file, int n, File file2) throws IOException {
        IEye iEye = GlintSplitter.getEye(file);
        TOC tOC = iEye.getTick();
        TOC[] tOCArray = GlintSplitter.getRanges(tOC, n);
        for (int i = 0; i < tOCArray.length; ++i) {
            File file3 = new File(file2, GlintSplitter.getFilename(file, tOCArray[i]));
            file3.getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            int n2 = iEye.getPageCount() + 1;
            if (i < tOCArray.length - 1) {
                n2 = tOCArray[i + 1].getPageNo();
            }
            GlintSplitter.write(iEye, tOCArray[i], n2, fileOutputStream);
            fileOutputStream.close();
        }
    }

    public static void splitToZip(File file, int n, OutputStream outputStream) throws IOException {
        IEye iEye = GlintSplitter.getEye(file);
        TOC tOC = iEye.getTick();
        TOC[] tOCArray = GlintSplitter.getRanges(tOC, n);
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        for (int i = 0; i < tOCArray.length; ++i) {
            String string = GlintSplitter.getFilename(file, tOCArray[i]);
            string = string.replace('\\', '/');
            ZipEntry zipEntry = new ZipEntry(string);
            zipOutputStream.putNextEntry(zipEntry);
            int n2 = iEye.getPageCount() + 1;
            if (i < tOCArray.length - 1) {
                n2 = tOCArray[i + 1].getPageNo();
            }
            GlintSplitter.write(iEye, tOCArray[i], n2, zipOutputStream);
            zipOutputStream.closeEntry();
        }
        zipOutputStream.flush();
    }

    private static IEye getEye(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            EyeReader eyeReader = new EyeReader(fileInputStream);
            return eyeReader;
        }
    }

    private static String getFilename(File file, TOC tOC) {
        String string = file.getName();
        if (string.endsWith(".glint")) {
            string = string.substring(0, string.length() - 6);
        }
        return string + "-" + GlintSplitter.safe(tOC.getTitle()) + ".glint";
    }

    private static String safe(String string) {
        String string2 = string;
        string2 = string2.replace(':', '_');
        string2 = string2.replace(';', '_');
        if (File.separatorChar != '/') {
            string2 = string2.replace('/', File.separatorChar);
        }
        if (File.separatorChar != '\\') {
            string2 = string2.replace('\\', File.separatorChar);
        }
        return string2;
    }

    private static void write(IEye iEye, TOC tOC, int n, OutputStream outputStream) throws IOException {
        EyeWriter eyeWriter = new EyeWriter(tOC.getTitle(), outputStream, true);
        eyeWriter.setSize(new Dimension(iEye.getWidth(), iEye.getHeight()));
        eyeWriter.setResources(iEye.getResources(0));
        for (int i = tOC.getPageNo(); i < n; ++i) {
            eyeWriter.addGlint(iEye.getPage(i));
        }
        eyeWriter.close();
    }

    private static TOC[] getRanges(TOC tOC, int n) {
        ArrayList<TOC> arrayList = new ArrayList<TOC>();
        GlintSplitter.buildTOCs(tOC, n, arrayList);
        TOC[] tOCArray = new TOC[arrayList.size()];
        arrayList.toArray(tOCArray);
        return tOCArray;
    }

    private static void buildTOCs(TOC tOC, int n, List<TOC> list) {
        if (n == 0) {
            list.add(tOC);
        } else {
            int n2 = n - 1;
            Iterator<TOC> iterator = tOC.getChildIterator();
            while (iterator.hasNext()) {
                GlintSplitter.buildTOCs(iterator.next(), n2, list);
            }
        }
    }

    public static interface Callback {
        public OutputStream getOutputStream(TOC var1) throws IOException;
    }
}

