/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.graphics.font;

import com.elixirtech.graphics.GString;
import com.elixirtech.graphics.Orientation;
import com.elixirtech.graphics.font.FontBox;
import com.elixirtech.graphics.font.IFontMeasurer;
import com.elixirtech.graphics.font.IFontMeasurerFactory;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TextLine {
    private GString m_GString;
    private IFontMeasurerFactory m_FontMeasurerFactory;
    private List<FontBox> m_FontBoxes = new ArrayList<FontBox>();
    private boolean m_IsDirty;
    private int m_Y;
    private int m_Width;
    private int m_Height;
    private int m_Baseline;

    public TextLine(GString gString) {
        this.m_GString = gString;
        this.m_FontMeasurerFactory = this.m_GString.getFontMeasurerFactory();
    }

    public Iterator<FontBox> getBoxes() {
        if (this.m_IsDirty) {
            this.calc();
        }
        return this.m_FontBoxes.iterator();
    }

    public void addFirst(FontBox fontBox) {
        fontBox.setLine(this);
        if (this.m_FontBoxes.size() > 0) {
            FontBox fontBox2 = this.m_FontBoxes.get(0);
            if (fontBox.canMerge(fontBox2)) {
                IFontMeasurer iFontMeasurer = this.m_FontMeasurerFactory.getInstance(fontBox.getFont());
                this.m_FontBoxes.set(0, fontBox.merge(fontBox2, iFontMeasurer));
            } else {
                this.m_FontBoxes.add(0, fontBox);
            }
        } else {
            this.m_FontBoxes.add(0, fontBox);
        }
        this.m_IsDirty = true;
    }

    public void addFirst(List<FontBox> list) {
        int n = list.size();
        if (n > 0) {
            this.addFirst(list.get(n - 1));
        }
        for (int i = 0; i < n - 1; ++i) {
            FontBox fontBox = list.get(i);
            fontBox.setLine(this);
            this.m_FontBoxes.add(i, fontBox);
        }
        this.m_IsDirty = true;
    }

    public void addLast(FontBox fontBox) {
        fontBox.setLine(this);
        if (this.m_FontBoxes.size() > 0) {
            int n = this.m_FontBoxes.size() - 1;
            FontBox fontBox2 = this.m_FontBoxes.get(n);
            if (fontBox2.canMerge(fontBox)) {
                IFontMeasurer iFontMeasurer = this.m_FontMeasurerFactory.getInstance(fontBox.getFont());
                this.m_FontBoxes.set(0, fontBox2.merge(fontBox, iFontMeasurer));
            } else {
                this.m_FontBoxes.add(fontBox);
            }
        } else {
            this.m_FontBoxes.add(fontBox);
        }
        this.m_IsDirty = true;
    }

    public void addLast(List<FontBox> list) {
        Iterator<FontBox> iterator = list.iterator();
        if (iterator.hasNext()) {
            this.addLast(iterator.next());
        }
        while (iterator.hasNext()) {
            FontBox fontBox = iterator.next();
            fontBox.setLine(this);
            this.m_FontBoxes.add(fontBox);
        }
        this.m_IsDirty = true;
    }

    public int getWidth() {
        if (this.m_IsDirty) {
            this.calc();
        }
        return this.m_Width;
    }

    public int getHeight() {
        if (this.m_IsDirty) {
            this.calc();
        }
        return this.m_Height;
    }

    public int getY() {
        return this.m_Y;
    }

    public int getBaseline() {
        return this.m_Baseline;
    }

    public void setY(int n) {
        this.m_Y = n;
        for (FontBox fontBox : this.m_FontBoxes) {
            Rectangle rectangle = fontBox.getRectangle();
            rectangle.y = this.m_Y;
        }
    }

    public Orientation getBaselineOrientation() {
        return this.m_GString.getBaselineOrientation();
    }

    public Orientation getGlyphOrientation() {
        return this.m_GString.getGlyphOrientation();
    }

    public List<FontBox> split(int n) {
        Object object;
        FontBox fontBox;
        ArrayList<FontBox> arrayList = new ArrayList<FontBox>();
        Iterator<FontBox> iterator = this.m_FontBoxes.iterator();
        int n2 = -1;
        while (iterator.hasNext()) {
            fontBox = iterator.next();
            if (n2 < 0) {
                object = fontBox.getRectangle();
                if (((Rectangle)object).x > n || ((Rectangle)object).x + ((Rectangle)object).width <= n) continue;
                n2 = n - ((Rectangle)object).x;
                arrayList.add(fontBox);
                continue;
            }
            arrayList.add(fontBox);
        }
        this.m_FontBoxes.removeAll(arrayList);
        if (n2 > 0) {
            boolean bl;
            fontBox = (FontBox)arrayList.remove(0);
            FontBox[] fontBoxArray = fontBox.split(n2, (IFontMeasurer)(object = this.m_FontMeasurerFactory.getInstance(fontBox.getFont())), bl = this.m_FontBoxes.size() > 0);
            if (fontBoxArray[0] != null) {
                this.addLast(fontBoxArray[0]);
            }
            if (fontBoxArray[1] != null) {
                arrayList.add(0, fontBoxArray[1]);
            }
        }
        this.m_IsDirty = true;
        return arrayList;
    }

    protected boolean isFirst(FontBox fontBox) {
        if (this.m_FontBoxes.size() > 0) {
            return this.m_FontBoxes.get(0) == fontBox;
        }
        return false;
    }

    protected boolean isLast(FontBox fontBox) {
        int n = this.m_FontBoxes.size();
        if (n > 0) {
            return this.m_FontBoxes.get(n - 1) == fontBox;
        }
        return false;
    }

    protected void calc() {
        this.m_IsDirty = false;
        this.m_Width = 0;
        this.m_Height = 0;
        this.m_Baseline = 0;
        for (FontBox fontBox : this.m_FontBoxes) {
            Rectangle rectangle = fontBox.getRectangle();
            rectangle.x = this.m_Width;
            this.m_Width += rectangle.width;
            this.m_Height = Math.max(this.m_Height, rectangle.height);
            IFontMeasurer iFontMeasurer = this.m_FontMeasurerFactory.getInstance(fontBox.getFont());
            this.m_Baseline = Math.max(this.m_Baseline, (int)iFontMeasurer.getAscent());
        }
    }
}

