/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.graphics.grid;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.graphics.GlyphOrientation;
import com.elixirtech.graphics.GraphicsConstants;
import com.elixirtech.graphics.WritingMode;
import com.elixirtech.graphics.font.IFontMeasurer;
import com.elixirtech.graphics.grid.GridRenderContext;
import com.elixirtech.graphics.grid.Strip;
import com.elixirtech.graphics.grid.StripBuilder;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.util.CharUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.GeneralPath;

public class GGrid {
    public static final int GRID_MODE_IDEOGRAPH = 1;
    public static final int GRID_MODE_ALL = 2;
    protected Rectangle m_Rectangle;
    protected Dimension m_BoxSize;
    protected Font m_Font;
    protected Color m_FontColor;
    protected boolean m_FontUnderline;
    protected boolean m_FontStrikethrough;
    protected WritingMode m_WritingMode;
    protected int m_GridMode;
    protected GlyphOrientation m_GlyphOrientation;
    protected Color m_ConstructionColor;
    protected String m_String;
    protected IFontMeasurer m_FontMeasurer;
    protected int m_CharacterOffsetX;
    protected int m_CharacterOffsetY;
    protected boolean m_BoxTop;
    protected boolean m_BoxSides;
    protected boolean m_BoxBottom;
    protected int m_BoxHeight;
    protected Color m_BoxColor;
    protected int m_BoxesAcross;
    protected int m_BoxesDown;
    protected int m_BoxCount;
    protected int m_Left;
    protected int m_Top;
    protected int m_Width;
    protected int m_Height;
    protected int m_Right;
    protected int m_Bottom;
    protected int m_XExtra;
    protected int m_YExtra;
    protected static final double NINETY_DEGREES = Math.toRadians(90.0);

    public void setRectangle(Rectangle rectangle) {
        this.m_Rectangle = rectangle;
    }

    public void setBoxSize(Dimension dimension) {
        this.m_BoxSize = dimension;
    }

    public void setGlyphOrientation(GlyphOrientation glyphOrientation) {
        this.m_GlyphOrientation = glyphOrientation;
    }

    public void setWritingMode(WritingMode writingMode) {
        this.m_WritingMode = writingMode;
    }

    public void setFont(Font font, IFontMeasurer iFontMeasurer) {
        this.m_Font = font;
        this.m_FontMeasurer = iFontMeasurer;
    }

    public void setFontColor(Color color) {
        this.m_FontColor = color;
    }

    public void setFontUnderline(boolean bl) {
        this.m_FontUnderline = bl;
    }

    public void setFontStrikethrough(boolean bl) {
        this.m_FontStrikethrough = bl;
    }

    public void setGridMode(int n) {
        this.m_GridMode = n;
    }

    public void setString(String string) {
        this.m_String = string;
    }

    public void setConstructionColor(Color color) {
        this.m_ConstructionColor = color;
    }

    public void setCharacterOffset(int n, int n2) {
        this.m_CharacterOffsetX = n;
        this.m_CharacterOffsetY = n2;
    }

    public void setBoxDrawing(Color color, boolean bl, boolean bl2, boolean bl3, int n) {
        this.m_BoxColor = color;
        this.m_BoxTop = bl;
        this.m_BoxSides = bl2;
        this.m_BoxBottom = bl3;
        this.m_BoxHeight = n;
    }

    public void draw(Graphics2D graphics2D) {
        GridRenderContext gridRenderContext = new GridRenderContext(graphics2D);
        this.calculate();
        this.drawConstructionLines(gridRenderContext);
        this.drawBoxLines(gridRenderContext);
        if (this.m_FontColor == StandardColor.NONE) {
            return;
        }
        graphics2D.setFont(this.m_Font);
        graphics2D.setColor(this.m_FontColor);
        if (this.m_WritingMode == WritingMode.LR_TB) {
            this.renderBoxesLRTB(gridRenderContext);
        } else if (this.m_WritingMode == WritingMode.RL_TB) {
            this.renderBoxesRLTB(gridRenderContext);
        } else if (this.m_WritingMode == WritingMode.TB_RL) {
            this.renderBoxesTBRL(gridRenderContext);
        } else if (this.m_WritingMode == WritingMode.TB_LR) {
            this.renderBoxesTBLR(gridRenderContext);
        }
    }

    public int getXOffset() {
        return this.m_XExtra;
    }

    public int getYOffset() {
        return this.m_YExtra;
    }

    public int getBoxRows() {
        return this.m_BoxesDown;
    }

    public int getBoxColumns() {
        return this.m_BoxesAcross;
    }

    public int getBoxCount() {
        return this.m_BoxCount;
    }

    public Dimension getBoxSize() {
        return this.m_BoxSize;
    }

    public String getText() {
        return this.m_String;
    }

    public Strip[] buildStrips() {
        return StripBuilder.buildStrips(this.m_String, this.m_GridMode, this.m_WritingMode, this.m_GlyphOrientation);
    }

    public IFontMeasurer getFontMeasurer() {
        return this.m_FontMeasurer;
    }

    public void calculate() {
        if (this.m_BoxSize.width <= 0) {
            this.m_BoxSize.width = this.m_Rectangle.width;
        }
        if (this.m_BoxSize.height <= 0) {
            this.m_BoxSize.height = this.m_Rectangle.height;
        }
        this.m_BoxesAcross = this.m_Rectangle.width / this.m_BoxSize.width;
        this.m_Width = this.m_BoxesAcross * this.m_BoxSize.width;
        this.m_XExtra = this.m_Rectangle.width - this.m_Width;
        this.m_BoxesDown = this.m_Rectangle.height / this.m_BoxSize.height;
        this.m_BoxCount = this.m_BoxesAcross * this.m_BoxesDown;
        this.m_Height = this.m_BoxesDown * this.m_BoxSize.height;
        this.m_YExtra = this.m_Rectangle.height - this.m_Height;
        this.m_Left = this.m_Rectangle.x + this.m_XExtra / 2;
        this.m_Top = this.m_Rectangle.y + this.m_YExtra / 2;
        this.m_Right = this.m_Left + this.m_Width;
        this.m_Bottom = this.m_Top + this.m_Height;
    }

    protected void drawConstructionLines(GridRenderContext gridRenderContext) {
        if (this.m_ConstructionColor != null && this.m_ConstructionColor != StandardColor.NONE) {
            int n;
            Graphics2D graphics2D = gridRenderContext.getGraphics();
            graphics2D.setColor(this.m_ConstructionColor);
            graphics2D.setStroke(GraphicsConstants.THIN_LINE);
            for (n = this.m_Left; n <= this.m_Right; n += this.m_BoxSize.width) {
                graphics2D.drawLine(n, this.m_Top, n, this.m_Bottom);
            }
            for (n = this.m_Top; n <= this.m_Bottom; n += this.m_BoxSize.height) {
                graphics2D.drawLine(this.m_Left, n, this.m_Right, n);
            }
        }
    }

    protected void drawBoxLines(GridRenderContext gridRenderContext) {
        block11: {
            int n;
            int n2;
            int n3;
            if (this.m_BoxColor == null) break block11;
            Graphics2D graphics2D = gridRenderContext.getGraphics();
            graphics2D.setColor(this.m_BoxColor);
            graphics2D.setStroke(new BasicStroke(20.0f));
            if (this.m_BoxTop || this.m_BoxBottom) {
                n3 = this.m_Top;
                n2 = this.m_Bottom;
                if (!this.m_BoxTop) {
                    n3 += this.m_BoxSize.height;
                } else if (!this.m_BoxBottom) {
                    n2 -= this.m_BoxSize.height;
                }
                for (n = n3; n <= n2; n += this.m_BoxSize.height) {
                    graphics2D.drawLine(this.m_Left, n, this.m_Right, n);
                }
            }
            if (this.m_BoxSides && this.m_BoxHeight > 0) {
                if (this.m_BoxHeight >= 100) {
                    for (n3 = this.m_Left; n3 <= this.m_Right; n3 += this.m_BoxSize.width) {
                        graphics2D.drawLine(n3, this.m_Top, n3, this.m_Bottom);
                    }
                } else {
                    n3 = this.m_BoxHeight * this.m_BoxSize.height / 100;
                    for (n2 = this.m_Top + this.m_BoxSize.height; n2 <= this.m_Bottom; n2 += this.m_BoxSize.height) {
                        n = n2 - n3;
                        for (int i = this.m_Left; i <= this.m_Right; i += this.m_BoxSize.width) {
                            graphics2D.drawLine(i, n, i, n2);
                        }
                    }
                }
            }
        }
    }

    protected void renderBoxesLRTB(GridRenderContext gridRenderContext) {
        Strip[] stripArray = this.buildStrips();
        int n = 0;
        for (int i = 0; i < stripArray.length && n < this.m_BoxCount; ++i) {
            Point point;
            String string = stripArray[i].getString();
            float f = this.m_FontMeasurer.getWidth(string);
            int n2 = (int)(f / (float)this.m_BoxSize.width) + 1;
            if (n2 == 1) {
                point = this.getBox(n);
                this.adjustForBoxCenter(point);
                this.drawCenteredString(gridRenderContext, point, string, 0.0);
                ++n;
                continue;
            }
            point = this.getBox(n);
            if (point.x + n2 < this.m_BoxesAcross) {
                this.adjustForBoxCenter(point);
                point.x += (n2 - 1) * this.m_BoxSize.width / 2;
                this.drawCenteredString(gridRenderContext, point, string, 0.0);
                n += n2;
                continue;
            }
            int n3 = this.m_BoxesAcross - point.x;
            int n4 = n3 * this.m_BoxSize.width;
            String[] stringArray = this.breakString(stripArray[i], n4);
            this.adjustForBoxCenter(point);
            point.x -= this.m_BoxSize.width / 2;
            point.x += n4 / 2;
            this.drawCenteredString(gridRenderContext, point, stringArray[0], 0.0);
            n += n3;
            stripArray[i] = new Strip(stringArray[1], stripArray[i].getType());
            --i;
        }
    }

    protected void renderBoxesRLTB(GridRenderContext gridRenderContext) {
        Strip[] stripArray = this.buildStrips();
        int n = 0;
        for (int i = 0; i < stripArray.length && n < this.m_BoxCount; ++i) {
            Point point;
            String string = stripArray[i].getString();
            int n2 = (int)this.m_FontMeasurer.getWidth(string);
            int n3 = 1 + n2 / this.m_BoxSize.width;
            if (n3 == 1) {
                point = this.getBox(n);
                this.adjustForBoxCenter(point);
                this.drawCenteredString(gridRenderContext, point, string, 0.0);
                ++n;
                continue;
            }
            point = this.getBox(n);
            if (point.x - n3 >= 0) {
                this.adjustForBoxCenter(point);
                point.x += this.m_BoxSize.width / 2;
                point.x -= n3 * this.m_BoxSize.width / 2;
                this.drawCenteredString(gridRenderContext, point, string, 0.0);
                n += n3;
                continue;
            }
            int n4 = point.x + 1;
            int n5 = n4 * this.m_BoxSize.width;
            String[] stringArray = this.breakString(stripArray[i], n5);
            this.adjustForBoxCenter(point);
            point.x += this.m_BoxSize.width / 2;
            point.x -= n5 / 2;
            this.drawCenteredString(gridRenderContext, point, stringArray[0], 0.0);
            n += n4;
            stripArray[i] = new Strip(stringArray[1], stripArray[i].getType());
            --i;
        }
    }

    protected void renderBoxesTBRL(GridRenderContext gridRenderContext) {
        Strip[] stripArray = this.buildStrips();
        int n = 0;
        for (int i = 0; i < stripArray.length && n < this.m_BoxCount; ++i) {
            Point point;
            int n2;
            String string = stripArray[i].getString();
            if (string.length() == 0) {
                ++n;
                continue;
            }
            int n3 = (int)this.m_FontMeasurer.getWidth(string);
            GlyphOrientation glyphOrientation = this.m_GlyphOrientation;
            if (glyphOrientation == GlyphOrientation.AUTO) {
                switch (stripArray[i].getType()) {
                    case 1: {
                        glyphOrientation = GlyphOrientation.INLINE;
                        break;
                    }
                    case 2: {
                        glyphOrientation = GlyphOrientation.UPRIGHT;
                        break;
                    }
                    case 3: {
                        glyphOrientation = GlyphOrientation.INLINE;
                        break;
                    }
                }
            }
            int n4 = n2 = glyphOrientation == GlyphOrientation.UPRIGHT ? 1 : 1 + n3 / this.m_BoxSize.height;
            if (n2 == 1) {
                point = this.getBox(n);
                this.adjustForBoxCenter(point);
                if (glyphOrientation == GlyphOrientation.INLINE) {
                    this.drawCenteredString(gridRenderContext, point, string, NINETY_DEGREES);
                } else if (glyphOrientation == GlyphOrientation.UPRIGHT) {
                    this.drawCenteredString(gridRenderContext, point, string, 0.0);
                }
                ++n;
                continue;
            }
            point = this.getBox(n);
            if (point.y + n2 < this.m_BoxesDown) {
                this.adjustForBoxCenter(point);
                point.y += (n2 - 1) * this.m_BoxSize.height / 2;
                this.drawCenteredString(gridRenderContext, point, string, NINETY_DEGREES);
                n += n2;
                continue;
            }
            int n5 = this.m_BoxesDown - point.y;
            int n6 = n5 * this.m_BoxSize.height;
            String[] stringArray = this.breakString(stripArray[i], n6);
            this.adjustForBoxCenter(point);
            point.y -= this.m_BoxSize.height / 2;
            point.y += n6 / 2;
            this.drawCenteredString(gridRenderContext, point, stringArray[0], NINETY_DEGREES);
            n += n5;
            stripArray[i] = new Strip(stringArray[1], stripArray[i].getType());
            --i;
        }
    }

    protected void renderBoxesTBLR(GridRenderContext gridRenderContext) {
        Strip[] stripArray = this.buildStrips();
        int n = 0;
        for (int i = 0; i < stripArray.length && n < this.m_BoxCount; ++i) {
            Point point;
            int n2;
            String string = stripArray[i].getString();
            if (string.length() == 0) {
                ++n;
                continue;
            }
            int n3 = (int)this.m_FontMeasurer.getWidth(string);
            GlyphOrientation glyphOrientation = this.m_GlyphOrientation;
            if (glyphOrientation == GlyphOrientation.AUTO) {
                switch (stripArray[i].getType()) {
                    case 1: {
                        glyphOrientation = GlyphOrientation.INLINE;
                        break;
                    }
                    case 2: {
                        glyphOrientation = GlyphOrientation.UPRIGHT;
                        break;
                    }
                    case 3: {
                        glyphOrientation = GlyphOrientation.INLINE;
                        break;
                    }
                }
            }
            int n4 = n2 = glyphOrientation == GlyphOrientation.UPRIGHT ? 1 : 1 + n3 / this.m_BoxSize.height;
            if (n2 == 1) {
                point = this.getBox(n);
                this.adjustForBoxCenter(point);
                if (glyphOrientation == GlyphOrientation.INLINE) {
                    this.drawCenteredString(gridRenderContext, point, string, -NINETY_DEGREES);
                } else if (glyphOrientation == GlyphOrientation.UPRIGHT) {
                    this.drawCenteredString(gridRenderContext, point, string, 0.0);
                }
                ++n;
                continue;
            }
            point = this.getBox(n);
            if (point.y + n2 < this.m_BoxesDown) {
                this.adjustForBoxCenter(point);
                point.y += (n2 - 1) * this.m_BoxSize.height / 2;
                this.drawCenteredString(gridRenderContext, point, string, -NINETY_DEGREES);
                n += n2;
                continue;
            }
            int n5 = this.m_BoxesDown - point.y;
            int n6 = n5 * this.m_BoxSize.height;
            String[] stringArray = this.breakString(stripArray[i], n6);
            this.adjustForBoxCenter(point);
            point.y -= this.m_BoxSize.height / 2;
            point.y += n6 / 2;
            this.drawCenteredString(gridRenderContext, point, stringArray[0], -NINETY_DEGREES);
            n += n5;
            stripArray[i] = new Strip(stringArray[1], stripArray[i].getType());
            --i;
        }
    }

    protected void drawCenteredString(GridRenderContext gridRenderContext, Point point, String string, double d) {
        if (StringUtil.notEmpty(string)) {
            Graphics2D graphics2D = gridRenderContext.getGraphics();
            graphics2D.translate(point.x, point.y);
            if (d != 0.0) {
                graphics2D.rotate(d);
            }
            float f = this.m_FontMeasurer.getWidth(string);
            float f2 = this.m_FontMeasurer.getAscent();
            int n = (int)(-f) / 2;
            int n2 = (int)f2 / 2;
            int n3 = n + this.m_CharacterOffsetX;
            int n4 = n2 + this.m_CharacterOffsetY;
            graphics2D.drawString(string, n3, n4);
            if (this.m_FontUnderline || this.m_FontStrikethrough) {
                GeneralPath generalPath;
                float f3;
                float f4;
                FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                LineMetrics lineMetrics = this.m_Font.getLineMetrics(string, fontRenderContext);
                if (this.m_FontUnderline) {
                    f4 = (float)n4 + lineMetrics.getUnderlineOffset();
                    f3 = lineMetrics.getUnderlineThickness();
                    graphics2D.setStroke(new BasicStroke(f3));
                    generalPath = new GeneralPath();
                    generalPath.moveTo(n3, f4);
                    generalPath.lineTo((float)n3 + f, f4);
                    graphics2D.draw(generalPath);
                }
                if (this.m_FontStrikethrough) {
                    f4 = (float)n4 + lineMetrics.getStrikethroughOffset();
                    f3 = lineMetrics.getStrikethroughThickness();
                    graphics2D.setStroke(new BasicStroke(f3));
                    generalPath = new GeneralPath();
                    generalPath.moveTo(n3, f4);
                    generalPath.lineTo((float)n3 + f, f4);
                    graphics2D.draw(generalPath);
                }
            }
            if (d != 0.0) {
                graphics2D.rotate(-d);
            }
            graphics2D.translate(-point.x, -point.y);
        }
    }

    protected boolean mergeChar(char c, boolean bl) {
        if (bl) {
            return !CharUtil.isCJK(c);
        }
        return CharUtil.isArabic(c) || CharUtil.isHebrew(c) || CharUtil.isSyriac(c);
    }

    protected String[] breakString(Strip strip, int n) {
        String string = strip.getString();
        String[] stringArray = new String[]{string, ""};
        char[] cArray = string.toCharArray();
        for (int i = 1; i < cArray.length; ++i) {
            float f = this.m_FontMeasurer.getWidth(cArray, 0, i);
            if (!(f > (float)n)) continue;
            stringArray[0] = string.substring(0, i - 1);
            stringArray[1] = string.substring(i - 1);
            break;
        }
        return stringArray;
    }

    public Point getBox(int n) {
        int n2 = 0;
        int n3 = 0;
        if (this.m_WritingMode == WritingMode.LR_TB) {
            n2 = n % this.m_BoxesAcross;
            n3 = n / this.m_BoxesAcross;
        } else if (this.m_WritingMode == WritingMode.TB_RL) {
            n2 = n % this.m_BoxesDown;
            n3 = n / this.m_BoxesDown;
            int n4 = this.m_BoxesAcross - n3 - 1;
            int n5 = n2;
            n2 = n4;
            n3 = n5;
        } else if (this.m_WritingMode == WritingMode.RL_TB) {
            n2 = n % this.m_BoxesAcross;
            n3 = n / this.m_BoxesAcross;
            n2 = this.m_BoxesAcross - n2 - 1;
        } else if (this.m_WritingMode == WritingMode.TB_LR) {
            n2 = n / this.m_BoxesDown;
            n3 = n % this.m_BoxesDown;
        }
        return new Point(n2, n3);
    }

    protected void adjustForBoxCenter(Point point) {
        point.x = this.m_Left + point.x * this.m_BoxSize.width + this.m_BoxSize.width / 2;
        point.y = this.m_Top + point.y * this.m_BoxSize.height + this.m_BoxSize.height / 2;
    }
}

