/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.http.client;

import com.elixirtech.arch.package$;
import com.elixirtech.http.client.Encoders;
import com.elixirtech.http.client.Request$;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.Credentials;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.json4s.Extraction$;
import org.json4s.Formats;
import org.json4s.JValue;
import org.json4s.native.JsonMethods$;
import org.json4s.native.Printer$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.xml.Node;

public class Request
implements Encoders,
Product,
Serializable {
    private final HttpHost host;
    private final String method;
    private final String path;
    private final Option creds;
    private final List headers;
    private final Option body;
    private final Charset defaultCharset;
    private final boolean redirects;

    public static ContentType OctetStreamContentType() {
        return Request$.MODULE$.OctetStreamContentType();
    }

    public static Charset UTF8() {
        return Request$.MODULE$.UTF8();
    }

    public static Request apply(HttpHost httpHost, String string, String string2, Option<Credentials> option, List<Tuple2<String, String>> list, Option<HttpEntity> option2, Charset charset, boolean bl) {
        return Request$.MODULE$.apply(httpHost, string, string2, option, list, option2, charset, bl);
    }

    public static Request apply(String string, String string2) {
        return Request$.MODULE$.apply(string, string2);
    }

    public static Request apply(String string, String string2, boolean bl) {
        return Request$.MODULE$.apply(string, string2, bl);
    }

    public static HttpHost buildHost(String string) {
        return Request$.MODULE$.buildHost(string);
    }

    public static Tuple2<HttpHost, String> buildHostPath(String string) {
        return Request$.MODULE$.buildHostPath(string);
    }

    public static String buildPath(String string) {
        return Request$.MODULE$.buildPath(string);
    }

    public static Tuple2<HttpHost, String> buildRelativeHostPath(String string) {
        return Request$.MODULE$.buildRelativeHostPath(string);
    }

    public static Request fromProduct(Product product) {
        return Request$.MODULE$.fromProduct(product);
    }

    public static Tuple2<String, String> tokenHeader() {
        return Request$.MODULE$.tokenHeader();
    }

    public static Request unapply(Request request) {
        return Request$.MODULE$.unapply(request);
    }

    public static Option<Credentials> $lessinit$greater$default$4() {
        return Request$.MODULE$.$lessinit$greater$default$4();
    }

    public static List<Tuple2<String, String>> $lessinit$greater$default$5() {
        return Request$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<HttpEntity> $lessinit$greater$default$6() {
        return Request$.MODULE$.$lessinit$greater$default$6();
    }

    public static Charset $lessinit$greater$default$7() {
        return Request$.MODULE$.$lessinit$greater$default$7();
    }

    public static boolean $lessinit$greater$default$8() {
        return Request$.MODULE$.$lessinit$greater$default$8();
    }

    public Request(HttpHost host, String method, String path, Option<Credentials> creds, List<Tuple2<String, String>> headers, Option<HttpEntity> body, Charset defaultCharset, boolean redirects) {
        this.host = host;
        this.method = method;
        this.path = path;
        this.creds = creds;
        this.headers = headers;
        this.body = body;
        this.defaultCharset = defaultCharset;
        this.redirects = redirects;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.host()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.method()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.creds()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.headers()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.body()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.defaultCharset()));
        n = Statics.mix((int)n, (int)(this.redirects() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Request)) return false;
        Request request = (Request)object;
        if (this.redirects() != request.redirects()) return false;
        HttpHost httpHost = this.host();
        HttpHost httpHost2 = request.host();
        if (httpHost == null) {
            if (httpHost2 != null) {
                return false;
            }
        } else if (!httpHost.equals(httpHost2)) return false;
        String string = this.method();
        String string2 = request.method();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.path();
        String string4 = request.path();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        Option<Credentials> option = this.creds();
        Option<Credentials> option2 = request.creds();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        List<Tuple2<String, String>> list = this.headers();
        List<Tuple2<String, String>> list2 = request.headers();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        Option<HttpEntity> option3 = this.body();
        Option<HttpEntity> option4 = request.body();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Charset charset = this.defaultCharset();
        Charset charset2 = request.defaultCharset();
        if (charset == null) {
            if (charset2 != null) {
                return false;
            }
        } else if (!((Object)charset).equals(charset2)) return false;
        if (!request.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Request;
    }

    public int productArity() {
        return 8;
    }

    public String productPrefix() {
        return "Request";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return this._7();
            }
            case 7: {
                return BoxesRunTime.boxToBoolean((boolean)this._8());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "host";
            }
            case 1: {
                return "method";
            }
            case 2: {
                return "path";
            }
            case 3: {
                return "creds";
            }
            case 4: {
                return "headers";
            }
            case 5: {
                return "body";
            }
            case 6: {
                return "defaultCharset";
            }
            case 7: {
                return "redirects";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public HttpHost host() {
        return this.host;
    }

    public String method() {
        return this.method;
    }

    public String path() {
        return this.path;
    }

    public Option<Credentials> creds() {
        return this.creds;
    }

    public List<Tuple2<String, String>> headers() {
        return this.headers;
    }

    public Option<HttpEntity> body() {
        return this.body;
    }

    @Override
    public Charset defaultCharset() {
        return this.defaultCharset;
    }

    public boolean redirects() {
        return this.redirects;
    }

    public Request withParameters(Iterable<Tuple2<String, String>> values) {
        if (values.isEmpty()) {
            return this;
        }
        String string = StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(this.path()), '?') ? this.path() + '&' + this.form_enc((Iterable)values) : this.path() + (String)(values.isEmpty() ? "" : "?" + this.form_enc((Iterable)values));
        HttpHost httpHost = this.copy$default$1();
        String string2 = this.copy$default$2();
        Option<Credentials> option = this.copy$default$4();
        List<Tuple2<String, String>> list = this.copy$default$5();
        Option<HttpEntity> option2 = this.copy$default$6();
        Charset charset = this.copy$default$7();
        boolean bl = this.copy$default$8();
        return this.copy(httpHost, string2, string, option, list, option2, charset, bl);
    }

    public Request withHeaders(Iterable<Tuple2<String, String>> values) {
        if (values.isEmpty()) {
            return this;
        }
        List list = values.toList();
        List list2 = this.headers().$colon$colon$colon(list);
        HttpHost httpHost = this.copy$default$1();
        String string = this.copy$default$2();
        String string2 = this.copy$default$3();
        Option<Credentials> option = this.copy$default$4();
        Option<HttpEntity> option2 = this.copy$default$6();
        Charset charset = this.copy$default$7();
        boolean bl = this.copy$default$8();
        return this.copy(httpHost, string, string2, option, (List<Tuple2<String, String>>)list2, option2, charset, bl);
    }

    public Request withToken() {
        Tuple2<String, String> tuple2 = Request$.MODULE$.tokenHeader();
        List list = this.headers().$colon$colon(tuple2);
        HttpHost httpHost = this.copy$default$1();
        String string = this.copy$default$2();
        String string2 = this.copy$default$3();
        Option<Credentials> option = this.copy$default$4();
        Option<HttpEntity> option2 = this.copy$default$6();
        Charset charset = this.copy$default$7();
        boolean bl = this.copy$default$8();
        return this.copy(httpHost, string, string2, option, (List<Tuple2<String, String>>)list, option2, charset, bl);
    }

    public Request withAccept(String s) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)"Accept", (Object)s);
        List list = this.headers().$colon$colon((Object)tuple2);
        HttpHost httpHost = this.copy$default$1();
        String string = this.copy$default$2();
        String string2 = this.copy$default$3();
        Option<Credentials> option = this.copy$default$4();
        Option<HttpEntity> option2 = this.copy$default$6();
        Charset charset = this.copy$default$7();
        boolean bl = this.copy$default$8();
        return this.copy(httpHost, string, string2, option, (List<Tuple2<String, String>>)list, option2, charset, bl);
    }

    public Request withBytes(byte[] bytes) {
        Some some = Some$.MODULE$.apply((Object)new ByteArrayEntity(bytes, Request$.MODULE$.OctetStreamContentType()));
        HttpHost httpHost = this.copy$default$1();
        String string = this.copy$default$2();
        String string2 = this.copy$default$3();
        Option<Credentials> option = this.copy$default$4();
        List<Tuple2<String, String>> list = this.copy$default$5();
        Charset charset = this.copy$default$7();
        boolean bl = this.copy$default$8();
        return this.copy(httpHost, string, string2, option, list, (Option<HttpEntity>)some, charset, bl);
    }

    public Request withBytes(byte[] bytes, String contentType) {
        Some some = Some$.MODULE$.apply((Object)new ByteArrayEntity(bytes, ContentType.create((String)contentType)));
        HttpHost httpHost = this.copy$default$1();
        String string = this.copy$default$2();
        String string2 = this.copy$default$3();
        Option<Credentials> option = this.copy$default$4();
        List<Tuple2<String, String>> list = this.copy$default$5();
        Charset charset = this.copy$default$7();
        boolean bl = this.copy$default$8();
        return this.copy(httpHost, string, string2, option, list, (Option<HttpEntity>)some, charset, bl);
    }

    public Request withBytes(InputStream is) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        package$.MODULE$.enrichInputStream(is).copyTo((OutputStream)baos);
        return this.withBytes(baos.toByteArray());
    }

    public Request withString(String s, String mimeType) {
        Some some = Some$.MODULE$.apply((Object)new RefStringEntity(s, ContentType.create((String)mimeType, (String)this.defaultCharset().name())));
        HttpHost httpHost = this.copy$default$1();
        String string = this.copy$default$2();
        String string2 = this.copy$default$3();
        Option<Credentials> option = this.copy$default$4();
        List<Tuple2<String, String>> list = this.copy$default$5();
        Charset charset = this.copy$default$7();
        boolean bl = this.copy$default$8();
        return this.copy(httpHost, string, string2, option, list, (Option<HttpEntity>)some, charset, bl);
    }

    public Request withJson(JValue jv) {
        return this.withString(Printer$.MODULE$.compact(JsonMethods$.MODULE$.render(jv, JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3())), "application/json");
    }

    public Request withJsonObject(Object obj, Formats formats) {
        JValue json = Extraction$.MODULE$.decompose(obj, formats);
        return this.withString(Printer$.MODULE$.compact(JsonMethods$.MODULE$.render(json, JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3())), "application/json");
    }

    public Request withXml(Node xml) {
        return this.withString(xml.toString(), "text/xml");
    }

    public Request withSoap(Node xml) {
        return this.withString(xml.toString(), "application/soap+xml");
    }

    public Request withFile(File file, String mimeType) {
        Some some = Some$.MODULE$.apply((Object)new FileEntity(file, ContentType.create((String)mimeType)));
        HttpHost httpHost = this.copy$default$1();
        String string = this.copy$default$2();
        String string2 = this.copy$default$3();
        Option<Credentials> option = this.copy$default$4();
        List<Tuple2<String, String>> list = this.copy$default$5();
        Charset charset = this.copy$default$7();
        boolean bl = this.copy$default$8();
        return this.copy(httpHost, string, string2, option, list, (Option<HttpEntity>)some, charset, bl);
    }

    public Request withForm(Iterable<Tuple2<String, String>> values) {
        Some some = Some$.MODULE$.apply((Object)this.form_ent(values));
        HttpHost httpHost = this.copy$default$1();
        String string = this.copy$default$2();
        String string2 = this.copy$default$3();
        Option<Credentials> option = this.copy$default$4();
        List<Tuple2<String, String>> list = this.copy$default$5();
        Charset charset = this.copy$default$7();
        boolean bl = this.copy$default$8();
        return this.copy(httpHost, string, string2, option, list, (Option<HttpEntity>)some, charset, bl);
    }

    public Request withNoRedirects() {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), false);
    }

    private FormEntity form_ent(Iterable<Tuple2<String, String>> values) {
        return (FormEntity)this.body().map((Function1 & Serializable)x$1 -> {
            HttpEntity httpEntity = x$1;
            if (httpEntity instanceof FormEntity) {
                FormEntity ent = (FormEntity)httpEntity;
                return ent.add(values);
            }
            if (httpEntity != null) {
                HttpEntity ent = httpEntity;
                throw scala.sys.package$.MODULE$.error("trying to add post parameters << to entity: " + ent);
            }
            throw new MatchError((Object)httpEntity);
        }).getOrElse(() -> this.form_ent$$anonfun$2(values));
    }

    public Request copy(HttpHost host, String method, String path, Option<Credentials> creds, List<Tuple2<String, String>> headers, Option<HttpEntity> body, Charset defaultCharset, boolean redirects) {
        return new Request(host, method, path, creds, headers, body, defaultCharset, redirects);
    }

    public HttpHost copy$default$1() {
        return this.host();
    }

    public String copy$default$2() {
        return this.method();
    }

    public String copy$default$3() {
        return this.path();
    }

    public Option<Credentials> copy$default$4() {
        return this.creds();
    }

    public List<Tuple2<String, String>> copy$default$5() {
        return this.headers();
    }

    public Option<HttpEntity> copy$default$6() {
        return this.body();
    }

    public Charset copy$default$7() {
        return this.defaultCharset();
    }

    public boolean copy$default$8() {
        return this.redirects();
    }

    public HttpHost _1() {
        return this.host();
    }

    public String _2() {
        return this.method();
    }

    public String _3() {
        return this.path();
    }

    public Option<Credentials> _4() {
        return this.creds();
    }

    public List<Tuple2<String, String>> _5() {
        return this.headers();
    }

    public Option<HttpEntity> _6() {
        return this.body();
    }

    public Charset _7() {
        return this.defaultCharset();
    }

    public boolean _8() {
        return this.redirects();
    }

    private final FormEntity form_ent$$anonfun$2(Iterable values$2) {
        return new UrlEncodedFormEntity(this, (Iterable<Tuple2<String, String>>)values$2);
    }

    public static interface FormEntity
    extends HttpEntity {
        public Iterable<Tuple2<String, String>> params();

        public FormEntity add(Iterable<Tuple2<String, String>> var1);
    }

    public static class RefStringEntity
    extends StringEntity {
        private final String string;

        public RefStringEntity(String string, ContentType contentType) {
            this.string = string;
            super(string, contentType);
        }

        public String string() {
            return this.string;
        }
    }

    public static class UrlEncodedFormEntity
    extends RefStringEntity
    implements FormEntity {
        private final Request request;
        private final Iterable params;

        public UrlEncodedFormEntity(Request request, Iterable<Tuple2<String, String>> params) {
            this.request = request;
            this.params = params;
            super(Request$.MODULE$.com$elixirtech$http$client$Request$$$UrlEncodedFormEntity$superArg$1(request, params), ContentType.create((String)"application/x-www-form-urlencoded", (Charset)request.defaultCharset()));
        }

        public Request request() {
            return this.request;
        }

        @Override
        public Iterable<Tuple2<String, String>> params() {
            return this.params;
        }

        @Override
        public UrlEncodedFormEntity add(Iterable<Tuple2<String, String>> values) {
            return new UrlEncodedFormEntity(this.request(), (Iterable<Tuple2<String, String>>)((Iterable)this.params().$plus$plus(values)));
        }
    }
}

