/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.http.client;

import com.elixirtech.arch.ARM;
import com.elixirtech.arch.ARM$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper;
import com.elixirtech.arch.logging.SLF4J;
import com.elixirtech.http.client.Response;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.input.SAXBuilder;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JValue;
import org.json4s.native.JsonParser$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.Manifest;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Try$;
import scala.util.control.Exception$;
import scala.xml.Elem;
import scala.xml.XML$;

public final class ResponseExtractor$
implements SLF4J,
LoggingHelper,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ResponseExtractor$.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    public static final ResponseExtractor$ MODULE$ = new ResponseExtractor$();

    private ResponseExtractor$() {
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggingHelper.logger$((LoggingHelper)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ResponseExtractor$.class);
    }

    public Either<LogMessage, BoxedUnit> ignore(Response r) {
        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    public Either<LogMessage, Option<String>> header(String name, Response r) {
        return package$.MODULE$.Right().apply(r.header(name));
    }

    public Either<LogMessage, byte[]> asBytes(Response r) {
        return this.withInputStream(r, (Function1 & Serializable)is -> {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            com.elixirtech.arch.package$.MODULE$.enrichInputStream(is).copyTo((OutputStream)baos);
            return package$.MODULE$.Right().apply((Object)baos.toByteArray());
        });
    }

    public Either<LogMessage, File> asTempFile(Response r) {
        return this.withInputStream(r, (Function1 & Serializable)is -> (Either)ARM$.MODULE$.run((Function1 & Serializable)arm -> {
            File file = File.createTempFile("response", ".dat");
            BufferedOutputStream os = (BufferedOutputStream)arm.manage((Object)com.elixirtech.arch.package$.MODULE$.enrichOutputStream((OutputStream)com.elixirtech.arch.package$.MODULE$.enrichFile(file).output()).buffered());
            com.elixirtech.arch.package$.MODULE$.enrichInputStream(is).copyTo((OutputStream)os);
            return package$.MODULE$.Right().apply((Object)file);
        }));
    }

    public Either<LogMessage, File> asFile(File file, Response r) {
        if (r.code() != 304) {
            return this.withInputStream(r, (Function1 & Serializable)is -> (Either)ARM$.MODULE$.run((Function1 & Serializable)arm -> {
                BufferedOutputStream os = (BufferedOutputStream)arm.manage((Object)com.elixirtech.arch.package$.MODULE$.enrichOutputStream((OutputStream)com.elixirtech.arch.package$.MODULE$.enrichFile(file).output()).buffered());
                com.elixirtech.arch.package$.MODULE$.enrichInputStream(is).copyTo((OutputStream)os);
                return package$.MODULE$.Right().apply((Object)file);
            }));
        }
        return package$.MODULE$.Right().apply((Object)file);
    }

    public Either<LogMessage, JValue> asJson(Response r) {
        return this.asString(r).flatMap((Function1 & Serializable)s -> Try$.MODULE$.apply(() -> ResponseExtractor$.asJson$$anonfun$1$$anonfun$1(s)).toEither().left().map((Function1 & Serializable)ex -> LogMessage.ErrorEx$.MODULE$.apply("Can't parse JSON", ex)));
    }

    public <T> Either<LogMessage, T> asJsonObject(Response r, Formats formats, Manifest<T> mf) {
        return this.asJson(r).flatMap((Function1 & Serializable)jv -> Exception$.MODULE$.allCatch().either(() -> ResponseExtractor$.asJsonObject$$anonfun$1$$anonfun$1(jv, formats, mf)).left().map((Function1 & Serializable)ex -> MODULE$.log("Can't extract from JSON", (Throwable)ex)));
    }

    public Either<LogMessage, String> asString(Response r) {
        return this.withReader(r, (Function1 & Serializable)reader -> package$.MODULE$.Right().apply((Object)com.elixirtech.arch.package$.MODULE$.enrichReader(reader).text()));
    }

    public Either<LogMessage, Elem> asXml(Response r) {
        return this.withReader(r, (Function1 & Serializable)reader -> Exception$.MODULE$.allCatch().either(() -> ResponseExtractor$.asXml$$anonfun$1$$anonfun$1(reader)).left().map((Function1 & Serializable)ex -> MODULE$.log("Can't parse XML", (Throwable)ex)));
    }

    public Either<LogMessage, Document> asJDom(Response r) {
        return this.withInputStream(r, (Function1 & Serializable)is -> {
            SAXBuilder sb = new SAXBuilder();
            return Exception$.MODULE$.allCatch().either(() -> ResponseExtractor$.asJDom$$anonfun$1$$anonfun$1(sb, is)).left().map((Function1 & Serializable)ex -> MODULE$.log("Can't parse JDOM", (Throwable)ex));
        });
    }

    public Either<LogMessage, BoxedUnit> toOutputStream(Response r, OutputStream out) {
        return this.withInputStream(r, (Function1 & Serializable)is -> (Either)ARM$.MODULE$.run((Function1 & Serializable)arm -> {
            com.elixirtech.arch.package$.MODULE$.enrichInputStream(is).copyTo(out);
            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        }));
    }

    public <T> Either<LogMessage, T> withInputStream(Response r, Function1<InputStream, Either<LogMessage, T>> fn) {
        Option<HttpEntity> option = r.optEntity();
        if (option instanceof Some) {
            HttpEntity entity = (HttpEntity)((Some)option).value();
            return (Either)ARM$.MODULE$.run((Function1 & Serializable)arm -> Exception$.MODULE$.catching((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{IOException.class})).either(() -> ResponseExtractor$.withInputStream$$anonfun$1$$anonfun$1(entity, fn)).left().map((Function1 & Serializable)ex -> MODULE$.log("InputStream error", (Throwable)ex)).joinRight((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("No contents"));
        }
        throw new MatchError(option);
    }

    public <T> Either<LogMessage, T> withReader(Response r, Function1<Reader, Either<LogMessage, T>> fn) {
        Option<HttpEntity> option = r.optEntity();
        if (option instanceof Some) {
            HttpEntity entity = (HttpEntity)((Some)option).value();
            return (Either)ARM$.MODULE$.run((Function1 & Serializable)arm -> Exception$.MODULE$.catching((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{IOException.class})).either(() -> ResponseExtractor$.withReader$$anonfun$1$$anonfun$1(entity, arm, fn)).left().map((Function1 & Serializable)ex -> MODULE$.log("Reader error", (Throwable)ex)).joinRight((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("No contents"));
        }
        throw new MatchError(option);
    }

    private LogMessage log(String msg, Throwable ex) {
        return LogMessage.ErrorEx$.MODULE$.apply(msg, ex);
    }

    private Tuple2<InputStream, String> asInputStream(HttpEntity entity) {
        InputStream inputStream;
        Predef$.MODULE$.require(entity != null, ResponseExtractor$::asInputStream$$anonfun$1);
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)entity.getContent(), (Object)entity.getContentEncoding());
        if (tuple2 != null) {
            InputStream inputStream2 = (InputStream)tuple2._1();
            Header header = (Header)tuple2._2();
            InputStream stm = inputStream2;
            if (header == null) {
                inputStream = stm;
            } else {
                InputStream stm2;
                InputStream stm3 = inputStream2;
                Header enc = header;
                String string = enc.getValue();
                String string2 = "gzip";
                inputStream = !(string != null ? !string.equals(string2) : string2 != null) ? new GZIPInputStream(stm3) : (stm2 = inputStream2);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        InputStream stm = inputStream;
        String charset = (String)Option$.MODULE$.apply((Object)ContentType.get((HttpEntity)entity)).flatMap((Function1 & Serializable)ct -> Option$.MODULE$.apply((Object)ct.getCharset()).map((Function1 & Serializable)ch -> ch.name())).getOrElse(ResponseExtractor$::$anonfun$2);
        return Tuple2$.MODULE$.apply((Object)stm, (Object)charset);
    }

    private static final JValue asJson$$anonfun$1$$anonfun$1(String s$1) {
        return JsonParser$.MODULE$.parse(s$1);
    }

    private static final Object asJsonObject$$anonfun$1$$anonfun$1(JValue jv$1, Formats formats$1, Manifest mf$1) {
        return ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(jv$1), formats$1, mf$1);
    }

    private static final Elem asXml$$anonfun$1$$anonfun$1(Reader reader$1) {
        return (Elem)XML$.MODULE$.load(reader$1);
    }

    private static final Document asJDom$$anonfun$1$$anonfun$1(SAXBuilder sb$1, InputStream is$3) {
        return sb$1.build(is$3);
    }

    private static final Either withInputStream$$anonfun$1$$anonfun$1(HttpEntity entity$2, Function1 fn$2) {
        Tuple2<InputStream, String> tuple2 = MODULE$.asInputStream(entity$2);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        InputStream stm = (InputStream)tuple2._1();
        String charset = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)stm, (Object)charset);
        InputStream stm2 = (InputStream)tuple22._1();
        String charset2 = (String)tuple22._2();
        return (Either)fn$2.apply((Object)stm2);
    }

    private static final Either withReader$$anonfun$1$$anonfun$1(HttpEntity entity$4, ARM arm$1, Function1 fn$4) {
        Tuple2<InputStream, String> tuple2 = MODULE$.asInputStream(entity$4);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        InputStream stm = (InputStream)tuple2._1();
        String charset = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)stm, (Object)charset);
        InputStream stm2 = (InputStream)tuple22._1();
        String charset2 = (String)tuple22._2();
        InputStreamReader r = (InputStreamReader)arm$1.manage((Object)new InputStreamReader(stm2, charset2));
        return (Either)fn$4.apply((Object)r);
    }

    private static final Object asInputStream$$anonfun$1() {
        return "asInputStream entity is null";
    }

    private static final String $anonfun$2() {
        return "UTF-8";
    }
}

