/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.jaxen;

import com.elixirtech.jaxen.Context;
import com.elixirtech.jaxen.ContextSupport;
import com.elixirtech.jaxen.FunctionContext;
import com.elixirtech.jaxen.JaxenException;
import com.elixirtech.jaxen.JaxenHandler;
import com.elixirtech.jaxen.NamespaceContext;
import com.elixirtech.jaxen.Navigator;
import com.elixirtech.jaxen.SimpleNamespaceContext;
import com.elixirtech.jaxen.SimpleVariableContext;
import com.elixirtech.jaxen.VariableContext;
import com.elixirtech.jaxen.XPath;
import com.elixirtech.jaxen.XPathFunctionContext;
import com.elixirtech.jaxen.XPathSyntaxException;
import com.elixirtech.jaxen.expr.Expr;
import com.elixirtech.jaxen.expr.XPathExpr;
import com.elixirtech.jaxen.function.BooleanFunction;
import com.elixirtech.jaxen.function.NumberFunction;
import com.elixirtech.jaxen.function.StringFunction;
import com.elixirtech.jaxen.saxpath.SAXPathException;
import com.elixirtech.jaxen.saxpath.XPathReader;
import com.elixirtech.jaxen.saxpath.helpers.XPathReaderFactory;
import com.elixirtech.jaxen.util.SingletonList;
import java.io.Serializable;
import java.util.List;

public class BaseXPath
implements XPath,
Serializable {
    private String exprText;
    private XPathExpr xpath;
    private ContextSupport support;
    private Navigator navigator;

    protected BaseXPath(String string) throws JaxenException {
        try {
            XPathReader xPathReader = XPathReaderFactory.createReader();
            JaxenHandler jaxenHandler = new JaxenHandler();
            xPathReader.setXPathHandler(jaxenHandler);
            xPathReader.parse(string);
            this.xpath = jaxenHandler.getXPathExpr();
        }
        catch (com.elixirtech.jaxen.saxpath.XPathSyntaxException xPathSyntaxException) {
            throw new XPathSyntaxException(xPathSyntaxException);
        }
        catch (SAXPathException sAXPathException) {
            throw new JaxenException(sAXPathException);
        }
        this.exprText = string;
    }

    public BaseXPath(String string, Navigator navigator) throws JaxenException {
        this(string);
        this.navigator = navigator;
    }

    @Override
    public Object evaluate(Object object) throws JaxenException {
        Object e;
        List list = this.selectNodes(object);
        if (list != null && list.size() == 1 && ((e = list.get(0)) instanceof String || e instanceof Number || e instanceof Boolean)) {
            return e;
        }
        return list;
    }

    @Override
    public List selectNodes(Object object) throws JaxenException {
        Context context = this.getContext(object);
        return this.selectNodesForContext(context);
    }

    @Override
    public Object selectSingleNode(Object object) throws JaxenException {
        List list = this.selectNodes(object);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    @Deprecated
    public String valueOf(Object object) throws JaxenException {
        return this.stringValueOf(object);
    }

    @Override
    public String stringValueOf(Object object) throws JaxenException {
        Context context = this.getContext(object);
        Object object2 = this.selectSingleNodeForContext(context);
        if (object2 == null) {
            return "";
        }
        return StringFunction.evaluate(object2, context.getNavigator());
    }

    @Override
    public boolean booleanValueOf(Object object) throws JaxenException {
        Context context = this.getContext(object);
        List list = this.selectNodesForContext(context);
        if (list == null) {
            return false;
        }
        return BooleanFunction.evaluate(list, context.getNavigator());
    }

    @Override
    public Number numberValueOf(Object object) throws JaxenException {
        Context context = this.getContext(object);
        Object object2 = this.selectSingleNodeForContext(context);
        return NumberFunction.evaluate(object2, context.getNavigator());
    }

    @Override
    public void addNamespace(String string, String string2) throws JaxenException {
        NamespaceContext namespaceContext = this.getNamespaceContext();
        if (namespaceContext instanceof SimpleNamespaceContext) {
            ((SimpleNamespaceContext)namespaceContext).addNamespace(string, string2);
            return;
        }
        throw new JaxenException("Operation not permitted while using a non-simple namespace context.");
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.getContextSupport().setNamespaceContext(namespaceContext);
    }

    @Override
    public void setFunctionContext(FunctionContext functionContext) {
        this.getContextSupport().setFunctionContext(functionContext);
    }

    @Override
    public void setVariableContext(VariableContext variableContext) {
        this.getContextSupport().setVariableContext(variableContext);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.getContextSupport().getNamespaceContext();
    }

    @Override
    public FunctionContext getFunctionContext() {
        return this.getContextSupport().getFunctionContext();
    }

    @Override
    public VariableContext getVariableContext() {
        return this.getContextSupport().getVariableContext();
    }

    public Expr getRootExpr() {
        return this.xpath.getRootExpr();
    }

    public String toString() {
        return this.exprText;
    }

    public String debug() {
        return this.xpath.toString();
    }

    protected Context getContext(Object object) {
        if (object instanceof Context) {
            return (Context)object;
        }
        Context context = new Context(this.getContextSupport());
        if (object instanceof List) {
            context.setNodeSet((List)object);
        } else {
            SingletonList singletonList = new SingletonList(object);
            context.setNodeSet(singletonList);
        }
        return context;
    }

    protected ContextSupport getContextSupport() {
        if (this.support == null) {
            this.support = new ContextSupport(this.createNamespaceContext(), this.createFunctionContext(), this.createVariableContext(), this.getNavigator());
        }
        return this.support;
    }

    @Override
    public Navigator getNavigator() {
        return this.navigator;
    }

    protected FunctionContext createFunctionContext() {
        return XPathFunctionContext.getInstance();
    }

    protected NamespaceContext createNamespaceContext() {
        return new SimpleNamespaceContext();
    }

    protected VariableContext createVariableContext() {
        return new SimpleVariableContext();
    }

    protected List selectNodesForContext(Context context) throws JaxenException {
        List list = this.xpath.asList(context);
        return list;
    }

    protected Object selectSingleNodeForContext(Context context) throws JaxenException {
        List list = this.selectNodesForContext(context);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }
}

