/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.jaxen.expr;

import com.elixirtech.jaxen.Context;
import com.elixirtech.jaxen.ContextSupport;
import com.elixirtech.jaxen.JaxenException;
import com.elixirtech.jaxen.Navigator;
import com.elixirtech.jaxen.UnresolvableException;
import com.elixirtech.jaxen.expr.DefaultStep;
import com.elixirtech.jaxen.expr.IdentitySet;
import com.elixirtech.jaxen.expr.NameStep;
import com.elixirtech.jaxen.expr.PredicateSet;
import com.elixirtech.jaxen.expr.Visitor;
import com.elixirtech.jaxen.expr.iter.IterableAxis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DefaultNameStep
extends DefaultStep
implements NameStep {
    private static final long serialVersionUID = 428414912247718390L;
    private String prefix;
    private String localName;
    private boolean matchesAnyName;
    private boolean hasPrefix;

    public DefaultNameStep(IterableAxis iterableAxis, String string, String string2, PredicateSet predicateSet) {
        super(iterableAxis, predicateSet);
        this.prefix = string;
        this.localName = string2;
        this.matchesAnyName = "*".equals(string2);
        this.hasPrefix = this.prefix != null && this.prefix.length() > 0;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    public boolean isMatchesAnyName() {
        return this.matchesAnyName;
    }

    @Override
    public String getText() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getAxisName()).append("::");
        if (this.getPrefix() != null && this.getPrefix().length() > 0) {
            stringBuffer.append(this.getPrefix()).append(':');
        }
        return stringBuffer.append(this.getLocalName()).append(super.getText()).toString();
    }

    public List evaluate(Context context) throws JaxenException {
        boolean bl;
        List list = context.getNodeSet();
        int n = list.size();
        if (n == 0) {
            return Collections.EMPTY_LIST;
        }
        ContextSupport contextSupport = context.getContextSupport();
        IterableAxis iterableAxis = this.getIterableAxis();
        boolean bl2 = bl = !this.matchesAnyName && iterableAxis.supportsNamedAccess(contextSupport);
        if (n == 1) {
            Object e = list.get(0);
            if (bl) {
                String string = null;
                if (this.hasPrefix && (string = contextSupport.translateNamespacePrefixToUri(this.prefix)) == null) {
                    throw new UnresolvableException("XPath expression uses unbound namespace prefix " + this.prefix);
                }
                Iterator<Object> iterator = iterableAxis.namedAccessIterator(e, contextSupport, this.localName, this.prefix, string);
                if (iterator == null || !iterator.hasNext()) {
                    return Collections.EMPTY_LIST;
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                return this.getPredicateSet().evaluatePredicates(arrayList, contextSupport);
            }
            Iterator<Object> iterator = iterableAxis.iterator(e, contextSupport);
            if (iterator == null || !iterator.hasNext()) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(n);
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!this.matches(object, contextSupport)) continue;
                arrayList.add(object);
            }
            return this.getPredicateSet().evaluatePredicates(arrayList, contextSupport);
        }
        IdentitySet identitySet = new IdentitySet();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        ArrayList arrayList2 = new ArrayList(n);
        if (bl) {
            String string = null;
            if (this.hasPrefix && (string = contextSupport.translateNamespacePrefixToUri(this.prefix)) == null) {
                throw new UnresolvableException("XPath expression uses unbound namespace prefix " + this.prefix);
            }
            for (int i = 0; i < n; ++i) {
                Object e = list.get(i);
                Iterator<Object> iterator = iterableAxis.namedAccessIterator(e, contextSupport, this.localName, this.prefix, string);
                if (iterator == null || !iterator.hasNext()) continue;
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (identitySet.contains(object)) continue;
                    identitySet.add(object);
                    arrayList.add(object);
                }
                arrayList2.addAll(this.getPredicateSet().evaluatePredicates(arrayList, contextSupport));
                arrayList.clear();
            }
        } else {
            for (int i = 0; i < n; ++i) {
                Object e = list.get(i);
                Iterator<Object> iterator = this.axisIterator(e, contextSupport);
                if (iterator == null || !iterator.hasNext()) continue;
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (!this.matches(object, contextSupport) || identitySet.contains(object)) continue;
                    identitySet.add(object);
                    arrayList.add(object);
                }
                arrayList2.addAll(this.getPredicateSet().evaluatePredicates(arrayList, contextSupport));
                arrayList.clear();
            }
        }
        return arrayList2;
    }

    @Override
    public boolean matches(Object object, ContextSupport contextSupport) throws JaxenException {
        Navigator navigator = contextSupport.getNavigator();
        String string = null;
        String string2 = null;
        String string3 = null;
        if (navigator.isElement(object)) {
            string2 = navigator.getElementName(object);
            string3 = navigator.getElementNamespaceUri(object);
        } else {
            if (navigator.isText(object)) {
                return false;
            }
            if (navigator.isAttribute(object)) {
                if (this.getAxis() != 9) {
                    return false;
                }
                string2 = navigator.getAttributeName(object);
                string3 = navigator.getAttributeNamespaceUri(object);
            } else {
                if (navigator.isDocument(object)) {
                    return false;
                }
                if (navigator.isNamespace(object)) {
                    if (this.getAxis() != 10) {
                        return false;
                    }
                    string2 = navigator.getNamespacePrefix(object);
                } else {
                    return false;
                }
            }
        }
        if (this.hasPrefix) {
            string = contextSupport.translateNamespacePrefixToUri(this.prefix);
            if (string == null) {
                throw new UnresolvableException("Cannot resolve namespace prefix '" + this.prefix + "'");
            }
        } else if (this.matchesAnyName) {
            return true;
        }
        if (this.hasNamespace(string) != this.hasNamespace(string3)) {
            return false;
        }
        if (this.matchesAnyName || string2.equals(this.getLocalName())) {
            return this.matchesNamespaceURIs(string, string3);
        }
        return false;
    }

    private boolean hasNamespace(String string) {
        return string != null && string.length() > 0;
    }

    protected boolean matchesNamespaceURIs(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string == null) {
            return string2.length() == 0;
        }
        if (string2 == null) {
            return string.length() == 0;
        }
        return string.equals(string2);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        String string = this.getPrefix();
        String string2 = "".equals(string) ? this.getLocalName() : this.getPrefix() + ":" + this.getLocalName();
        return "[(DefaultNameStep): " + string2 + "]";
    }
}

