/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.jaxen.pattern;

import com.elixirtech.jaxen.JaxenException;
import com.elixirtech.jaxen.JaxenHandler;
import com.elixirtech.jaxen.expr.DefaultAllNodeStep;
import com.elixirtech.jaxen.expr.DefaultCommentNodeStep;
import com.elixirtech.jaxen.expr.DefaultFilterExpr;
import com.elixirtech.jaxen.expr.DefaultNameStep;
import com.elixirtech.jaxen.expr.DefaultProcessingInstructionNodeStep;
import com.elixirtech.jaxen.expr.DefaultStep;
import com.elixirtech.jaxen.expr.DefaultTextNodeStep;
import com.elixirtech.jaxen.expr.DefaultXPathFactory;
import com.elixirtech.jaxen.expr.Expr;
import com.elixirtech.jaxen.expr.FilterExpr;
import com.elixirtech.jaxen.expr.LocationPath;
import com.elixirtech.jaxen.expr.Predicate;
import com.elixirtech.jaxen.expr.PredicateSet;
import com.elixirtech.jaxen.expr.Step;
import com.elixirtech.jaxen.expr.UnionExpr;
import com.elixirtech.jaxen.pattern.LocationPathPattern;
import com.elixirtech.jaxen.pattern.NameTest;
import com.elixirtech.jaxen.pattern.NamespaceTest;
import com.elixirtech.jaxen.pattern.NodeTypeTest;
import com.elixirtech.jaxen.pattern.Pattern;
import com.elixirtech.jaxen.pattern.TextNodeTest;
import com.elixirtech.jaxen.pattern.UnionPattern;
import com.elixirtech.jaxen.saxpath.SAXPathException;
import com.elixirtech.jaxen.saxpath.XPathReader;
import com.elixirtech.jaxen.saxpath.helpers.XPathReaderFactory;
import java.util.Iterator;
import java.util.List;

public class PatternParser {
    private static final boolean TRACE = false;
    private static final boolean USE_HANDLER = false;

    public static Pattern parse(String string) throws JaxenException, SAXPathException {
        XPathReader xPathReader = XPathReaderFactory.createReader();
        JaxenHandler jaxenHandler = new JaxenHandler();
        jaxenHandler.setXPathFactory(new DefaultXPathFactory());
        xPathReader.setXPathHandler(jaxenHandler);
        xPathReader.parse(string);
        Pattern pattern = PatternParser.convertExpr(jaxenHandler.getXPathExpr().getRootExpr());
        return pattern.simplify();
    }

    protected static Pattern convertExpr(Expr expr) throws JaxenException {
        if (expr instanceof LocationPath) {
            return PatternParser.convertExpr((LocationPath)expr);
        }
        if (expr instanceof FilterExpr) {
            LocationPathPattern locationPathPattern = new LocationPathPattern();
            locationPathPattern.addFilter((FilterExpr)expr);
            return locationPathPattern;
        }
        if (expr instanceof UnionExpr) {
            UnionExpr unionExpr = (UnionExpr)expr;
            Pattern pattern = PatternParser.convertExpr(unionExpr.getLHS());
            Pattern pattern2 = PatternParser.convertExpr(unionExpr.getRHS());
            return new UnionPattern(pattern, pattern2);
        }
        LocationPathPattern locationPathPattern = new LocationPathPattern();
        locationPathPattern.addFilter(new DefaultFilterExpr(expr, new PredicateSet()));
        return locationPathPattern;
    }

    protected static LocationPathPattern convertExpr(LocationPath locationPath) throws JaxenException {
        LocationPathPattern locationPathPattern = new LocationPathPattern();
        List list = locationPath.getSteps();
        LocationPathPattern locationPathPattern2 = locationPathPattern;
        boolean bl = true;
        Object object = list.listIterator(list.size());
        while (object.hasPrevious()) {
            Step step = (Step)object.previous();
            if (bl) {
                bl = false;
                locationPathPattern2 = PatternParser.convertStep(locationPathPattern2, step);
                continue;
            }
            if (PatternParser.navigationStep(step)) {
                LocationPathPattern locationPathPattern3 = new LocationPathPattern();
                int n = step.getAxis();
                if (n == 2 || n == 12) {
                    locationPathPattern2.setAncestorPattern(locationPathPattern3);
                } else {
                    locationPathPattern2.setParentPattern(locationPathPattern3);
                }
                locationPathPattern2 = locationPathPattern3;
            }
            locationPathPattern2 = PatternParser.convertStep(locationPathPattern2, step);
        }
        if (locationPath.isAbsolute()) {
            object = new LocationPathPattern(NodeTypeTest.DOCUMENT_TEST);
            locationPathPattern2.setParentPattern((Pattern)object);
        }
        return locationPathPattern;
    }

    protected static LocationPathPattern convertStep(LocationPathPattern locationPathPattern, Step step) throws JaxenException {
        if (step instanceof DefaultAllNodeStep) {
            int n = step.getAxis();
            if (n == 9) {
                locationPathPattern.setNodeTest(NodeTypeTest.ATTRIBUTE_TEST);
            } else {
                locationPathPattern.setNodeTest(NodeTypeTest.ELEMENT_TEST);
            }
        } else if (step instanceof DefaultCommentNodeStep) {
            locationPathPattern.setNodeTest(NodeTypeTest.COMMENT_TEST);
        } else if (step instanceof DefaultProcessingInstructionNodeStep) {
            locationPathPattern.setNodeTest(NodeTypeTest.PROCESSING_INSTRUCTION_TEST);
        } else if (step instanceof DefaultTextNodeStep) {
            locationPathPattern.setNodeTest(TextNodeTest.SINGLETON);
        } else if (step instanceof DefaultCommentNodeStep) {
            locationPathPattern.setNodeTest(NodeTypeTest.COMMENT_TEST);
        } else {
            if (step instanceof DefaultNameStep) {
                DefaultNameStep defaultNameStep = (DefaultNameStep)step;
                String string = defaultNameStep.getLocalName();
                String string2 = defaultNameStep.getPrefix();
                int n = defaultNameStep.getAxis();
                short s = 1;
                if (n == 9) {
                    s = 2;
                }
                if (defaultNameStep.isMatchesAnyName()) {
                    if (string2.length() == 0 || string2.equals("*")) {
                        if (n == 9) {
                            locationPathPattern.setNodeTest(NodeTypeTest.ATTRIBUTE_TEST);
                        } else {
                            locationPathPattern.setNodeTest(NodeTypeTest.ELEMENT_TEST);
                        }
                    } else {
                        locationPathPattern.setNodeTest(new NamespaceTest(string2, s));
                    }
                } else {
                    locationPathPattern.setNodeTest(new NameTest(string, s));
                }
                return PatternParser.convertDefaultStep(locationPathPattern, defaultNameStep);
            }
            if (step instanceof DefaultStep) {
                return PatternParser.convertDefaultStep(locationPathPattern, (DefaultStep)step);
            }
            throw new JaxenException("Cannot convert: " + String.valueOf(step) + " to a Pattern");
        }
        return locationPathPattern;
    }

    protected static LocationPathPattern convertDefaultStep(LocationPathPattern locationPathPattern, DefaultStep defaultStep) throws JaxenException {
        List<Predicate> list = defaultStep.getPredicates();
        if (!list.isEmpty()) {
            DefaultFilterExpr defaultFilterExpr = new DefaultFilterExpr(new PredicateSet());
            Iterator<Predicate> iterator = list.iterator();
            while (iterator.hasNext()) {
                defaultFilterExpr.addPredicate(iterator.next());
            }
            locationPathPattern.addFilter(defaultFilterExpr);
        }
        return locationPathPattern;
    }

    protected static boolean navigationStep(Step step) {
        if (step instanceof DefaultNameStep) {
            return true;
        }
        if (step.getClass().equals(DefaultStep.class)) {
            return !step.getPredicates().isEmpty();
        }
        return true;
    }
}

