/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.jdom;

import com.elixirtech.jdom.Comment;
import com.elixirtech.jdom.Content;
import com.elixirtech.jdom.ContentList;
import com.elixirtech.jdom.DescendantIterator;
import com.elixirtech.jdom.DocType;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.FilterIterator;
import com.elixirtech.jdom.IllegalAddException;
import com.elixirtech.jdom.Parent;
import com.elixirtech.jdom.ProcessingInstruction;
import com.elixirtech.jdom.filter.Filter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Document
implements Parent {
    ContentList content = new ContentList(this);
    protected String baseURI;
    private Map<String, Object> propertyMap;

    public Document() {
    }

    public Document(Element element, DocType docType, String string) {
        if (element != null) {
            this.setRootElement(element);
        }
        if (docType != null) {
            this.setDocType(docType);
        }
        if (string != null) {
            this.setBaseURI(string);
        }
    }

    public Document(Element element, DocType docType) {
        this(element, docType, null);
    }

    public Document(Element element) {
        this(element, null, null);
    }

    public Document(List<? extends Content> list) {
        this.setContent(list);
    }

    @Override
    public int getContentSize() {
        return this.content.size();
    }

    @Override
    public int indexOf(Content content) {
        return this.content.indexOf(content);
    }

    public boolean hasRootElement() {
        return this.content.indexOfFirstElement() >= 0;
    }

    public Element getRootElement() {
        int n = this.content.indexOfFirstElement();
        if (n < 0) {
            throw new IllegalStateException("Root element not set");
        }
        return (Element)this.content.get(n);
    }

    public Document setRootElement(Element element) {
        int n = this.content.indexOfFirstElement();
        if (n < 0) {
            this.content.add(element);
        } else {
            this.content.set(n, element);
        }
        return this;
    }

    public Element detachRootElement() {
        int n = this.content.indexOfFirstElement();
        if (n < 0) {
            return null;
        }
        return (Element)this.removeContent(n);
    }

    public DocType getDocType() {
        int n = this.content.indexOfDocType();
        if (n < 0) {
            return null;
        }
        return (DocType)this.content.get(n);
    }

    public Document setDocType(DocType docType) {
        if (docType == null) {
            int n = this.content.indexOfDocType();
            if (n >= 0) {
                this.content.remove(n);
            }
            return this;
        }
        if (docType.getParent() != null) {
            throw new IllegalAddException(docType, "The DocType already is attached to a document");
        }
        int n = this.content.indexOfDocType();
        if (n < 0) {
            this.content.add(0, docType);
        } else {
            this.content.set(n, docType);
        }
        return this;
    }

    public Document addContent(Content content) {
        this.content.add(content);
        return this;
    }

    public Document addContent(Collection<? extends Content> collection) {
        this.content.addAll(collection);
        return this;
    }

    public Document addContent(int n, Content content) {
        this.content.add(n, content);
        return this;
    }

    public Document addContent(int n, Collection<? extends Content> collection) {
        this.content.addAll(n, collection);
        return this;
    }

    @Override
    public List<Content> cloneContent() {
        int n = this.getContentSize();
        ArrayList<Content> arrayList = new ArrayList<Content>(n);
        for (int i = 0; i < n; ++i) {
            Content content = this.getContent(i);
            arrayList.add((Content)content.clone());
        }
        return arrayList;
    }

    @Override
    public Content getContent(int n) {
        return this.content.get(n);
    }

    @Override
    public List<Content> getContent() {
        if (!this.hasRootElement()) {
            throw new IllegalStateException("Root element not set");
        }
        return this.content;
    }

    @Override
    public List getContent(Filter filter) {
        if (!this.hasRootElement()) {
            throw new IllegalStateException("Root element not set");
        }
        return this.content.getView(filter);
    }

    @Override
    public List removeContent() {
        ArrayList<Content> arrayList = new ArrayList<Content>(this.content);
        this.content.clear();
        return arrayList;
    }

    @Override
    public List removeContent(Filter filter) {
        ArrayList<Content> arrayList = new ArrayList<Content>();
        Iterator<Content> iterator = this.content.getView(filter).iterator();
        while (iterator.hasNext()) {
            Content content = iterator.next();
            arrayList.add(content);
            iterator.remove();
        }
        return arrayList;
    }

    public Document setContent(Collection<? extends Content> collection) {
        this.content.clearAndSet(collection);
        return this;
    }

    public final void setBaseURI(String string) {
        this.baseURI = string;
    }

    public final String getBaseURI() {
        return this.baseURI;
    }

    public Document setContent(int n, Content content) {
        this.content.set(n, content);
        return this;
    }

    public Document setContent(int n, Collection<? extends Content> collection) {
        this.content.remove(n);
        this.content.addAll(n, collection);
        return this;
    }

    @Override
    public boolean removeContent(Content content) {
        return this.content.remove(content);
    }

    @Override
    public Content removeContent(int n) {
        return this.content.remove(n);
    }

    public Document setContent(Content content) {
        this.content.clear();
        this.content.add(content);
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append("[Document: ");
        DocType docType = this.getDocType();
        if (docType != null) {
            stringBuffer.append(docType.toString()).append(", ");
        } else {
            stringBuffer.append(" No DOCTYPE declaration, ");
        }
        Element element = this.getRootElement();
        if (element != null) {
            stringBuffer.append("Root is ").append(element.toString());
        } else {
            stringBuffer.append(" No root element");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    @Override
    public Object clone() {
        Document document = null;
        try {
            document = (Document)super.clone();
            document.content = new ContentList(document);
            for (int i = 0; i < this.content.size(); ++i) {
                Content content;
                Content content2 = this.content.get(i);
                if (content2 instanceof Element) {
                    content = (Element)((Element)content2).clone();
                    document.content.add(content);
                    continue;
                }
                if (content2 instanceof Comment) {
                    content = (Comment)((Comment)content2).clone();
                    document.content.add(content);
                    continue;
                }
                if (content2 instanceof ProcessingInstruction) {
                    content = (ProcessingInstruction)((ProcessingInstruction)content2).clone();
                    document.content.add(content);
                    continue;
                }
                if (!(content2 instanceof DocType)) continue;
                content = (DocType)((DocType)content2).clone();
                document.content.add(content);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return document;
    }

    @Override
    public Iterator getDescendants() {
        return new DescendantIterator(this);
    }

    @Override
    public Iterator getDescendants(Filter filter) {
        return new FilterIterator(new DescendantIterator(this), filter);
    }

    @Override
    public Parent getParent() {
        return null;
    }

    @Override
    public Document getDocument() {
        return this;
    }

    public void setProperty(String string, Object object) {
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap<String, Object>();
        }
        this.propertyMap.put(string, object);
    }

    public Object getProperty(String string) {
        if (this.propertyMap == null) {
            return null;
        }
        return this.propertyMap.get(string);
    }
}

