/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.jdom.adapters;

import com.elixirtech.jdom.DocType;
import com.elixirtech.jdom.JDOMException;
import com.elixirtech.jdom.adapters.DOMAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public abstract class AbstractDOMAdapter
implements DOMAdapter {
    @Override
    public Document getDocument(File file, boolean bl) throws IOException, JDOMException {
        return this.getDocument(new FileInputStream(file), bl);
    }

    @Override
    public abstract Document getDocument(InputStream var1, boolean var2) throws IOException, JDOMException;

    @Override
    public abstract Document createDocument() throws JDOMException;

    @Override
    public Document createDocument(DocType docType) throws JDOMException {
        if (docType == null) {
            return this.createDocument();
        }
        DOMImplementation dOMImplementation = this.createDocument().getImplementation();
        DocumentType documentType = dOMImplementation.createDocumentType(docType.getElementName(), docType.getPublicID(), docType.getSystemID());
        this.setInternalSubset(documentType, docType.getInternalSubset());
        return dOMImplementation.createDocument("http://temporary", docType.getElementName(), documentType);
    }

    protected void setInternalSubset(DocumentType documentType, String string) {
        if (documentType == null || string == null) {
            return;
        }
        try {
            Class<?> clazz = documentType.getClass();
            Method method = clazz.getMethod("setInternalSubset", String.class);
            method.invoke((Object)documentType, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

