/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn;

import com.elixirtech.limn.Point3d;
import java.awt.geom.Rectangle2D;

public class ArrayOf3dPoints {
    public double[] x;
    public double[] y;
    public double[] z;
    public int npoints;

    public ArrayOf3dPoints(double[] dArray, double[] dArray2, double[] dArray3, int n) {
        this.x = dArray;
        this.y = dArray2;
        this.z = dArray3;
        this.npoints = n;
    }

    public ArrayOf3dPoints(int n) {
        this.npoints = n;
        this.x = new double[n];
        this.y = new double[n];
        this.z = new double[n];
    }

    public ArrayOf3dPoints(ArrayOf3dPoints arrayOf3dPoints, ArrayOf3dPoints arrayOf3dPoints2) {
        this.npoints = arrayOf3dPoints.npoints + arrayOf3dPoints2.npoints;
        this.x = new double[this.npoints];
        this.y = new double[this.npoints];
        this.z = new double[this.npoints];
        System.arraycopy(arrayOf3dPoints.x, 0, this.x, 0, arrayOf3dPoints.npoints);
        System.arraycopy(arrayOf3dPoints.y, 0, this.y, 0, arrayOf3dPoints.npoints);
        System.arraycopy(arrayOf3dPoints.z, 0, this.z, 0, arrayOf3dPoints.npoints);
        System.arraycopy(arrayOf3dPoints2.x, 0, this.x, arrayOf3dPoints.npoints, arrayOf3dPoints2.npoints);
        System.arraycopy(arrayOf3dPoints2.y, 0, this.y, arrayOf3dPoints.npoints, arrayOf3dPoints2.npoints);
        System.arraycopy(arrayOf3dPoints2.z, 0, this.z, arrayOf3dPoints.npoints, arrayOf3dPoints2.npoints);
    }

    public void setPoint(int n, double d, double d2, double d3) {
        this.x[n] = d;
        this.y[n] = d2;
        this.z[n] = d3;
    }

    public void setPoint(int n, Point3d point3d) {
        this.x[n] = point3d.x;
        this.y[n] = point3d.y;
        this.z[n] = point3d.z;
    }

    Rectangle2D get2DBoundingBox() {
        if (this.npoints == 0) {
            return null;
        }
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MIN_VALUE;
        for (int i = 0; i < this.npoints; ++i) {
            d = Math.min(d, this.x[i]);
            d2 = Math.max(d2, this.x[i]);
            d3 = Math.min(d3, this.y[i]);
            d4 = Math.max(d4, this.y[i]);
        }
        return new Rectangle2D.Double(d, d3, d2 - d, d4 - d3);
    }

    public Point3d getPoint(int n) {
        return new Point3d(this.x[n], this.y[n], this.z[n]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" " + this.npoints + "\n");
        for (int i = 0; i < this.npoints; ++i) {
            stringBuilder.append(this.x[i] + " " + this.y[i] + " " + this.z[i] + "\n");
        }
        return stringBuilder.toString();
    }

    ArrayOf3dPoints makeClone() {
        double[] dArray = new double[this.npoints];
        System.arraycopy(this.x, 0, dArray, 0, this.npoints);
        double[] dArray2 = new double[this.npoints];
        System.arraycopy(this.y, 0, dArray2, 0, this.npoints);
        double[] dArray3 = new double[this.npoints];
        System.arraycopy(this.z, 0, dArray3, 0, this.npoints);
        return new ArrayOf3dPoints(dArray, dArray2, dArray3, this.npoints);
    }
}

