/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn;

import com.elixirtech.limn.Angle3d;
import com.elixirtech.limn.ArrayOf3dPoints;
import com.elixirtech.limn.IndexingPolygon;
import com.elixirtech.limn.Matrix3d;
import com.elixirtech.limn.Point3d;
import com.elixirtech.limn.Polyhedron;
import com.elixirtech.limn.RenderContext;
import com.elixirtech.limn.RenderedPolygon;
import com.elixirtech.limn.World;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class Object3d {
    protected World m_World;
    protected Point3d m_Position;
    protected Angle3d m_Angle;
    protected Properties m_Properties = new Properties();
    private Matrix3d m_TransformMatrix;
    private Polyhedron m_Polyhedron;
    private boolean m_VerticesAreDirty;
    private boolean m_MatrixIsDirty;
    private Point3d m_Scale;

    public Object3d(World world, Point3d point3d, Angle3d angle3d) {
        this.m_World = world;
        this.m_Position = point3d.makeClone();
        this.m_Angle = angle3d.makeClone();
        world.add(this);
    }

    public void setId(String string) {
        this.m_Polyhedron.setId(string);
    }

    protected void setPolyhedron(Polyhedron polyhedron, Point3d point3d) {
        this.m_Polyhedron = polyhedron;
        this.m_TransformMatrix = new Matrix3d();
        this.m_Scale = point3d;
        this.m_VerticesAreDirty = true;
        this.m_MatrixIsDirty = true;
    }

    public void setProperty(String string, String string2) {
        this.m_Properties.setProperty(string, string2);
    }

    public String getProperty(String string) {
        return this.m_Properties.getProperty(string);
    }

    public final double distanceToPoint(Point3d point3d) {
        return Math.sqrt(this.m_Position.distanceToPoint2(point3d));
    }

    public Rectangle2D getBoundingBox(RenderContext renderContext) {
        this.updateVertices();
        ArrayOf3dPoints arrayOf3dPoints = this.m_Polyhedron.getTransformedVertices();
        ArrayOf3dPoints arrayOf3dPoints2 = renderContext.getCamera().project(arrayOf3dPoints);
        Rectangle2D rectangle2D = arrayOf3dPoints2.get2DBoundingBox();
        ArrayList<RenderedPolygon.Face> arrayList = new ArrayList<RenderedPolygon.Face>();
        this.m_Polyhedron.buildFaces(arrayList);
        for (RenderedPolygon.Face face : arrayList) {
            Rectangle2D rectangle2D2 = face.getBoundingBox(renderContext, arrayOf3dPoints);
            if (rectangle2D2 == null) continue;
            Rectangle2D.union(rectangle2D, rectangle2D2, rectangle2D);
        }
        return rectangle2D;
    }

    public Polyhedron getPolyhedron() {
        return this.m_Polyhedron;
    }

    public void update(RenderContext renderContext) {
        this.updateVertices();
        ArrayOf3dPoints arrayOf3dPoints = this.m_Polyhedron.getTransformedVertices();
        ArrayOf3dPoints arrayOf3dPoints2 = new ArrayOf3dPoints(arrayOf3dPoints.npoints);
        renderContext.getCamera().doTransform(this.m_Polyhedron.getTransformedVertices(), arrayOf3dPoints2);
        ArrayOf3dPoints arrayOf3dPoints3 = new ArrayOf3dPoints(arrayOf3dPoints.npoints);
        renderContext.getCamera().doProjection(arrayOf3dPoints2, arrayOf3dPoints3);
        this.m_Polyhedron.setViewPoints(arrayOf3dPoints2);
        this.m_Polyhedron.setProjectedPoints(arrayOf3dPoints3);
        this.updateIntensities(renderContext.getLight());
    }

    protected void updateIntensities(Point3d point3d) {
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.makeIdentity();
        matrix3d.concatRx(-this.m_Angle.x);
        matrix3d.concatRy(-this.m_Angle.y);
        matrix3d.concatRz(-this.m_Angle.z);
        Point3d point3d2 = new Point3d();
        matrix3d.transformPoint(point3d, point3d2);
        this.m_Polyhedron.calculateIntensities(point3d2);
    }

    private void updateVertices() {
        if (this.m_VerticesAreDirty) {
            this.updateMatrix();
            this.m_TransformMatrix.transform(this.m_Polyhedron.getVertices(), this.m_Polyhedron.getTransformedVertices());
            this.m_VerticesAreDirty = false;
        }
    }

    private void updateMatrix() {
        if (this.m_MatrixIsDirty) {
            this.m_TransformMatrix.makeMCStoWCStransform(this.m_Position, this.m_Angle, this.m_Scale);
            this.m_MatrixIsDirty = false;
        }
    }

    public void transformPoint(Point3d point3d, Point3d point3d2) {
        this.updateMatrix();
        this.m_TransformMatrix.transformPoint(point3d, point3d2);
    }

    void transformPoints(ArrayOf3dPoints arrayOf3dPoints, ArrayOf3dPoints arrayOf3dPoints2) {
        this.updateMatrix();
        this.m_TransformMatrix.transform(arrayOf3dPoints, arrayOf3dPoints2);
    }

    void rotateNormals(ArrayOf3dPoints arrayOf3dPoints, ArrayOf3dPoints arrayOf3dPoints2) {
        this.updateMatrix();
        this.m_TransformMatrix.rotate(arrayOf3dPoints, arrayOf3dPoints2);
    }

    public void setScalingFactor(Point3d point3d) {
        this.m_Scale.set(point3d);
        this.m_VerticesAreDirty = true;
        this.m_MatrixIsDirty = true;
    }

    public Point3d getScalingFactor() {
        return this.m_Scale.makeClone();
    }

    public final Point3d getPosition() {
        return this.m_Position.makeClone();
    }

    public final Angle3d getAngle() {
        return this.m_Angle.makeClone();
    }

    public Point3d getWorldCoordForRelativePoint(Point3d point3d) {
        Point3d point3d2 = new Point3d();
        this.transformPoint(point3d, point3d2);
        return point3d2;
    }

    public void buildPolygons(List<IndexingPolygon> list) {
        boolean bl = this.m_Polyhedron.isTranslucent();
        IndexingPolygon[] indexingPolygonArray = this.m_Polyhedron.m_Polygons;
        for (int i = 0; i < indexingPolygonArray.length; ++i) {
            if (!bl && indexingPolygonArray[i].isBackFace()) continue;
            list.add(indexingPolygonArray[i]);
        }
    }

    public IndexingPolygon getPolygon(String string) {
        IndexingPolygon[] indexingPolygonArray = this.m_Polyhedron.m_Polygons;
        for (int i = 0; i < indexingPolygonArray.length; ++i) {
            if (!string.equals(indexingPolygonArray[i].toString())) continue;
            return indexingPolygonArray[i];
        }
        return null;
    }

    protected final World getWorld() {
        return this.m_World;
    }
}

