/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.limn;

import com.elixirtech.limn.ArrayOf3dPoints;
import com.elixirtech.limn.IndexingPolygon;
import com.elixirtech.limn.Object3d;
import com.elixirtech.limn.Point3d;
import com.elixirtech.limn.RenderContext;
import com.elixirtech.limn.RenderedPolygon;
import java.awt.Graphics2D;
import java.util.List;

public class Polyhedron {
    protected String m_Id;
    protected ArrayOf3dPoints m_Vertices;
    protected ArrayOf3dPoints m_TransformedVertices;
    protected final IndexingPolygon[] m_Polygons;
    protected ArrayOf3dPoints m_ProjectedPoints;
    protected ArrayOf3dPoints m_ViewPoints;
    protected Object m_Object;

    public Polyhedron(ArrayOf3dPoints arrayOf3dPoints, IndexingPolygon[] indexingPolygonArray) {
        this.m_Vertices = arrayOf3dPoints;
        this.m_TransformedVertices = new ArrayOf3dPoints(arrayOf3dPoints.npoints);
        this.m_Polygons = indexingPolygonArray;
        for (int i = 0; i < indexingPolygonArray.length; ++i) {
            indexingPolygonArray[i].setPolyhedron(this);
        }
    }

    public void setObject(Object3d object3d) {
        if (this.m_Object != null) {
            throw new RuntimeException("Object already set");
        }
        this.m_Object = object3d;
    }

    public int getPolygonCount() {
        return this.m_Polygons.length;
    }

    public int getPolygonIndex(IndexingPolygon indexingPolygon) {
        for (int i = 0; i < this.m_Polygons.length; ++i) {
            if (this.m_Polygons[i] != indexingPolygon) continue;
            return i;
        }
        return -1;
    }

    public boolean isTranslucent() {
        for (int i = 0; i < this.m_Polygons.length; ++i) {
            if (!this.m_Polygons[i].isTranslucent()) continue;
            return true;
        }
        return false;
    }

    public IndexingPolygon getPolygon(int n) {
        return this.m_Polygons[n];
    }

    public void buildFaces(List<RenderedPolygon.Face> list) {
        for (int i = 0; i < this.m_Polygons.length; ++i) {
            this.m_Polygons[i].buildFaces(list);
        }
    }

    public void setViewPoints(ArrayOf3dPoints arrayOf3dPoints) {
        this.m_ViewPoints = arrayOf3dPoints.makeClone();
    }

    public ArrayOf3dPoints getViewPoints() {
        return this.m_ViewPoints;
    }

    public void setProjectedPoints(ArrayOf3dPoints arrayOf3dPoints) {
        this.m_ProjectedPoints = arrayOf3dPoints.makeClone();
    }

    public ArrayOf3dPoints getProjectedPoints() {
        return this.m_ProjectedPoints;
    }

    public void paint(Graphics2D graphics2D, RenderContext renderContext) {
        for (int i = 0; i < this.m_Polygons.length; ++i) {
            this.m_Polygons[i].paint(graphics2D, renderContext);
        }
    }

    public Polyhedron makeClone() {
        IndexingPolygon[] indexingPolygonArray = new IndexingPolygon[this.m_Polygons.length];
        for (int i = 0; i < this.m_Polygons.length; ++i) {
            indexingPolygonArray[i] = this.m_Polygons[i].makeClone();
        }
        return new Polyhedron(this.m_Vertices.makeClone(), indexingPolygonArray);
    }

    public void calculateIntensities(Point3d point3d) {
        Point3d point3d2 = new Point3d();
        for (int i = 0; i < this.m_Polygons.length; ++i) {
            this.m_Polygons[i].getNormal(point3d2);
            double d = point3d2.dotProduct(point3d);
            this.m_Polygons[i].setIntensity(d);
        }
    }

    public ArrayOf3dPoints getVertices() {
        return this.m_Vertices;
    }

    public void setVertices(ArrayOf3dPoints arrayOf3dPoints) {
        this.m_Vertices = arrayOf3dPoints;
    }

    public void scalePoints(double d, double d2, double d3) {
        int n = 0;
        while (n < this.m_Vertices.npoints) {
            int n2 = n;
            this.m_Vertices.x[n2] = this.m_Vertices.x[n2] * d;
            int n3 = n;
            this.m_Vertices.y[n3] = this.m_Vertices.y[n3] * d2;
            int n4 = n++;
            this.m_Vertices.z[n4] = this.m_Vertices.z[n4] * d3;
        }
    }

    public ArrayOf3dPoints getTransformedVertices() {
        return this.m_TransformedVertices;
    }

    public void setId(String string) {
        this.m_Id = string;
    }

    public String getId() {
        return this.m_Id;
    }

    public String toString() {
        return this.m_Id;
    }
}

